import { type BytesView } from "@zwave-js/shared";
import type { KeyPair } from "@zwave-js/shared/bindings";
declare function randomBytes(length: number): BytesView;
/** Encrypts a payload using AES-128-ECB (as described in SDS10865) */
declare function encryptAES128ECB(plaintext: BytesView, key: BytesView): Promise<BytesView>;
/** Encrypts a payload using AES-OFB (as described in SDS10865) */
declare function encryptAES128OFB(plaintext: BytesView, key: BytesView, iv: BytesView): Promise<BytesView>;
/** Decrypts a payload using AES-OFB */
declare function decryptAES128OFB(ciphertext: BytesView, key: BytesView, iv: BytesView): Promise<BytesView>;
declare function encryptAES128CBC(plaintext: BytesView, key: BytesView, iv: BytesView): Promise<BytesView>;
/** Decrypts a payload using AES-256-CBC */
declare function decryptAES256CBC(ciphertext: BytesView, key: BytesView, iv: BytesView): Promise<BytesView>;
declare function encryptAES128CCM(plaintext: BytesView, key: BytesView, iv: BytesView, additionalData: BytesView, authTagLength: number): Promise<{
    ciphertext: BytesView;
    authTag: BytesView;
}>;
declare function decryptAES128CCM(ciphertext: BytesView, key: BytesView, iv: BytesView, additionalData: BytesView, authTag: BytesView): Promise<{
    plaintext: BytesView;
    authOK: boolean;
}>;
declare function digest(algorithm: "md5" | "sha-1" | "sha-256", data: BytesView): Promise<BytesView>;
/** Generates an x25519 / ECDH key pair */
declare function generateECDHKeyPair(): Promise<KeyPair>;
declare function keyPairFromRawECDHPrivateKey(privateKey: BytesView): Promise<KeyPair>;
declare function deriveSharedECDHSecret(keyPair: KeyPair): Promise<BytesView>;
export declare const primitives: {
    randomBytes: typeof randomBytes;
    encryptAES128ECB: typeof encryptAES128ECB;
    encryptAES128CBC: typeof encryptAES128CBC;
    encryptAES128OFB: typeof encryptAES128OFB;
    decryptAES128OFB: typeof decryptAES128OFB;
    encryptAES128CCM: typeof encryptAES128CCM;
    decryptAES128CCM: typeof decryptAES128CCM;
    decryptAES256CBC: typeof decryptAES256CBC;
    digest: typeof digest;
    generateECDHKeyPair: typeof generateECDHKeyPair;
    keyPairFromRawECDHPrivateKey: typeof keyPairFromRawECDHPrivateKey;
    deriveSharedECDHSecret: typeof deriveSharedECDHSecret;
};
export {};
//# sourceMappingURL=primitives.node.d.ts.map