"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var primitives_node_exports = {};
__export(primitives_node_exports, {
  primitives: () => primitives
});
module.exports = __toCommonJS(primitives_node_exports);
var import_shared = require("@zwave-js/shared");
var import_node_crypto = __toESM(require("node:crypto"), 1);
var import_shared2 = require("../shared.js");
function randomBytes(length) {
  return import_node_crypto.default.randomBytes(length);
}
__name(randomBytes, "randomBytes");
function encrypt(algorithm, blockSize, trimToInputLength, input, key, iv) {
  const cipher = import_node_crypto.default.createCipheriv(algorithm, key, iv);
  cipher.setAutoPadding(false);
  const { output: plaintext, paddingLength } = (0, import_shared2.zeroPad)(input, blockSize);
  const ret = import_shared.Bytes.concat([cipher.update(plaintext), cipher.final()]);
  if (trimToInputLength && paddingLength > 0) {
    return ret.subarray(0, -paddingLength);
  } else {
    return ret;
  }
}
__name(encrypt, "encrypt");
function decrypt(algorithm, blockSize, trimToInputLength, input, key, iv) {
  const cipher = import_node_crypto.default.createDecipheriv(algorithm, key, iv);
  cipher.setAutoPadding(false);
  const { output: ciphertext, paddingLength } = (0, import_shared2.zeroPad)(input, blockSize);
  const ret = import_shared.Bytes.concat([cipher.update(ciphertext), cipher.final()]);
  if (trimToInputLength && paddingLength > 0) {
    return ret.subarray(0, -paddingLength);
  } else {
    return ret;
  }
}
__name(decrypt, "decrypt");
function encryptAES128ECB(plaintext, key) {
  return Promise.resolve(encrypt("aes-128-ecb", import_shared2.BLOCK_SIZE, false, plaintext, key, new Uint8Array()));
}
__name(encryptAES128ECB, "encryptAES128ECB");
function encryptAES128OFB(plaintext, key, iv) {
  return Promise.resolve(encrypt("aes-128-ofb", import_shared2.BLOCK_SIZE, true, plaintext, key, iv));
}
__name(encryptAES128OFB, "encryptAES128OFB");
function decryptAES128OFB(ciphertext, key, iv) {
  return Promise.resolve(decrypt("aes-128-ofb", import_shared2.BLOCK_SIZE, true, ciphertext, key, iv));
}
__name(decryptAES128OFB, "decryptAES128OFB");
function encryptAES128CBC(plaintext, key, iv) {
  return Promise.resolve(encrypt("aes-128-cbc", import_shared2.BLOCK_SIZE, false, plaintext, key, iv));
}
__name(encryptAES128CBC, "encryptAES128CBC");
function decryptAES256CBC(ciphertext, key, iv) {
  return Promise.resolve(decrypt("aes-256-cbc", import_shared2.BLOCK_SIZE, true, ciphertext, key, iv));
}
__name(decryptAES256CBC, "decryptAES256CBC");
function encryptAES128CCM(plaintext, key, iv, additionalData, authTagLength) {
  const algorithm = `aes-128-ccm`;
  const cipher = import_node_crypto.default.createCipheriv(algorithm, key, iv, { authTagLength });
  cipher.setAAD(additionalData, { plaintextLength: plaintext.length });
  const ciphertext = cipher.update(plaintext);
  cipher.final();
  const authTag = cipher.getAuthTag();
  return Promise.resolve({ ciphertext, authTag });
}
__name(encryptAES128CCM, "encryptAES128CCM");
function decryptAES128CCM(ciphertext, key, iv, additionalData, authTag) {
  const algorithm = `aes-128-ccm`;
  const decipher = import_node_crypto.default.createDecipheriv(algorithm, key, iv, {
    authTagLength: authTag.length
  });
  decipher.setAuthTag(authTag);
  decipher.setAAD(additionalData, { plaintextLength: ciphertext.length });
  const plaintext = decipher.update(ciphertext);
  let authOK = false;
  try {
    decipher.final();
    authOK = true;
  } catch {
  }
  return Promise.resolve({ plaintext, authOK });
}
__name(decryptAES128CCM, "decryptAES128CCM");
function digest(algorithm, data) {
  const nodeAlgorithm = algorithm === "sha-1" ? "sha1" : algorithm === "sha-256" ? "sha256" : algorithm;
  const hash = import_node_crypto.default.createHash(nodeAlgorithm);
  hash.update(data);
  return Promise.resolve(hash.digest());
}
__name(digest, "digest");
function extractRawECDHPublicKey(publicKey) {
  return (0, import_shared2.decodeX25519KeyDER)(publicKey.export({
    type: "spki",
    format: "der"
  }));
}
__name(extractRawECDHPublicKey, "extractRawECDHPublicKey");
function importRawECDHPublicKey(publicKey) {
  return import_node_crypto.default.createPublicKey({
    // eslint-disable-next-line no-restricted-globals -- crypto API requires Buffer instances
    key: Buffer.from((0, import_shared2.encodeX25519KeyDERSPKI)(publicKey).buffer),
    format: "der",
    type: "spki"
  });
}
__name(importRawECDHPublicKey, "importRawECDHPublicKey");
function extractRawECDHPrivateKey(privateKey) {
  return (0, import_shared2.decodeX25519KeyDER)(privateKey.export({
    type: "pkcs8",
    format: "der"
  }));
}
__name(extractRawECDHPrivateKey, "extractRawECDHPrivateKey");
function importRawECDHPrivateKey(privateKey) {
  return import_node_crypto.default.createPrivateKey({
    // eslint-disable-next-line no-restricted-globals -- crypto API requires Buffer instances
    key: Buffer.from((0, import_shared2.encodeX25519KeyDERPKCS8)(privateKey).buffer),
    format: "der",
    type: "pkcs8"
  });
}
__name(importRawECDHPrivateKey, "importRawECDHPrivateKey");
function generateECDHKeyPair() {
  const pair = import_node_crypto.default.generateKeyPairSync("x25519");
  const publicKey = extractRawECDHPublicKey(pair.publicKey);
  const privateKey = extractRawECDHPrivateKey(pair.privateKey);
  return Promise.resolve({ publicKey, privateKey });
}
__name(generateECDHKeyPair, "generateECDHKeyPair");
function keyPairFromRawECDHPrivateKey(privateKey) {
  const privateKeyObject = importRawECDHPrivateKey(privateKey);
  const publicKeyObject = import_node_crypto.default.createPublicKey(privateKeyObject);
  const publicKey = extractRawECDHPublicKey(publicKeyObject);
  return Promise.resolve({
    privateKey,
    publicKey
  });
}
__name(keyPairFromRawECDHPrivateKey, "keyPairFromRawECDHPrivateKey");
function deriveSharedECDHSecret(keyPair) {
  const publicKey = importRawECDHPublicKey(keyPair.publicKey);
  const privateKey = importRawECDHPrivateKey(keyPair.privateKey);
  const ret = import_node_crypto.default.diffieHellman({ publicKey, privateKey });
  return Promise.resolve(ret);
}
__name(deriveSharedECDHSecret, "deriveSharedECDHSecret");
const primitives = {
  randomBytes,
  encryptAES128ECB,
  encryptAES128CBC,
  encryptAES128OFB,
  decryptAES128OFB,
  encryptAES128CCM,
  decryptAES128CCM,
  decryptAES256CBC,
  digest,
  generateECDHKeyPair,
  keyPairFromRawECDHPrivateKey,
  deriveSharedECDHSecret
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  primitives
});
//# sourceMappingURL=primitives.node.js.map
