import { type BytesView } from "@zwave-js/shared";
export declare const BLOCK_SIZE = 16;
export declare function zeroPad(input: BytesView, blockSize: number): {
    output: BytesView;
    paddingLength: number;
};
/** Left-Shifts a buffer by 1 bit */
export declare function leftShift1(input: BytesView): BytesView;
/** Computes the byte-wise XOR of two buffers with the same length */
export declare function xor(b1: BytesView, b2: BytesView): BytesView;
/** Increments a multi-byte integer in a buffer */
export declare function increment(buffer: BytesView): void;
/** Decodes a DER-encoded x25519 key (PKCS#8 or SPKI) */
export declare function decodeX25519KeyDER(key: BytesView): BytesView;
/** Encodes an x25519 key from a raw buffer with DER/PKCS#8 */
export declare function encodeX25519KeyDERPKCS8(key: BytesView): BytesView;
/** Encodes an x25519 key from a raw buffer with DER/SPKI */
export declare function encodeX25519KeyDERSPKI(key: BytesView): BytesView;
//# sourceMappingURL=shared.d.ts.map