"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var CommandClasses_exports = {};
__export(CommandClasses_exports, {
  CommandClasses: () => CommandClasses,
  actuatorCCs: () => actuatorCCs,
  allCCs: () => allCCs,
  applicationCCs: () => applicationCCs,
  encapsulationCCs: () => encapsulationCCs,
  getCCName: () => getCCName,
  isActuatorCC: () => isActuatorCC,
  isApplicationCC: () => isApplicationCC,
  isCCInfoEqual: () => isCCInfoEqual,
  isEncapsulationCC: () => isEncapsulationCC,
  isManagementCC: () => isManagementCC,
  isSensorCC: () => isSensorCC,
  managementCCs: () => managementCCs,
  nonApplicationCCs: () => nonApplicationCCs,
  sensorCCs: () => sensorCCs
});
module.exports = __toCommonJS(CommandClasses_exports);
var import_shared = require("@zwave-js/shared");
var CommandClasses;
(function(CommandClasses2) {
  CommandClasses2[CommandClasses2["Alarm Sensor"] = 156] = "Alarm Sensor";
  CommandClasses2[CommandClasses2["Alarm Silence"] = 157] = "Alarm Silence";
  CommandClasses2[CommandClasses2["All Switch"] = 39] = "All Switch";
  CommandClasses2[CommandClasses2["Anti-Theft"] = 93] = "Anti-Theft";
  CommandClasses2[CommandClasses2["Anti-Theft Unlock"] = 126] = "Anti-Theft Unlock";
  CommandClasses2[CommandClasses2["Application Capability"] = 87] = "Application Capability";
  CommandClasses2[CommandClasses2["Application Status"] = 34] = "Application Status";
  CommandClasses2[CommandClasses2["Association"] = 133] = "Association";
  CommandClasses2[CommandClasses2["Association Command Configuration"] = 155] = "Association Command Configuration";
  CommandClasses2[CommandClasses2["Association Group Information"] = 89] = "Association Group Information";
  CommandClasses2[CommandClasses2["Authentication"] = 161] = "Authentication";
  CommandClasses2[CommandClasses2["Authentication Media Write"] = 162] = "Authentication Media Write";
  CommandClasses2[CommandClasses2["Barrier Operator"] = 102] = "Barrier Operator";
  CommandClasses2[CommandClasses2["Basic"] = 32] = "Basic";
  CommandClasses2[CommandClasses2["Basic Tariff Information"] = 54] = "Basic Tariff Information";
  CommandClasses2[CommandClasses2["Basic Window Covering"] = 80] = "Basic Window Covering";
  CommandClasses2[CommandClasses2["Battery"] = 128] = "Battery";
  CommandClasses2[CommandClasses2["Binary Sensor"] = 48] = "Binary Sensor";
  CommandClasses2[CommandClasses2["Binary Switch"] = 37] = "Binary Switch";
  CommandClasses2[CommandClasses2["Binary Toggle Switch"] = 40] = "Binary Toggle Switch";
  CommandClasses2[CommandClasses2["Central Scene"] = 91] = "Central Scene";
  CommandClasses2[CommandClasses2["Climate Control Schedule"] = 70] = "Climate Control Schedule";
  CommandClasses2[CommandClasses2["Clock"] = 129] = "Clock";
  CommandClasses2[CommandClasses2["Color Switch"] = 51] = "Color Switch";
  CommandClasses2[CommandClasses2["Configuration"] = 112] = "Configuration";
  CommandClasses2[CommandClasses2["Controller Replication"] = 33] = "Controller Replication";
  CommandClasses2[CommandClasses2["CRC-16 Encapsulation"] = 86] = "CRC-16 Encapsulation";
  CommandClasses2[CommandClasses2["Demand Control Plan Configuration"] = 58] = "Demand Control Plan Configuration";
  CommandClasses2[CommandClasses2["Demand Control Plan Monitor"] = 59] = "Demand Control Plan Monitor";
  CommandClasses2[CommandClasses2["Device Reset Locally"] = 90] = "Device Reset Locally";
  CommandClasses2[CommandClasses2["Door Lock"] = 98] = "Door Lock";
  CommandClasses2[CommandClasses2["Door Lock Logging"] = 76] = "Door Lock Logging";
  CommandClasses2[CommandClasses2["Energy Production"] = 144] = "Energy Production";
  CommandClasses2[CommandClasses2["Entry Control"] = 111] = "Entry Control";
  CommandClasses2[CommandClasses2["Firmware Update Meta Data"] = 122] = "Firmware Update Meta Data";
  CommandClasses2[CommandClasses2["Generic Schedule"] = 163] = "Generic Schedule";
  CommandClasses2[CommandClasses2["Geographic Location"] = 140] = "Geographic Location";
  CommandClasses2[CommandClasses2["Grouping Name"] = 123] = "Grouping Name";
  CommandClasses2[CommandClasses2["Hail"] = 130] = "Hail";
  CommandClasses2[CommandClasses2["HRV Control"] = 57] = "HRV Control";
  CommandClasses2[CommandClasses2["HRV Status"] = 55] = "HRV Status";
  CommandClasses2[CommandClasses2["Humidity Control Mode"] = 109] = "Humidity Control Mode";
  CommandClasses2[CommandClasses2["Humidity Control Operating State"] = 110] = "Humidity Control Operating State";
  CommandClasses2[CommandClasses2["Humidity Control Setpoint"] = 100] = "Humidity Control Setpoint";
  CommandClasses2[CommandClasses2["Inclusion Controller"] = 116] = "Inclusion Controller";
  CommandClasses2[CommandClasses2["Indicator"] = 135] = "Indicator";
  CommandClasses2[CommandClasses2["IP Association"] = 92] = "IP Association";
  CommandClasses2[CommandClasses2["IP Configuration"] = 154] = "IP Configuration";
  CommandClasses2[CommandClasses2["IR Repeater"] = 160] = "IR Repeater";
  CommandClasses2[CommandClasses2["Irrigation"] = 107] = "Irrigation";
  CommandClasses2[CommandClasses2["Language"] = 137] = "Language";
  CommandClasses2[CommandClasses2["Lock"] = 118] = "Lock";
  CommandClasses2[CommandClasses2["Mailbox"] = 105] = "Mailbox";
  CommandClasses2[CommandClasses2["Manufacturer Proprietary"] = 145] = "Manufacturer Proprietary";
  CommandClasses2[CommandClasses2["Manufacturer Specific"] = 114] = "Manufacturer Specific";
  CommandClasses2[CommandClasses2["Meter"] = 50] = "Meter";
  CommandClasses2[CommandClasses2["Meter Table Configuration"] = 60] = "Meter Table Configuration";
  CommandClasses2[CommandClasses2["Meter Table Monitor"] = 61] = "Meter Table Monitor";
  CommandClasses2[CommandClasses2["Meter Table Push Configuration"] = 62] = "Meter Table Push Configuration";
  CommandClasses2[CommandClasses2["Move To Position Window Covering"] = 81] = "Move To Position Window Covering";
  CommandClasses2[CommandClasses2["Multi Channel"] = 96] = "Multi Channel";
  CommandClasses2[CommandClasses2["Multi Channel Association"] = 142] = "Multi Channel Association";
  CommandClasses2[CommandClasses2["Multi Command"] = 143] = "Multi Command";
  CommandClasses2[CommandClasses2["Multilevel Sensor"] = 49] = "Multilevel Sensor";
  CommandClasses2[CommandClasses2["Multilevel Switch"] = 38] = "Multilevel Switch";
  CommandClasses2[CommandClasses2["Multilevel Toggle Switch"] = 41] = "Multilevel Toggle Switch";
  CommandClasses2[CommandClasses2["Network Management Basic Node"] = 77] = "Network Management Basic Node";
  CommandClasses2[CommandClasses2["Network Management Inclusion"] = 52] = "Network Management Inclusion";
  CommandClasses2[CommandClasses2["Network Management Installation and Maintenance"] = 103] = "Network Management Installation and Maintenance";
  CommandClasses2[CommandClasses2["Network Management Primary"] = 84] = "Network Management Primary";
  CommandClasses2[CommandClasses2["Network Management Proxy"] = 82] = "Network Management Proxy";
  CommandClasses2[CommandClasses2["No Operation"] = 0] = "No Operation";
  CommandClasses2[CommandClasses2["Node Naming and Location"] = 119] = "Node Naming and Location";
  CommandClasses2[CommandClasses2["Node Provisioning"] = 120] = "Node Provisioning";
  CommandClasses2[CommandClasses2["Notification"] = 113] = "Notification";
  CommandClasses2[CommandClasses2["Powerlevel"] = 115] = "Powerlevel";
  CommandClasses2[CommandClasses2["Prepayment"] = 63] = "Prepayment";
  CommandClasses2[CommandClasses2["Prepayment Encapsulation"] = 65] = "Prepayment Encapsulation";
  CommandClasses2[CommandClasses2["Proprietary"] = 136] = "Proprietary";
  CommandClasses2[CommandClasses2["Protection"] = 117] = "Protection";
  CommandClasses2[CommandClasses2["Pulse Meter"] = 53] = "Pulse Meter";
  CommandClasses2[CommandClasses2["Rate Table Configuration"] = 72] = "Rate Table Configuration";
  CommandClasses2[CommandClasses2["Rate Table Monitor"] = 73] = "Rate Table Monitor";
  CommandClasses2[CommandClasses2["Remote Association Activation"] = 124] = "Remote Association Activation";
  CommandClasses2[CommandClasses2["Remote Association Configuration"] = 125] = "Remote Association Configuration";
  CommandClasses2[CommandClasses2["Scene Activation"] = 43] = "Scene Activation";
  CommandClasses2[CommandClasses2["Scene Actuator Configuration"] = 44] = "Scene Actuator Configuration";
  CommandClasses2[CommandClasses2["Scene Controller Configuration"] = 45] = "Scene Controller Configuration";
  CommandClasses2[CommandClasses2["Schedule"] = 83] = "Schedule";
  CommandClasses2[CommandClasses2["Schedule Entry Lock"] = 78] = "Schedule Entry Lock";
  CommandClasses2[CommandClasses2["Screen Attributes"] = 147] = "Screen Attributes";
  CommandClasses2[CommandClasses2["Screen Meta Data"] = 146] = "Screen Meta Data";
  CommandClasses2[CommandClasses2["Security"] = 152] = "Security";
  CommandClasses2[CommandClasses2["Security 2"] = 159] = "Security 2";
  CommandClasses2[CommandClasses2["Security Mark"] = 61696] = "Security Mark";
  CommandClasses2[CommandClasses2["Sensor Configuration"] = 158] = "Sensor Configuration";
  CommandClasses2[CommandClasses2["Simple AV Control"] = 148] = "Simple AV Control";
  CommandClasses2[CommandClasses2["Sound Switch"] = 121] = "Sound Switch";
  CommandClasses2[CommandClasses2["Supervision"] = 108] = "Supervision";
  CommandClasses2[CommandClasses2["Support/Control Mark"] = 239] = "Support/Control Mark";
  CommandClasses2[CommandClasses2["Tariff Table Configuration"] = 74] = "Tariff Table Configuration";
  CommandClasses2[CommandClasses2["Tariff Table Monitor"] = 75] = "Tariff Table Monitor";
  CommandClasses2[CommandClasses2["Thermostat Fan Mode"] = 68] = "Thermostat Fan Mode";
  CommandClasses2[CommandClasses2["Thermostat Fan State"] = 69] = "Thermostat Fan State";
  CommandClasses2[CommandClasses2["Thermostat Mode"] = 64] = "Thermostat Mode";
  CommandClasses2[CommandClasses2["Thermostat Operating State"] = 66] = "Thermostat Operating State";
  CommandClasses2[CommandClasses2["Thermostat Setback"] = 71] = "Thermostat Setback";
  CommandClasses2[CommandClasses2["Thermostat Setpoint"] = 67] = "Thermostat Setpoint";
  CommandClasses2[CommandClasses2["Time"] = 138] = "Time";
  CommandClasses2[CommandClasses2["Time Parameters"] = 139] = "Time Parameters";
  CommandClasses2[CommandClasses2["Transport Service"] = 85] = "Transport Service";
  CommandClasses2[CommandClasses2["User Code"] = 99] = "User Code";
  CommandClasses2[CommandClasses2["User Credential"] = 131] = "User Credential";
  CommandClasses2[CommandClasses2["Version"] = 134] = "Version";
  CommandClasses2[CommandClasses2["Wake Up"] = 132] = "Wake Up";
  CommandClasses2[CommandClasses2["Window Covering"] = 106] = "Window Covering";
  CommandClasses2[CommandClasses2["Z-Wave Plus Info"] = 94] = "Z-Wave Plus Info";
  CommandClasses2[CommandClasses2["Z/IP"] = 35] = "Z/IP";
  CommandClasses2[CommandClasses2["Z/IP 6LoWPAN"] = 79] = "Z/IP 6LoWPAN";
  CommandClasses2[CommandClasses2["Z/IP Gateway"] = 95] = "Z/IP Gateway";
  CommandClasses2[CommandClasses2["Z/IP Naming and Location"] = 104] = "Z/IP Naming and Location";
  CommandClasses2[CommandClasses2["Z/IP ND"] = 88] = "Z/IP ND";
  CommandClasses2[CommandClasses2["Z/IP Portal"] = 97] = "Z/IP Portal";
  CommandClasses2[CommandClasses2["Z-Wave Protocol"] = 1] = "Z-Wave Protocol";
  CommandClasses2[CommandClasses2["Z-Wave Long Range"] = 4] = "Z-Wave Long Range";
})(CommandClasses || (CommandClasses = {}));
function getCCName(cc) {
  return (0, import_shared.getEnumMemberName)(CommandClasses, cc);
}
__name(getCCName, "getCCName");
const allCCs = Object.freeze(Object.keys(CommandClasses).filter((key) => /^\d+$/.test(key)).map((key) => parseInt(key)).filter((key) => key >= 0 && key !== CommandClasses["Z-Wave Protocol"]));
const actuatorCCs = [
  CommandClasses["Barrier Operator"],
  CommandClasses["Binary Switch"],
  CommandClasses["Color Switch"],
  CommandClasses["Door Lock"],
  CommandClasses["Multilevel Switch"],
  CommandClasses["Simple AV Control"],
  CommandClasses["Sound Switch"],
  CommandClasses["Thermostat Setpoint"],
  CommandClasses["Thermostat Mode"],
  CommandClasses["Window Covering"]
];
const actuatorCCsAsSet = new Set(actuatorCCs);
function isActuatorCC(cc) {
  return actuatorCCsAsSet.has(cc);
}
__name(isActuatorCC, "isActuatorCC");
const sensorCCs = [
  CommandClasses["Alarm Sensor"],
  CommandClasses.Battery,
  CommandClasses["Binary Sensor"],
  CommandClasses["Energy Production"],
  CommandClasses.Meter,
  CommandClasses["Multilevel Sensor"],
  CommandClasses.Notification,
  // For pull nodes
  CommandClasses["Pulse Meter"]
];
const sensorCCsAsSet = new Set(sensorCCs);
function isSensorCC(cc) {
  return sensorCCsAsSet.has(cc);
}
__name(isSensorCC, "isSensorCC");
const applicationCCs = [
  CommandClasses["Alarm Sensor"],
  CommandClasses["Alarm Silence"],
  CommandClasses["All Switch"],
  CommandClasses["Anti-Theft"],
  CommandClasses["Barrier Operator"],
  CommandClasses.Basic,
  CommandClasses["Basic Tariff Information"],
  CommandClasses["Basic Window Covering"],
  CommandClasses["Binary Sensor"],
  CommandClasses["Binary Switch"],
  CommandClasses["Binary Toggle Switch"],
  CommandClasses["Climate Control Schedule"],
  CommandClasses["Central Scene"],
  CommandClasses.Clock,
  CommandClasses["Color Switch"],
  CommandClasses.Configuration,
  CommandClasses["Controller Replication"],
  CommandClasses["Demand Control Plan Configuration"],
  CommandClasses["Demand Control Plan Monitor"],
  CommandClasses["Door Lock"],
  CommandClasses["Door Lock Logging"],
  CommandClasses["Energy Production"],
  CommandClasses["Entry Control"],
  CommandClasses["Generic Schedule"],
  CommandClasses["Geographic Location"],
  CommandClasses["HRV Status"],
  CommandClasses["HRV Control"],
  CommandClasses["Humidity Control Mode"],
  CommandClasses["Humidity Control Operating State"],
  CommandClasses["Humidity Control Setpoint"],
  CommandClasses["IR Repeater"],
  CommandClasses.Irrigation,
  CommandClasses.Language,
  CommandClasses.Lock,
  CommandClasses["Manufacturer Proprietary"],
  CommandClasses.Meter,
  CommandClasses["Meter Table Configuration"],
  CommandClasses["Meter Table Monitor"],
  CommandClasses["Meter Table Push Configuration"],
  CommandClasses["Move To Position Window Covering"],
  CommandClasses["Multilevel Sensor"],
  CommandClasses["Multilevel Switch"],
  CommandClasses["Multilevel Toggle Switch"],
  CommandClasses.Notification,
  CommandClasses.Prepayment,
  CommandClasses["Prepayment Encapsulation"],
  CommandClasses.Proprietary,
  CommandClasses.Protection,
  CommandClasses["Pulse Meter"],
  CommandClasses["Rate Table Configuration"],
  CommandClasses["Rate Table Monitor"],
  CommandClasses["Scene Activation"],
  CommandClasses["Scene Actuator Configuration"],
  CommandClasses["Scene Controller Configuration"],
  CommandClasses.Schedule,
  CommandClasses["Schedule Entry Lock"],
  CommandClasses["Screen Attributes"],
  CommandClasses["Screen Meta Data"],
  CommandClasses["Sensor Configuration"],
  CommandClasses["Simple AV Control"],
  CommandClasses["Sound Switch"],
  CommandClasses["Tariff Table Configuration"],
  CommandClasses["Tariff Table Monitor"],
  CommandClasses["Thermostat Fan Mode"],
  CommandClasses["Thermostat Fan State"],
  CommandClasses["Thermostat Mode"],
  CommandClasses["Thermostat Operating State"],
  CommandClasses["Thermostat Setback"],
  CommandClasses["Thermostat Setpoint"],
  CommandClasses["User Code"],
  CommandClasses["User Credential"],
  CommandClasses["Window Covering"]
];
const applicationCCsAsSet = new Set(applicationCCs);
function isApplicationCC(cc) {
  return applicationCCsAsSet.has(cc);
}
__name(isApplicationCC, "isApplicationCC");
const encapsulationCCs = [
  CommandClasses["CRC-16 Encapsulation"],
  CommandClasses["Multi Channel"],
  CommandClasses["Multi Command"],
  CommandClasses.Security,
  CommandClasses["Security 2"],
  CommandClasses.Supervision,
  CommandClasses["Transport Service"]
];
const encapsulationCCsAsSet = new Set(encapsulationCCs);
function isEncapsulationCC(cc) {
  return encapsulationCCsAsSet.has(cc);
}
__name(isEncapsulationCC, "isEncapsulationCC");
const managementCCs = [
  CommandClasses["Application Capability"],
  CommandClasses["Application Status"],
  CommandClasses.Association,
  CommandClasses["Association Command Configuration"],
  CommandClasses["Association Group Information"],
  // Battery is in the Management CC specs, but we consider it a Sensor CC
  CommandClasses["Device Reset Locally"],
  CommandClasses["Firmware Update Meta Data"],
  CommandClasses["Grouping Name"],
  CommandClasses.Hail,
  CommandClasses.Indicator,
  CommandClasses["IP Association"],
  CommandClasses["Manufacturer Specific"],
  CommandClasses["Multi Channel Association"],
  CommandClasses["Node Naming and Location"],
  CommandClasses["Remote Association Activation"],
  CommandClasses["Remote Association Configuration"],
  CommandClasses.Time,
  CommandClasses["Time Parameters"],
  CommandClasses.Version,
  CommandClasses["Wake Up"],
  CommandClasses["Z/IP Naming and Location"],
  CommandClasses["Z-Wave Plus Info"]
];
const managementCCsAsSet = new Set(managementCCs);
function isManagementCC(cc) {
  return managementCCsAsSet.has(cc);
}
__name(isManagementCC, "isManagementCC");
const nonApplicationCCs = Object.freeze(allCCs.filter((cc) => !applicationCCs.includes(cc)));
function isCCInfoEqual(a, b) {
  return a.isSupported === b.isSupported && a.isControlled === b.isControlled && a.secure === b.secure && a.version === b.version;
}
__name(isCCInfoEqual, "isCCInfoEqual");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  CommandClasses,
  actuatorCCs,
  allCCs,
  applicationCCs,
  encapsulationCCs,
  getCCName,
  isActuatorCC,
  isApplicationCC,
  isCCInfoEqual,
  isEncapsulationCC,
  isManagementCC,
  isSensorCC,
  managementCCs,
  nonApplicationCCs,
  sensorCCs
});
//# sourceMappingURL=CommandClasses.js.map
