"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var SpyTransport_exports = {};
__export(SpyTransport_exports, {
  SpyTransport: () => SpyTransport,
  assertLogInfo: () => assertLogInfo,
  assertMessage: () => assertMessage
});
module.exports = __toCommonJS(SpyTransport_exports);
var import_ansi_colors = __toESM(require("ansi-colors"), 1);
var import_sinon = __toESM(require("sinon"), 1);
var import_triple_beam = require("triple-beam");
var import_winston_transport = __toESM(require("winston-transport"), 1);
const timestampRegex = /\d{2}:\d{2}:\d{2}\.\d{3}/g;
const timestampPrefixRegex = new RegExp(`^(${import_ansi_colors.default.ansiRegex.source})?${timestampRegex.source}(${import_ansi_colors.default.ansiRegex.source})? `, "gm");
const channelRegex = /(SERIAL|CNTRLR|DRIVER|RFLCTN)/g;
const channelPrefixRegex = new RegExp(`(${import_ansi_colors.default.ansiRegex.source})?${channelRegex.source}(${import_ansi_colors.default.ansiRegex.source})? `, "gm");
class SpyTransport extends import_winston_transport.default {
  static {
    __name(this, "SpyTransport");
  }
  constructor() {
    super({
      level: "silly"
    });
    this._spy = import_sinon.default.spy();
  }
  _spy;
  get spy() {
    return this._spy;
  }
  log(info, next) {
    this._spy(info);
    next();
  }
}
function assertMessage(expect, transport, options) {
  const callNumber = options.callNumber || 0;
  expect(transport.spy.callCount > callNumber).toBe(true);
  const callArg = transport.spy.getCall(callNumber).args[0];
  let actualMessage = callArg[import_triple_beam.MESSAGE];
  const ignoreColor = options.ignoreColor !== false;
  if (ignoreColor) {
    actualMessage = import_ansi_colors.default.stripColor(actualMessage);
  }
  if (options.ignoreTimestamp !== false) {
    actualMessage = actualMessage.replace(timestampPrefixRegex, "").replaceAll(/^ {13}/gm, "");
  }
  if (options.ignoreChannel !== false) {
    actualMessage = actualMessage.replace(channelPrefixRegex, "").replaceAll(/^ {7}/gm, "");
  }
  if (typeof options.message === "string") {
    if (ignoreColor) {
      options.message = import_ansi_colors.default.stripColor(options.message);
    }
    expect(actualMessage).toBe(options.message);
  }
  if (typeof options.predicate === "function") {
    expect(options.predicate(actualMessage)).toBe(true);
  }
}
__name(assertMessage, "assertMessage");
function assertLogInfo(expect, transport, options) {
  const callNumber = options.callNumber || 0;
  expect(transport.spy.callCount > callNumber).toBe(true);
  const callArg = transport.spy.getCall(callNumber).args[0];
  if (typeof options.level === "string") {
    expect(callArg.level).toBe(options.level);
  }
  if (typeof options.predicate === "function") {
    expect(options.predicate(callArg)).toBe(true);
  }
}
__name(assertLogInfo, "assertLogInfo");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  SpyTransport,
  assertLogInfo,
  assertMessage
});
//# sourceMappingURL=SpyTransport.js.map
