"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var assertZWaveError_exports = {};
__export(assertZWaveError_exports, {
  assertZWaveError: () => assertZWaveError
});
module.exports = __toCommonJS(assertZWaveError_exports);
function assertZWaveError(expect, valueOrFactory, options = {}) {
  const { messageMatches, errorCode, context } = options;
  function _assertZWaveError(e) {
    expect(e.constructor.name).toBe("ZWaveError");
    expect(e.code).toBeTypeOf("number");
  }
  __name(_assertZWaveError, "_assertZWaveError");
  function handleError(e) {
    _assertZWaveError(e);
    if (messageMatches != void 0) {
      const regex = messageMatches instanceof RegExp ? messageMatches : new RegExp(messageMatches);
      expect(e.message).toMatch(regex);
    }
    if (errorCode != void 0)
      expect(e.code).toBe(errorCode);
    if (context != void 0)
      expect(e.context).toBe(context);
  }
  __name(handleError, "handleError");
  function fail() {
    throw new Error("The factory function did not throw any error!");
  }
  __name(fail, "fail");
  if (typeof valueOrFactory === "function") {
    try {
      const result = valueOrFactory();
      if (result instanceof Promise) {
        return result.then(
          fail,
          // If valueOrFactory is an async function the promise should be rejected
          handleError
        );
      }
    } catch (e) {
      handleError(e);
      return void 0;
    }
    fail();
  } else {
    handleError(valueOrFactory);
  }
  return void 0;
}
__name(assertZWaveError, "assertZWaveError");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  assertZWaveError
});
//# sourceMappingURL=assertZWaveError.js.map
