"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var CacheBackedMap_exports = {};
__export(CacheBackedMap_exports, {
  CacheBackedMap: () => CacheBackedMap
});
module.exports = __toCommonJS(CacheBackedMap_exports);
class CacheBackedMap {
  static {
    __name(this, "CacheBackedMap");
  }
  cache;
  cacheKeys;
  constructor(cache, cacheKeys) {
    this.cache = cache;
    this.cacheKeys = cacheKeys;
    this.map = /* @__PURE__ */ new Map();
    for (const [key, value] of this.cache.entries()) {
      if (key.startsWith(this.cacheKeys.prefix)) {
        const suffix = key.slice(this.cacheKeys.prefix.length);
        const suffixKey = this.cacheKeys.suffixDeserializer(suffix);
        if (suffixKey !== void 0) {
          this.map.set(suffixKey, value);
        }
      }
    }
    this.forEach = this.map.forEach.bind(this.map);
    this.get = this.map.get.bind(this.map);
    this.has = this.map.has.bind(this.map);
    this.entries = this.map.entries.bind(this.map);
    this.keys = this.map.keys.bind(this.map);
    this.values = this.map.values.bind(this.map);
    this[Symbol.iterator] = this.map[Symbol.iterator].bind(this.map);
  }
  map;
  keyToCacheKey(key) {
    return this.cacheKeys.prefix + this.cacheKeys.suffixSerializer(key);
  }
  clear() {
    for (const key of this.map.keys()) {
      this.cache.delete(this.keyToCacheKey(key));
    }
    this.map.clear();
  }
  delete(key) {
    const ret = this.map.delete(key);
    if (ret)
      this.cache.delete(this.keyToCacheKey(key));
    return ret;
  }
  set(key, value) {
    this.map.set(key, value);
    this.cache.set(this.keyToCacheKey(key), value);
    return this;
  }
  get size() {
    return this.map.size;
  }
  get [Symbol.toStringTag]() {
    return "Map";
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  CacheBackedMap
});
//# sourceMappingURL=CacheBackedMap.js.map
