import type { ProtocolDataRate } from "./Protocol.js";
import type { RSSI } from "./RSSI.js";
import type { RoutingScheme } from "./RoutingScheme.js";
/** Information about the transmission as received by the controller */
export interface TXReport {
    /** Transmission time in ticks (multiples of 10ms) */
    txTicks: number;
    /** RSSI value of the acknowledgement frame */
    ackRSSI?: RSSI;
    /** RSSI values of the incoming acknowledgement frame, measured by repeater 0...3 */
    ackRepeaterRSSI?: [RSSI?, RSSI?, RSSI?, RSSI?];
    /** Channel number the acknowledgement frame is received on */
    ackChannelNo?: number;
    /** Channel number used to transmit the data */
    txChannelNo: number;
    /** State of the route resolution for the transmission attempt. Encoding is manufacturer specific. Z-Wave JS uses the Silicon Labs interpretation. */
    routeSchemeState: RoutingScheme;
    /** Node IDs of the repeater 0..3 used in the route. */
    repeaterNodeIds: [number?, number?, number?, number?];
    /** Whether the destination requires a 1000ms beam to be reached */
    beam1000ms: boolean;
    /** Whether the destination requires a 250ms beam to be reached */
    beam250ms: boolean;
    /** Transmission speed used in the route */
    routeSpeed: ProtocolDataRate;
    /** How many routing attempts have been made to transmit the payload */
    routingAttempts: number;
    /** When a route failed, this indicates the last functional Node ID in the last used route */
    failedRouteLastFunctionalNodeId?: number;
    /** When a route failed, this indicates the first non-functional Node ID in the last used route */
    failedRouteFirstNonFunctionalNodeId?: number;
    /** Transmit power used for the transmission in dBm */
    txPower?: number;
    /** Measured noise floor during the outgoing transmission */
    measuredNoiseFloor?: RSSI;
    /** TX power in dBm used by the destination to transmit the ACK */
    destinationAckTxPower?: number;
    /** Measured RSSI of the acknowledgement frame received from the destination */
    destinationAckMeasuredRSSI?: RSSI;
    /** Noise floor measured by the destination during the ACK transmission */
    destinationAckMeasuredNoiseFloor?: RSSI;
}
/** Information about the transmission, but for serialization in mocks */
export type SerializableTXReport = Partial<Omit<TXReport, "numRepeaters">> & Pick<TXReport, "txTicks" | "routeSpeed">;
//# sourceMappingURL=TXReport.d.ts.map