"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var convert_exports = {};
__export(convert_exports, {
  json500To700: () => json500To700,
  json700To500: () => json700To500,
  jsonToNVM: () => jsonToNVM,
  jsonToNVM500: () => jsonToNVM500,
  migrateNVM: () => migrateNVM,
  nodeHasInfo: () => nodeHasInfo,
  nvm500ToJSON: () => nvm500ToJSON,
  nvmObjectsToJSON: () => nvmObjectsToJSON,
  nvmToJSON: () => nvmToJSON
});
module.exports = __toCommonJS(convert_exports);
var import_core = require("@zwave-js/core");
var import_error = require("@zwave-js/core/error");
var import_shared = require("@zwave-js/shared");
var import_typeguards = require("alcalzone-shared/typeguards");
var import_gte = __toESM(require("semver/functions/gte.js"), 1);
var import_lt = __toESM(require("semver/functions/lt.js"), 1);
var import_lte = __toESM(require("semver/functions/lte.js"), 1);
var import_parse = __toESM(require("semver/functions/parse.js"), 1);
var import_consts = require("./consts.js");
var import_NVM3 = require("./lib/NVM3.js");
var import_NVM500 = require("./lib/NVM500.js");
var import_routeCache = require("./lib/common/routeCache.js");
var import_NVMMemoryIO = require("./lib/io/NVMMemoryIO.js");
var import_adapter = require("./lib/nvm3/adapter.js");
var import_consts2 = require("./lib/nvm3/consts.js");
var import_ApplicationNameFile = require("./lib/nvm3/files/ApplicationNameFile.js");
var import_files = require("./lib/nvm3/files/index.js");
var import_utils = require("./lib/nvm3/utils.js");
var import_adapter2 = require("./lib/nvm500/adapter.js");
var import_impls = require("./lib/nvm500/impls/index.js");
var import_shared2 = require("./lib/nvm500/shared.js");
function nodeHasInfo(node) {
  return !node.isVirtual || Object.keys(node).length > 1;
}
__name(nodeHasInfo, "nodeHasInfo");
function createEmptyPhysicalNode() {
  return {
    isVirtual: false,
    isListening: false,
    isFrequentListening: false,
    isRouting: false,
    supportedDataRates: [],
    protocolVersion: 0,
    optionalFunctionality: false,
    nodeType: import_core.NodeType["End Node"],
    supportsSecurity: false,
    supportsBeaming: false,
    genericDeviceClass: 0,
    specificDeviceClass: null,
    neighbors: [],
    sucUpdateIndex: 0,
    appRouteLock: false,
    routeSlaveSUC: false,
    sucPendingUpdate: false,
    pendingDiscovery: false,
    lwr: null,
    nlwr: null
  };
}
__name(createEmptyPhysicalNode, "createEmptyPhysicalNode");
function createEmptyLRNode() {
  return {
    isListening: false,
    isFrequentListening: false,
    isRouting: false,
    supportedDataRates: [],
    protocolVersion: 3,
    optionalFunctionality: false,
    nodeType: import_core.NodeType["End Node"],
    supportsSecurity: true,
    supportsBeaming: false,
    genericDeviceClass: 0,
    specificDeviceClass: null
  };
}
__name(createEmptyLRNode, "createEmptyLRNode");
function nvmObjectsToJSON(objects) {
  const nodes = /* @__PURE__ */ new Map();
  const getNode = /* @__PURE__ */ __name((id) => {
    if (!nodes.has(id))
      nodes.set(id, createEmptyPhysicalNode());
    return nodes.get(id);
  }, "getNode");
  const lrNodes = /* @__PURE__ */ new Map();
  const getLRNode = /* @__PURE__ */ __name((id) => {
    if (!lrNodes.has(id))
      lrNodes.set(id, createEmptyLRNode());
    return lrNodes.get(id);
  }, "getLRNode");
  const getObject = /* @__PURE__ */ __name((id) => {
    if (typeof id === "number") {
      return objects.get(id);
    } else {
      for (const [key, obj] of objects) {
        if (id(key))
          return obj;
      }
    }
  }, "getObject");
  const getObjectOrThrow = /* @__PURE__ */ __name((id) => {
    const ret2 = getObject(id);
    if (ret2)
      return ret2;
    throw new import_error.ZWaveError(`Object${typeof id === "number" ? ` ${(0, import_shared.num2hex)(id)} (${id})` : ""} not found!`, import_error.ZWaveErrorCodes.NVM_ObjectNotFound);
  }, "getObjectOrThrow");
  const getFileOrThrow = /* @__PURE__ */ __name((id, fileVersion) => {
    const obj = getObjectOrThrow(id);
    return import_files.NVMFile.from(obj.key, obj.data, fileVersion);
  }, "getFileOrThrow");
  const getFile = /* @__PURE__ */ __name((id, fileVersion) => {
    const obj = getObject(id);
    if (!obj || !obj.data)
      return void 0;
    return import_files.NVMFile.from(obj.key, obj.data, fileVersion);
  }, "getFile");
  const protocolVersionFile = getFileOrThrow(import_files.ProtocolVersionFileID, "7.0.0");
  const protocolFileFormat = protocolVersionFile.format;
  const protocolVersion = `${protocolVersionFile.major}.${protocolVersionFile.minor}.${protocolVersionFile.patch}`;
  if (protocolFileFormat > import_consts.MAX_PROTOCOL_FILE_FORMAT) {
    throw new import_error.ZWaveError(`Unsupported protocol file format: ${protocolFileFormat}`, import_error.ZWaveErrorCodes.NVM_NotSupported, { protocolFileFormat });
  }
  const nodeIds = getFileOrThrow(import_files.ProtocolNodeListFileID, protocolVersion).nodeIds;
  const appRouteLock = new Set(getFileOrThrow(import_files.ProtocolAppRouteLockNodeMaskFileID, protocolVersion).nodeIds);
  const routeSlaveSUC = new Set(getFileOrThrow(import_files.ProtocolRouteSlaveSUCNodeMaskFileID, protocolVersion).nodeIds);
  const sucPendingUpdate = new Set(getFileOrThrow(import_files.ProtocolSUCPendingUpdateNodeMaskFileID, protocolVersion).nodeIds);
  const isVirtual = new Set(getFileOrThrow(import_files.ProtocolVirtualNodeMaskFileID, protocolVersion).nodeIds);
  const pendingDiscovery = new Set(getFileOrThrow(import_files.ProtocolPendingDiscoveryNodeMaskFileID, protocolVersion).nodeIds);
  const routeCacheExists = new Set(getFileOrThrow(import_files.ProtocolRouteCacheExistsNodeMaskFileID, protocolVersion).nodeIds);
  for (const id of nodeIds) {
    const node = getNode(id);
    const rememberOnlyVirtual = /* @__PURE__ */ __name(() => {
      nodes.set(id, {
        isVirtual: true
      });
    }, "rememberOnlyVirtual");
    let nodeInfo;
    try {
      if (protocolFileFormat === 0) {
        const fileId = (0, import_files.nodeIdToNodeInfoFileIDV0)(id);
        const file = getFileOrThrow(fileId, protocolVersion);
        nodeInfo = file.nodeInfo;
      } else {
        const fileId = (0, import_files.nodeIdToNodeInfoFileIDV1)(id);
        const file = getFileOrThrow(fileId, protocolVersion);
        nodeInfo = file.nodeInfos.find((i) => i.nodeId === id);
      }
    } catch (e) {
      if (e.message.includes("Object not found")) {
        rememberOnlyVirtual();
        continue;
      }
      throw e;
    }
    Object.assign(node, nodeInfo);
    node.isVirtual = isVirtual.has(id);
    node.appRouteLock = appRouteLock.has(id);
    node.routeSlaveSUC = routeSlaveSUC.has(id);
    node.sucPendingUpdate = sucPendingUpdate.has(id);
    node.pendingDiscovery = pendingDiscovery.has(id);
    if (routeCacheExists.has(id)) {
      let routeCache;
      if (protocolFileFormat === 0) {
        const fileId = (0, import_files.nodeIdToRouteCacheFileIDV0)(id);
        const file = getFile(fileId, protocolVersion);
        routeCache = file?.routeCache;
      } else {
        const fileId = (0, import_files.nodeIdToRouteCacheFileIDV1)(id);
        const file = getFile(fileId, protocolVersion);
        routeCache = file?.routeCaches.find((i) => i.nodeId === id);
      }
      if (routeCache) {
        node.lwr = routeCache.lwr;
        node.nlwr = routeCache.nlwr;
      }
    }
    delete node.nodeId;
  }
  const lrNodeIds = getFile(import_files.ProtocolLRNodeListFileID, protocolVersion)?.nodeIds;
  if (lrNodeIds) {
    for (const id of lrNodeIds) {
      const node = getLRNode(id);
      const fileId = (0, import_files.nodeIdToLRNodeInfoFileIDV5)(id);
      const file = getFileOrThrow(fileId, protocolVersion);
      const { nodeId, ...nodeInfo } = file.nodeInfos.find((i) => i.nodeId === id);
      Object.assign(node, nodeInfo);
    }
  }
  const controllerInfoFile = getFileOrThrow(import_files.ControllerInfoFileID, protocolVersion);
  let sucUpdateEntries;
  if (protocolFileFormat < 5) {
    sucUpdateEntries = getFileOrThrow(import_files.SUCUpdateEntriesFileIDV0, protocolVersion).updateEntries;
  } else {
    sucUpdateEntries = [];
    for (let index = 0; index < import_consts.SUC_MAX_UPDATES; index += import_files.SUC_UPDATES_PER_FILE_V5) {
      const file = getFile((0, import_files.sucUpdateIndexToSUCUpdateEntriesFileIDV5)(index), protocolVersion);
      if (!file)
        break;
      sucUpdateEntries.push(...file.updateEntries);
    }
  }
  const applicationVersionFile700 = getFile(import_files.ApplicationVersionFileID, "7.0.0");
  const applicationVersionFile800 = getFile(import_files.ApplicationVersionFile800ID, "7.0.0");
  const applicationVersionFile = applicationVersionFile700 ?? applicationVersionFile800;
  if (!applicationVersionFile) {
    throw new import_error.ZWaveError("ApplicationVersionFile not found!", import_error.ZWaveErrorCodes.NVM_ObjectNotFound);
  }
  const applicationVersion = `${applicationVersionFile.major}.${applicationVersionFile.minor}.${applicationVersionFile.patch}`;
  const rfConfigFile = getFile(import_files.ApplicationRFConfigFileID, applicationVersion);
  const applicationCCsFile = getFileOrThrow(import_files.ApplicationCCsFileID, applicationVersion);
  const applicationDataFile = getFile(import_files.ApplicationDataFileID, applicationVersion);
  const applicationTypeFile = getFileOrThrow(import_files.ApplicationTypeFileID, applicationVersion);
  const applicationNameFile = getFile(import_ApplicationNameFile.ApplicationNameFileID, applicationVersion);
  const preferredRepeaters = getFile(import_files.ProtocolPreferredRepeatersFileID, applicationVersion)?.nodeIds;
  const controllerProps = [
    "nodeId",
    "lastNodeId",
    "staticControllerNodeId",
    "sucLastIndex",
    "controllerConfiguration",
    "sucAwarenessPushNeeded",
    "maxNodeId",
    "reservedId",
    "systemState",
    "lastNodeIdLR",
    "maxNodeIdLR",
    "reservedIdLR",
    "primaryLongRangeChannelId",
    "dcdcConfig"
  ];
  const controller = {
    protocolVersion,
    applicationVersion,
    homeId: (0, import_shared.buffer2hex)(controllerInfoFile.homeId),
    ...(0, import_shared.pick)(controllerInfoFile, controllerProps),
    ...(0, import_shared.pick)(applicationTypeFile, [
      "isListening",
      "optionalFunctionality",
      "genericDeviceClass",
      "specificDeviceClass"
    ]),
    commandClasses: (0, import_shared.pick)(applicationCCsFile, [
      "includedInsecurely",
      "includedSecurelyInsecureCCs",
      "includedSecurelySecureCCs"
    ]),
    preferredRepeaters,
    ...rfConfigFile ? {
      rfConfig: {
        rfRegion: rfConfigFile.rfRegion,
        txPower: rfConfigFile.txPower,
        measured0dBm: rfConfigFile.measured0dBm,
        enablePTI: rfConfigFile.enablePTI ?? null,
        maxTXPower: rfConfigFile.maxTXPower ?? null,
        nodeIdType: rfConfigFile.nodeIdType ?? null
      }
    } : {},
    sucUpdateEntries,
    applicationData: applicationDataFile?.applicationData.toString("hex") ?? null,
    applicationName: applicationNameFile?.name ?? null
  };
  const optionalControllerProps = [
    "sucAwarenessPushNeeded",
    "lastNodeIdLR",
    "maxNodeIdLR",
    "reservedIdLR",
    "primaryLongRangeChannelId",
    "dcdcConfig",
    "rfConfig",
    "preferredRepeaters",
    "applicationData"
  ];
  for (const prop of optionalControllerProps) {
    if (controller[prop] === void 0)
      controller[prop] = null;
  }
  const ret = {
    format: protocolFileFormat,
    controller,
    nodes: (0, import_utils.mapToObject)(nodes)
  };
  if (lrNodes.size > 0) {
    ret.lrNodes = (0, import_utils.mapToObject)(lrNodes);
  }
  return ret;
}
__name(nvmObjectsToJSON, "nvmObjectsToJSON");
function nvmJSONNodeToNodeInfo(nodeId, node) {
  return {
    nodeId,
    ...(0, import_shared.pick)(node, [
      "isListening",
      "isFrequentListening",
      "isRouting",
      "supportedDataRates",
      "protocolVersion",
      "optionalFunctionality",
      "nodeType",
      "supportsSecurity",
      "supportsBeaming",
      "genericDeviceClass",
      "specificDeviceClass",
      "neighbors",
      "sucUpdateIndex"
    ])
  };
}
__name(nvmJSONNodeToNodeInfo, "nvmJSONNodeToNodeInfo");
function nvmJSONLRNodeToLRNodeInfo(nodeId, node) {
  return {
    nodeId,
    ...(0, import_shared.pick)(node, [
      "isListening",
      "isFrequentListening",
      "isRouting",
      "supportedDataRates",
      "protocolVersion",
      "optionalFunctionality",
      "nodeType",
      "supportsSecurity",
      "supportsBeaming",
      "genericDeviceClass",
      "specificDeviceClass"
    ])
  };
}
__name(nvmJSONLRNodeToLRNodeInfo, "nvmJSONLRNodeToLRNodeInfo");
function nvmJSONControllerToFileOptions(ctrlr) {
  const ret = {
    homeId: import_shared.Bytes.from(ctrlr.homeId.replace(/^0x/, ""), "hex"),
    nodeId: ctrlr.nodeId,
    lastNodeId: ctrlr.lastNodeId,
    staticControllerNodeId: ctrlr.staticControllerNodeId,
    sucLastIndex: ctrlr.sucLastIndex,
    controllerConfiguration: ctrlr.controllerConfiguration,
    maxNodeId: ctrlr.maxNodeId,
    reservedId: ctrlr.reservedId,
    systemState: ctrlr.systemState
  };
  if (ctrlr.sucAwarenessPushNeeded != void 0) {
    ret.sucAwarenessPushNeeded = ctrlr.sucAwarenessPushNeeded;
  } else {
    Object.assign(ret, (0, import_core.stripUndefined)((0, import_shared.pick)(ctrlr, [
      "sucAwarenessPushNeeded",
      "lastNodeIdLR",
      "maxNodeIdLR",
      "reservedIdLR",
      "primaryLongRangeChannelId",
      "dcdcConfig"
    ])));
  }
  return ret;
}
__name(nvmJSONControllerToFileOptions, "nvmJSONControllerToFileOptions");
async function nvmToJSON(buffer, debugLogs = false) {
  const io = new import_NVMMemoryIO.NVMMemoryIO(buffer);
  const nvm3 = new import_NVM3.NVM3(io);
  const info = await nvm3.init();
  const adapter = new import_adapter.NVM3Adapter(nvm3);
  if (debugLogs) {
    await (0, import_utils.dumpNVM)(nvm3);
  }
  const firstPageHeader = info.isSharedFileSystem ? info.sections.all.pages[0] : info.sections.protocol.pages[0];
  const meta = {
    sharedFileSystem: info.isSharedFileSystem,
    ...(0, import_shared.pick)(firstPageHeader, [
      "pageSize",
      "writeSize",
      "memoryMapped",
      "deviceFamily"
    ])
  };
  const nodes = /* @__PURE__ */ new Map();
  const getNode = /* @__PURE__ */ __name((id) => {
    if (!nodes.has(id))
      nodes.set(id, createEmptyPhysicalNode());
    return nodes.get(id);
  }, "getNode");
  const lrNodes = /* @__PURE__ */ new Map();
  const getLRNode = /* @__PURE__ */ __name((id) => {
    if (!lrNodes.has(id))
      lrNodes.set(id, createEmptyLRNode());
    return lrNodes.get(id);
  }, "getLRNode");
  let protocolFileFormat;
  let protocolVersion;
  try {
    protocolFileFormat = await adapter.get({
      domain: "controller",
      type: "protocolFileFormat"
    }, true);
    protocolVersion = await adapter.get({
      domain: "controller",
      type: "protocolVersion"
    }, true);
  } catch (e) {
    let isSDK723 = true;
    isSDK723 &&= (await nvm3.get(import_files.ApplicationRFConfigFileID))?.length == 9;
    isSDK723 &&= !!await nvm3.get(import_files.ApplicationVersionFile800ID);
    isSDK723 &&= !!await nvm3.get(import_files.ProtocolLRNodeListFileID);
    isSDK723 &&= (await nvm3.get(import_files.ControllerInfoFileID))?.length == 22;
    if (isSDK723) {
      protocolVersion = "7.23.0";
      protocolFileFormat = 5;
      adapter.setFile(new import_files.ProtocolVersionFile({
        fileVersion: protocolVersion,
        format: protocolFileFormat,
        major: 7,
        minor: 23,
        patch: 0
      }));
      await adapter["init"]();
    } else {
      throw e;
    }
  }
  if (protocolFileFormat > import_consts.MAX_PROTOCOL_FILE_FORMAT) {
    throw new import_error.ZWaveError(`Unsupported protocol file format: ${protocolFileFormat}`, import_error.ZWaveErrorCodes.NVM_NotSupported, { protocolFileFormat });
  }
  const appRouteLock = new Set(await adapter.get({
    domain: "controller",
    type: "appRouteLock"
  }, true));
  const routeSlaveSUC = new Set(await adapter.get({
    domain: "controller",
    type: "routeSlaveSUC"
  }, true));
  const sucPendingUpdate = new Set(await adapter.get({
    domain: "controller",
    type: "sucPendingUpdate"
  }, true));
  const virtualNodeIds = new Set(await adapter.get({
    domain: "controller",
    type: "virtualNodeIds"
  }, true));
  const pendingDiscovery = new Set(await adapter.get({
    domain: "controller",
    type: "pendingDiscovery"
  }, true));
  const nodeIds = await adapter.get({
    domain: "controller",
    type: "nodeIds"
  }, true);
  for (const id of nodeIds) {
    const node = getNode(id);
    const nodeInfo = await adapter.get({
      domain: "node",
      nodeId: id,
      type: "info"
    }, true);
    Object.assign(node, nodeInfo);
    node.isVirtual = virtualNodeIds.has(id);
    node.appRouteLock = appRouteLock.has(id);
    node.routeSlaveSUC = routeSlaveSUC.has(id);
    node.sucPendingUpdate = sucPendingUpdate.has(id);
    node.pendingDiscovery = pendingDiscovery.has(id);
    const routes = await adapter.get({
      domain: "node",
      nodeId: id,
      type: "routes"
    });
    if (routes) {
      node.lwr = routes.lwr;
      node.nlwr = routes.nlwr;
    }
    delete node.nodeId;
  }
  const lrNodeIds = await adapter.get({
    domain: "controller",
    type: "lrNodeIds"
  });
  if (lrNodeIds) {
    for (const id of lrNodeIds) {
      const node = getLRNode(id);
      const nodeInfo = await adapter.get({
        domain: "lrnode",
        nodeId: id,
        type: "info"
      }, true);
      Object.assign(node, nodeInfo);
    }
  }
  const sucUpdateEntries = await adapter.get({
    domain: "controller",
    type: "sucUpdateEntries"
  }, true);
  const applicationVersion = await adapter.get({
    domain: "controller",
    type: "applicationVersion"
  }, true);
  const applicationFileFormat = await adapter.get({
    domain: "controller",
    type: "applicationFileFormat"
  }, true);
  const applicationData = await adapter.get({
    domain: "controller",
    type: "applicationData"
  });
  const applicationName = await adapter.get({
    domain: "controller",
    type: "applicationName"
  });
  const preferredRepeaters = await adapter.get({
    domain: "controller",
    type: "preferredRepeaters"
  });
  const controllerInfoFile = await adapter.getFile(import_files.ControllerInfoFileID, true);
  const rfConfigFile = await adapter.getFile(import_files.ApplicationRFConfigFileID);
  const applicationCCsFile = await adapter.getFile(import_files.ApplicationCCsFileID, true);
  const applicationTypeFile = await adapter.getFile(import_files.ApplicationTypeFileID, true);
  const controller = {
    protocolVersion,
    applicationVersion,
    homeId: (0, import_shared.buffer2hex)(controllerInfoFile.homeId),
    ...(0, import_shared.pick)(controllerInfoFile, [
      "nodeId",
      "lastNodeId",
      "staticControllerNodeId",
      "sucLastIndex",
      "controllerConfiguration",
      "sucAwarenessPushNeeded",
      "maxNodeId",
      "reservedId",
      "systemState",
      "lastNodeIdLR",
      "maxNodeIdLR",
      "reservedIdLR",
      "primaryLongRangeChannelId",
      "dcdcConfig"
    ]),
    ...(0, import_shared.pick)(applicationTypeFile, [
      "isListening",
      "optionalFunctionality",
      "genericDeviceClass",
      "specificDeviceClass"
    ]),
    commandClasses: (0, import_shared.pick)(applicationCCsFile, [
      "includedInsecurely",
      "includedSecurelyInsecureCCs",
      "includedSecurelySecureCCs"
    ]),
    preferredRepeaters,
    ...rfConfigFile ? {
      rfConfig: {
        rfRegion: rfConfigFile.rfRegion,
        txPower: rfConfigFile.txPower,
        measured0dBm: rfConfigFile.measured0dBm,
        enablePTI: rfConfigFile.enablePTI ?? null,
        maxTXPower: rfConfigFile.maxTXPower ?? null,
        nodeIdType: rfConfigFile.nodeIdType ?? null
      }
    } : {},
    sucUpdateEntries,
    applicationData: (applicationData && import_shared.Bytes.view(applicationData).toString("hex")) ?? null,
    applicationName: applicationName ?? null
  };
  const optionalControllerProps = [
    "sucAwarenessPushNeeded",
    "lastNodeIdLR",
    "maxNodeIdLR",
    "reservedIdLR",
    "primaryLongRangeChannelId",
    "dcdcConfig",
    "rfConfig",
    "preferredRepeaters",
    "applicationData"
  ];
  for (const prop of optionalControllerProps) {
    if (controller[prop] === void 0)
      controller[prop] = null;
  }
  const ret = {
    format: protocolFileFormat,
    controller,
    nodes: (0, import_utils.mapToObject)(nodes),
    meta
  };
  if (applicationFileFormat !== 0) {
    ret.applicationFileFormat = applicationFileFormat;
  }
  if (lrNodes.size > 0) {
    ret.lrNodes = (0, import_utils.mapToObject)(lrNodes);
  }
  return ret;
}
__name(nvmToJSON, "nvmToJSON");
async function nvm500ToJSON(buffer) {
  const io = new import_NVMMemoryIO.NVMMemoryIO(buffer);
  const nvm = new import_NVM500.NVM500(io);
  const info = await nvm.init();
  const meta = {
    library: info.library,
    ...(0, import_shared.pick)(info.nvmDescriptor, [
      "manufacturerID",
      "firmwareID",
      "productType",
      "productID"
    ])
  };
  const adapter = new import_adapter2.NVM500Adapter(nvm);
  const appRouteLock = new Set(await adapter.get({
    domain: "controller",
    type: "appRouteLock"
  }, true));
  const routeSlaveSUC = new Set(await adapter.get({
    domain: "controller",
    type: "routeSlaveSUC"
  }, true));
  const sucPendingUpdate = new Set(await adapter.get({
    domain: "controller",
    type: "sucPendingUpdate"
  }, true));
  const virtualNodeIds = new Set(await adapter.get({
    domain: "controller",
    type: "virtualNodeIds"
  }) ?? []);
  const pendingDiscovery = new Set(await adapter.get({
    domain: "controller",
    type: "pendingDiscovery"
  }, true));
  const nodes = {};
  for (let nodeId = 1; nodeId <= import_core.MAX_NODES; nodeId++) {
    const nodeInfo = await adapter.get({
      domain: "node",
      nodeId,
      type: "info"
    });
    const isVirtual = virtualNodeIds.has(nodeId);
    if (!nodeInfo) {
      if (isVirtual) {
        nodes[nodeId] = { isVirtual: true };
      }
      continue;
    }
    const routes = await adapter.get({
      domain: "node",
      nodeId,
      type: "routes"
    });
    delete nodeInfo.nodeId;
    nodes[nodeId] = {
      ...nodeInfo,
      specificDeviceClass: nodeInfo.specificDeviceClass ?? null,
      isVirtual,
      appRouteLock: appRouteLock.has(nodeId),
      routeSlaveSUC: routeSlaveSUC.has(nodeId),
      sucPendingUpdate: sucPendingUpdate.has(nodeId),
      pendingDiscovery: pendingDiscovery.has(nodeId),
      lwr: routes?.lwr ?? null,
      nlwr: routes?.nlwr ?? null
    };
  }
  const ownNodeId = await adapter.get({
    domain: "controller",
    type: "nodeId"
  }, true);
  const ownHomeId = await adapter.get({
    domain: "controller",
    type: "homeId"
  }, true);
  let learnedHomeId = await adapter.get({
    domain: "controller",
    type: "learnedHomeId"
  });
  if (learnedHomeId?.length === 4 && learnedHomeId.every((b) => b === 0)) {
    learnedHomeId = void 0;
  }
  const lastNodeId = await adapter.get({
    domain: "controller",
    type: "lastNodeId"
  }, true);
  const maxNodeId = await adapter.get({
    domain: "controller",
    type: "maxNodeId"
  }, true);
  const reservedId = await adapter.get({
    domain: "controller",
    type: "reservedId"
  }, true);
  const staticControllerNodeId = await adapter.get({
    domain: "controller",
    type: "staticControllerNodeId"
  }, true);
  const sucLastIndex = await adapter.get({
    domain: "controller",
    type: "sucLastIndex"
  }, true);
  const controllerConfiguration = await adapter.get({
    domain: "controller",
    type: "controllerConfiguration"
  }, true);
  const commandClasses = await adapter.get({
    domain: "controller",
    type: "commandClasses"
  }, true);
  const sucUpdateEntries = await adapter.get({
    domain: "controller",
    type: "sucUpdateEntries"
  }, true);
  const applicationData = await adapter.get({
    domain: "controller",
    type: "applicationData"
  });
  const preferredRepeaters = await adapter.get({
    domain: "controller",
    type: "preferredRepeaters"
  }, true);
  const systemState = await adapter.get({
    domain: "controller",
    type: "systemState"
  });
  const watchdogStarted = await adapter.get({
    domain: "controller",
    type: "watchdogStarted"
  }, true);
  const powerLevelNormal = await adapter.get({
    domain: "controller",
    type: "powerLevelNormal"
  });
  const powerLevelLow = await adapter.get({
    domain: "controller",
    type: "powerLevelLow"
  });
  const powerMode = await adapter.get({
    domain: "controller",
    type: "powerMode"
  });
  const powerModeExtintEnable = await adapter.get({
    domain: "controller",
    type: "powerModeExtintEnable"
  });
  const powerModeWutTimeout = await adapter.get({
    domain: "controller",
    type: "powerModeWutTimeout"
  });
  const controller = {
    protocolVersion: info.nvmDescriptor.protocolVersion,
    applicationVersion: info.nvmDescriptor.firmwareVersion,
    ownHomeId: (0, import_shared.buffer2hex)(ownHomeId),
    learnedHomeId: learnedHomeId ? (0, import_shared.buffer2hex)(learnedHomeId) : null,
    nodeId: ownNodeId,
    lastNodeId,
    staticControllerNodeId,
    sucLastIndex,
    controllerConfiguration,
    sucUpdateEntries,
    maxNodeId,
    reservedId,
    systemState,
    watchdogStarted,
    rfConfig: {
      powerLevelNormal,
      powerLevelLow,
      powerMode,
      powerModeExtintEnable,
      powerModeWutTimeout
    },
    preferredRepeaters,
    commandClasses,
    applicationData: (applicationData && import_shared.Bytes.view(applicationData).toString("hex")) ?? null
  };
  return {
    format: 500,
    meta,
    controller,
    nodes
  };
}
__name(nvm500ToJSON, "nvm500ToJSON");
async function jsonToNVM(json, targetSDKVersion) {
  const parsedVersion = (0, import_parse.default)(targetSDKVersion);
  if (!parsedVersion) {
    throw new import_error.ZWaveError(`Invalid SDK version: ${targetSDKVersion}`, import_error.ZWaveErrorCodes.Argument_Invalid);
  }
  const sharedFileSystem = json.meta?.sharedFileSystem;
  const nvmSize = sharedFileSystem ? import_consts2.ZWAVE_SHARED_NVM_SIZE : import_consts2.ZWAVE_APPLICATION_NVM_SIZE + import_consts2.ZWAVE_PROTOCOL_NVM_SIZE;
  const ret = new Uint8Array(nvmSize);
  const io = new import_NVMMemoryIO.NVMMemoryIO(ret);
  const nvm3 = new import_NVM3.NVM3(io);
  await nvm3.erase(json.meta);
  const serializeFile = /* @__PURE__ */ __name(async (file) => {
    const { key, data } = file.serialize();
    await nvm3.set(key, data);
  }, "serializeFile");
  let targetApplicationVersion;
  let targetProtocolVersion;
  let targetProtocolFormat;
  const HIGHEST_SUPPORTED_SDK_VERSION = "7.21.0";
  if ((0, import_lte.default)(targetSDKVersion, HIGHEST_SUPPORTED_SDK_VERSION)) {
    targetApplicationVersion = (0, import_parse.default)(targetSDKVersion);
  } else {
    targetApplicationVersion = (0, import_parse.default)(HIGHEST_SUPPORTED_SDK_VERSION);
  }
  if ((0, import_gte.default)(targetSDKVersion, "7.19.0")) {
    targetProtocolVersion = (0, import_parse.default)("7.19.0");
    targetProtocolFormat = 5;
  } else if ((0, import_gte.default)(targetSDKVersion, "7.17.0")) {
    targetProtocolVersion = (0, import_parse.default)("7.17.0");
    targetProtocolFormat = 4;
  } else if ((0, import_gte.default)(targetSDKVersion, "7.15.3")) {
    targetProtocolVersion = (0, import_parse.default)("7.15.3");
    targetProtocolFormat = 3;
  } else if ((0, import_gte.default)(targetSDKVersion, "7.12.0")) {
    targetProtocolVersion = (0, import_parse.default)("7.12.0");
    targetProtocolFormat = 2;
  } else if ((0, import_gte.default)(targetSDKVersion, "7.11.0")) {
    targetProtocolVersion = (0, import_parse.default)("7.11.0");
    targetProtocolFormat = 1;
  } else {
    targetProtocolVersion = (0, import_parse.default)("7.0.0");
    targetProtocolFormat = 0;
  }
  const target = (0, import_shared.cloneDeep)(json);
  target.controller.protocolVersion = targetProtocolVersion.format();
  target.format = targetProtocolFormat;
  target.controller.applicationVersion = parsedVersion.format();
  const ApplicationVersionConstructor = sharedFileSystem ? import_files.ApplicationVersionFile800 : import_files.ApplicationVersionFile;
  const applVersionFile = new ApplicationVersionConstructor({
    format: 0,
    major: targetApplicationVersion.major,
    minor: targetApplicationVersion.minor,
    patch: targetApplicationVersion.patch,
    fileVersion: targetProtocolVersion.format()
    // does not matter for this file
  });
  await serializeFile(applVersionFile);
  const protocolVersionFile = new import_files.ProtocolVersionFile({
    format: targetProtocolFormat,
    major: targetProtocolVersion.major,
    minor: targetProtocolVersion.minor,
    patch: targetProtocolVersion.patch,
    fileVersion: targetProtocolVersion.format()
    // does not matter for this file
  });
  await serializeFile(protocolVersionFile);
  {
    const { key, data } = protocolVersionFile.serialize();
    await nvm3.set(key, data);
  }
  const adapter = new import_adapter.NVM3Adapter(nvm3);
  const applTypeFile = new import_files.ApplicationTypeFile({
    ...(0, import_shared.pick)(target.controller, [
      "isListening",
      "optionalFunctionality",
      "genericDeviceClass",
      "specificDeviceClass"
    ]),
    fileVersion: target.controller.applicationVersion
  });
  adapter.setFile(applTypeFile);
  const applCCsFile = new import_files.ApplicationCCsFile({
    ...(0, import_shared.pick)(target.controller.commandClasses, [
      "includedInsecurely",
      "includedSecurelyInsecureCCs",
      "includedSecurelySecureCCs"
    ]),
    fileVersion: target.controller.applicationVersion
  });
  adapter.setFile(applCCsFile);
  target.controller.rfConfig ??= {
    rfRegion: import_core.RFRegion["Default (EU)"],
    txPower: 0,
    measured0dBm: 3.3,
    enablePTI: null,
    maxTXPower: null,
    nodeIdType: null
  };
  if ((0, import_gte.default)(targetSDKVersion, "7.15.3")) {
    target.controller.rfConfig.enablePTI ??= 0;
    target.controller.rfConfig.maxTXPower ??= 14;
  }
  if ((0, import_gte.default)(targetSDKVersion, "7.21.0")) {
    target.controller.rfConfig.nodeIdType ??= import_core.NodeIDType.Short;
  }
  const applRFConfigFile = new import_files.ApplicationRFConfigFile({
    ...(0, import_shared.pick)(target.controller.rfConfig, [
      "rfRegion",
      "txPower",
      "measured0dBm"
    ]),
    enablePTI: target.controller.rfConfig.enablePTI ?? void 0,
    maxTXPower: target.controller.rfConfig.maxTXPower ?? void 0,
    nodeIdType: target.controller.rfConfig.nodeIdType ?? void 0,
    fileVersion: target.controller.applicationVersion
  });
  adapter.setFile(applRFConfigFile);
  if (target.controller.applicationData) {
    await adapter.set({ domain: "controller", type: "applicationData" }, import_shared.Bytes.from(target.controller.applicationData, "hex"));
  }
  if (target.controller.applicationName && target.meta?.sharedFileSystem) {
    await adapter.set({ domain: "controller", type: "applicationName" }, target.controller.applicationName);
  }
  const nodeInfoExists = /* @__PURE__ */ new Set();
  const lrNodeInfoExists = /* @__PURE__ */ new Set();
  const virtualNodeIds = /* @__PURE__ */ new Set();
  const appRouteLock = /* @__PURE__ */ new Set();
  const routeSlaveSUC = /* @__PURE__ */ new Set();
  const sucPendingUpdate = /* @__PURE__ */ new Set();
  const pendingDiscovery = /* @__PURE__ */ new Set();
  adapter.setFile(new import_files.ProtocolRouteCacheExistsNodeMaskFile({
    nodeIds: [],
    fileVersion: target.controller.protocolVersion
  }));
  for (const [id, node] of Object.entries(target.nodes)) {
    const nodeId = parseInt(id);
    if (!nodeHasInfo(node)) {
      virtualNodeIds.add(nodeId);
      continue;
    } else {
      nodeInfoExists.add(nodeId);
      if (node.isVirtual)
        virtualNodeIds.add(nodeId);
      if (node.appRouteLock)
        appRouteLock.add(nodeId);
      if (node.routeSlaveSUC)
        routeSlaveSUC.add(nodeId);
      if (node.sucPendingUpdate)
        sucPendingUpdate.add(nodeId);
      if (node.pendingDiscovery)
        pendingDiscovery.add(nodeId);
    }
    await adapter.set({ domain: "node", nodeId, type: "info" }, nvmJSONNodeToNodeInfo(nodeId, node));
    if (node.lwr || node.nlwr) {
      await adapter.set({ domain: "node", nodeId, type: "routes" }, {
        lwr: node.lwr ?? (0, import_routeCache.getEmptyRoute)(),
        nlwr: node.nlwr ?? (0, import_routeCache.getEmptyRoute)()
      });
    }
  }
  await adapter.set({ domain: "controller", type: "nodeIds" }, [...nodeInfoExists]);
  if (target.lrNodes) {
    for (const [id, node] of Object.entries(target.lrNodes)) {
      const nodeId = parseInt(id);
      lrNodeInfoExists.add(nodeId);
      await adapter.set({ domain: "lrnode", nodeId, type: "info" }, nvmJSONLRNodeToLRNodeInfo(nodeId, node));
    }
  }
  await adapter.set({ domain: "controller", type: "lrNodeIds" }, [...lrNodeInfoExists]);
  if (targetProtocolFormat >= 3) {
    target.controller.lastNodeIdLR ??= 255;
    target.controller.maxNodeIdLR ??= 0;
    target.controller.reservedIdLR ??= 0;
    target.controller.primaryLongRangeChannelId ??= 0;
    target.controller.dcdcConfig ??= 255;
  }
  adapter.setFile(new import_files.ControllerInfoFile(nvmJSONControllerToFileOptions(target.controller)));
  await adapter.set({ domain: "controller", type: "appRouteLock" }, [...appRouteLock]);
  await adapter.set({ domain: "controller", type: "routeSlaveSUC" }, [...routeSlaveSUC]);
  await adapter.set({ domain: "controller", type: "sucPendingUpdate" }, [...sucPendingUpdate]);
  await adapter.set({ domain: "controller", type: "virtualNodeIds" }, [...virtualNodeIds]);
  await adapter.set({ domain: "controller", type: "pendingDiscovery" }, [...pendingDiscovery]);
  if (target.controller.preferredRepeaters?.length) {
    await adapter.set({ domain: "controller", type: "preferredRepeaters" }, target.controller.preferredRepeaters);
  }
  await adapter.set({ domain: "controller", type: "sucUpdateEntries" }, target.controller.sucUpdateEntries);
  await adapter.commit();
  await io.close();
  return ret;
}
__name(jsonToNVM, "jsonToNVM");
async function jsonToNVM500(json, protocolVersion) {
  const impl = import_impls.nvm500Impls.find((p) => p.protocolVersions.includes(protocolVersion) && p.name.toLowerCase().startsWith(json.meta.library));
  if (!impl) {
    throw new import_error.ZWaveError(`Did not find a matching implementation for protocol version ${protocolVersion} and library ${json.meta.library}. To convert 500-series NVMs, both the source and the target controller must be using Z-Wave SDK 6.61 or higher.`, import_error.ZWaveErrorCodes.NVM_NotSupported);
  }
  const { layout, nvmSize } = (0, import_shared2.resolveLayout)(impl.layout);
  const ret = new Uint8Array(nvmSize);
  const io = new import_NVMMemoryIO.NVMMemoryIO(ret);
  const nvm = new import_NVM500.NVM500(io);
  await nvm.erase({
    layout,
    nvmSize,
    library: impl.library,
    nvmDescriptor: {
      ...(0, import_shared.pick)(json.meta, [
        "manufacturerID",
        "productType",
        "productID",
        "firmwareID"
      ]),
      // Override the protocol version with the specified one
      protocolVersion,
      firmwareVersion: json.controller.applicationVersion
    }
  });
  const adapter = new import_adapter2.NVM500Adapter(nvm);
  const c = json.controller;
  await adapter.set({ domain: "controller", type: "homeId" }, import_shared.Bytes.from(c.ownHomeId.replace(/^0x/, ""), "hex"));
  await adapter.set({ domain: "controller", type: "learnedHomeId" }, c.learnedHomeId ? import_shared.Bytes.from(c.learnedHomeId.replace(/^0x/, ""), "hex") : void 0);
  await adapter.set({ domain: "controller", type: "nodeId" }, c.nodeId);
  await adapter.set({ domain: "controller", type: "lastNodeId" }, c.lastNodeId);
  await adapter.set({ domain: "controller", type: "maxNodeId" }, c.maxNodeId);
  await adapter.set({ domain: "controller", type: "reservedId" }, c.reservedId);
  await adapter.set({ domain: "controller", type: "staticControllerNodeId" }, c.staticControllerNodeId);
  await adapter.set({ domain: "controller", type: "controllerConfiguration" }, c.controllerConfiguration);
  await adapter.set({ domain: "controller", type: "sucUpdateEntries" }, c.sucUpdateEntries);
  await adapter.set({ domain: "controller", type: "sucLastIndex" }, c.sucLastIndex);
  if (c.systemState != void 0) {
    await adapter.set({ domain: "controller", type: "systemState" }, c.systemState);
  }
  await adapter.set({ domain: "controller", type: "watchdogStarted" }, c.watchdogStarted);
  if (c.rfConfig.powerLevelNormal != void 0) {
    await adapter.set({ domain: "controller", type: "powerLevelNormal" }, c.rfConfig.powerLevelNormal);
  }
  if (c.rfConfig.powerLevelLow != void 0) {
    await adapter.set({ domain: "controller", type: "powerLevelLow" }, c.rfConfig.powerLevelLow);
  }
  if (c.rfConfig.powerMode != void 0) {
    await adapter.set({ domain: "controller", type: "powerMode" }, c.rfConfig.powerMode);
  }
  if (c.rfConfig.powerModeExtintEnable != void 0) {
    await adapter.set({ domain: "controller", type: "powerModeExtintEnable" }, c.rfConfig.powerModeExtintEnable);
  }
  if (c.rfConfig.powerModeWutTimeout != void 0) {
    await adapter.set({ domain: "controller", type: "powerModeWutTimeout" }, c.rfConfig.powerModeWutTimeout);
  }
  await adapter.set({ domain: "controller", type: "preferredRepeaters" }, c.preferredRepeaters);
  await adapter.set({ domain: "controller", type: "commandClasses" }, c.commandClasses);
  if (c.applicationData) {
    await adapter.set({ domain: "controller", type: "applicationData" }, import_shared.Bytes.from(c.applicationData, "hex"));
  }
  const appRouteLock = [];
  const routeSlaveSUC = [];
  const pendingDiscovery = [];
  const sucPendingUpdate = [];
  const virtualNodeIds = [];
  for (const [id, node] of Object.entries(json.nodes)) {
    const nodeId = parseInt(id);
    if (!nodeHasInfo(node)) {
      virtualNodeIds.push(nodeId);
      continue;
    }
    if (node.appRouteLock)
      appRouteLock.push(nodeId);
    if (node.routeSlaveSUC)
      routeSlaveSUC.push(nodeId);
    if (node.pendingDiscovery)
      pendingDiscovery.push(nodeId);
    if (node.sucPendingUpdate)
      sucPendingUpdate.push(nodeId);
    await adapter.set({ domain: "node", nodeId, type: "info" }, {
      nodeId,
      ...node
    });
    if (node.lwr || node.nlwr) {
      await adapter.set({ domain: "node", nodeId, type: "routes" }, {
        lwr: node.lwr ?? void 0,
        nlwr: node.nlwr ?? void 0
      });
    }
  }
  await adapter.set({ domain: "controller", type: "appRouteLock" }, [...appRouteLock]);
  await adapter.set({ domain: "controller", type: "routeSlaveSUC" }, [...routeSlaveSUC]);
  await adapter.set({ domain: "controller", type: "sucPendingUpdate" }, [...sucPendingUpdate]);
  await adapter.set({ domain: "controller", type: "virtualNodeIds" }, [...virtualNodeIds]);
  await adapter.set({ domain: "controller", type: "pendingDiscovery" }, [...pendingDiscovery]);
  await adapter.commit();
  await io.close();
  return ret;
}
__name(jsonToNVM500, "jsonToNVM500");
function json500To700(json, truncateApplicationData) {
  const source = (0, import_shared.cloneDeep)(json);
  let controllerNode = source.nodes[source.controller.nodeId || 1];
  if (!nodeHasInfo(controllerNode)) {
    controllerNode = {
      isListening: true,
      optionalFunctionality: false,
      // Static PC Controller
      genericDeviceClass: 2,
      specificDeviceClass: 1
    };
  }
  let applicationData = null;
  if (source.controller.applicationData) {
    let raw = import_shared.Bytes.from(source.controller.applicationData, "hex");
    let start = 0;
    while (start < raw.length && raw[start] === 0) {
      start++;
    }
    let end = raw.length - 1;
    while (end > start && raw[end] === 0) {
      end--;
    }
    raw = raw.subarray(start, end + 1);
    if (raw.length > 512) {
      if (!truncateApplicationData) {
        throw new import_error.ZWaveError("Invalid NVM JSON: Application data would be truncated! Set truncateApplicationData to true to allow this.", import_error.ZWaveErrorCodes.NVM_InvalidJSON);
      }
      raw = raw.subarray(0, 512);
    }
    applicationData = raw.toString("hex");
  }
  let controllerConfiguration = source.controller.controllerConfiguration;
  if (source.controller.controllerConfiguration === 255) {
    controllerConfiguration = import_core.ControllerCapabilityFlags.SISPresent | import_core.ControllerCapabilityFlags.WasRealPrimary | import_core.ControllerCapabilityFlags.SUC;
  }
  let homeId;
  if (!!(controllerConfiguration & import_core.ControllerCapabilityFlags.OnOtherNetwork) && source.controller.learnedHomeId && source.controller.nodeId) {
    homeId = source.controller.learnedHomeId;
  } else {
    homeId = source.controller.ownHomeId;
    controllerConfiguration &= ~import_core.ControllerCapabilityFlags.OnOtherNetwork;
    if (controllerConfiguration & import_core.ControllerCapabilityFlags.SUC) {
      source.controller.nodeId = source.controller.staticControllerNodeId || 1;
    } else {
      source.controller.nodeId = 1;
    }
  }
  let maxNodeId = source.controller.maxNodeId;
  if (maxNodeId === 255)
    maxNodeId = source.controller.lastNodeId;
  let reservedId = source.controller.reservedId;
  if (reservedId === 255)
    reservedId = 0;
  const ret = {
    // Start out with format 0 (= protocol version 7.0.0), the jsonToNVM routines will do further conversion
    format: 0,
    controller: {
      // This will contain the original 6.x protocol version, but the jsonToNVM routines will update it
      protocolVersion: source.controller.protocolVersion,
      applicationVersion: source.controller.applicationVersion,
      homeId,
      nodeId: source.controller.nodeId,
      lastNodeId: source.controller.lastNodeId,
      staticControllerNodeId: source.controller.staticControllerNodeId,
      sucLastIndex: source.controller.sucLastIndex,
      controllerConfiguration,
      sucUpdateEntries: source.controller.sucUpdateEntries,
      maxNodeId,
      reservedId,
      systemState: source.controller.systemState ?? 0,
      preferredRepeaters: source.controller.preferredRepeaters,
      // RF config exists on both series but isn't compatible
      isListening: controllerNode.isListening,
      optionalFunctionality: controllerNode.optionalFunctionality,
      genericDeviceClass: controllerNode.genericDeviceClass,
      specificDeviceClass: controllerNode.specificDeviceClass ?? 0,
      commandClasses: {
        includedInsecurely: source.controller.commandClasses,
        includedSecurelyInsecureCCs: [],
        includedSecurelySecureCCs: []
      },
      applicationData
    },
    // The node entries are actually compatible between the two JSON versions
    // but the types are structured differently
    nodes: source.nodes
  };
  return ret;
}
__name(json500To700, "json500To700");
function json700To500(json) {
  const source = (0, import_shared.cloneDeep)(json);
  let ownHomeId;
  let learnedHomeId = null;
  let nodeId;
  if (source.controller.controllerConfiguration & import_core.ControllerCapabilityFlags.OnOtherNetwork) {
    ownHomeId = learnedHomeId = source.controller.homeId;
    nodeId = source.controller.nodeId;
  } else {
    ownHomeId = source.controller.homeId;
    nodeId = 0;
  }
  const ret = {
    format: 500,
    controller: {
      // This will contain the original 7.x protocol version, but the jsonToNVM routines will update it
      protocolVersion: source.controller.protocolVersion,
      applicationVersion: source.controller.applicationVersion,
      // The 700 series does not distinguish between own and learned home ID in NVM
      // We infer it from the controller configuration if we need it
      ownHomeId,
      learnedHomeId,
      nodeId,
      lastNodeId: source.controller.lastNodeId,
      staticControllerNodeId: source.controller.staticControllerNodeId,
      sucLastIndex: source.controller.sucLastIndex,
      controllerConfiguration: source.controller.controllerConfiguration,
      sucUpdateEntries: source.controller.sucUpdateEntries,
      maxNodeId: source.controller.maxNodeId,
      reservedId: source.controller.reservedId,
      systemState: source.controller.systemState,
      watchdogStarted: 0,
      preferredRepeaters: json.controller.preferredRepeaters ?? [],
      // RF config exists on both series but isn't compatible. So set the default,
      // it will be taken from the target NVM on restore.
      rfConfig: {
        powerLevelNormal: [255, 255, 255],
        powerLevelLow: [255, 255, 255],
        powerMode: 255,
        powerModeExtintEnable: 255,
        powerModeWutTimeout: 4294967295
      },
      commandClasses: source.controller.commandClasses.includedInsecurely,
      applicationData: source.controller.applicationData
    },
    // The node entries are actually compatible between the two JSON versions
    // just the types are structured differently
    nodes: source.nodes
  };
  return ret;
}
__name(json700To500, "json700To500");
async function migrateNVM(sourceNVM, targetNVM, options = {}) {
  let source;
  let target;
  let sourceProtocolFileFormat;
  let targetProtocolFileFormat;
  try {
    source = {
      type: 700,
      json: await nvmToJSON(sourceNVM)
    };
    sourceProtocolFileFormat = source.json.format;
  } catch (e) {
    if ((0, import_error.isZWaveError)(e) && e.code === import_error.ZWaveErrorCodes.NVM_InvalidFormat) {
      source = {
        type: 500,
        json: await nvm500ToJSON(sourceNVM)
      };
    } else if ((0, import_error.isZWaveError)(e) && e.code === import_error.ZWaveErrorCodes.NVM_NotSupported && (0, import_typeguards.isObject)(e.context) && typeof e.context.protocolFileFormat === "number") {
      source = { type: "unknown" };
      sourceProtocolFileFormat = e.context.protocolFileFormat;
    } else {
      source = { type: "unknown" };
    }
  }
  try {
    target = {
      type: 700,
      json: await nvmToJSON(targetNVM)
    };
    targetProtocolFileFormat = target.json.format;
  } catch (e) {
    if ((0, import_error.isZWaveError)(e) && e.code === import_error.ZWaveErrorCodes.NVM_InvalidFormat) {
      target = {
        type: 500,
        json: await nvm500ToJSON(targetNVM)
      };
    } else if ((0, import_error.isZWaveError)(e) && e.code === import_error.ZWaveErrorCodes.NVM_NotSupported && source.type === 700 && (0, import_typeguards.isObject)(e.context) && typeof e.context.protocolFileFormat === "number") {
      target = { type: "unknown" };
      targetProtocolFileFormat = e.context.protocolFileFormat;
    } else {
      target = { type: "unknown" };
    }
  }
  const { preserveApplicationData = true, preserveNeighbors = true, preserveRoutes = true, preserveSUCUpdateEntries = true } = options;
  const preserveAll = preserveApplicationData && preserveNeighbors && preserveRoutes && preserveSUCUpdateEntries;
  if (target.type === "unknown" && targetProtocolFileFormat && targetProtocolFileFormat > import_consts.MAX_PROTOCOL_FILE_FORMAT && sourceProtocolFileFormat && sourceProtocolFileFormat <= targetProtocolFileFormat && sourceNVM.length === targetNVM.length && preserveAll) {
    return sourceNVM;
  } else if (source.type === 700 && target.type === 700 && sourceNVM.length === targetNVM.length && source.json.meta.sharedFileSystem === target.json.meta.sharedFileSystem && preserveAll) {
    const sourceProtocolVersion = source.json.controller.protocolVersion;
    const targetProtocolVersion = target.json.controller.protocolVersion;
    const sourceApplicationVersion = source.json.controller.applicationVersion;
    const targetApplicationVersion = target.json.controller.applicationVersion;
    if ((0, import_gte.default)(targetProtocolVersion, "7.16.0") && (0, import_gte.default)(targetProtocolVersion, sourceProtocolVersion) && (0, import_gte.default)(targetApplicationVersion, targetProtocolVersion) && (0, import_gte.default)(sourceApplicationVersion, sourceProtocolVersion) && (0, import_lt.default)(sourceApplicationVersion, "255.0.0") && (0, import_lt.default)(targetApplicationVersion, "255.0.0") && !hasShiftedAppVersion800File(source.json)) {
      return sourceNVM;
    }
  } else if (source.type === "unknown" && target.type !== "unknown") {
    throw new import_error.ZWaveError(`The source NVM has an unsupported format, which cannot be restored on a ${target.type}-series NVM!`, import_error.ZWaveErrorCodes.NVM_NotSupported);
  } else if (source.type !== "unknown" && target.type === "unknown") {
    throw new import_error.ZWaveError(`The target NVM has an unsupported format, cannot restore ${source.type}-series NVM onto it!`, import_error.ZWaveErrorCodes.NVM_NotSupported);
  } else if (source.type === "unknown" && target.type === "unknown") {
    return sourceNVM;
  }
  source = source;
  target = target;
  if (target.type === 700 && (0, import_gte.default)(target.json.controller.applicationVersion, "255.0.0")) {
    target.json.controller.applicationVersion = target.json.controller.protocolVersion;
  }
  source.json.controller.applicationVersion = target.json.controller.applicationVersion;
  if (!preserveApplicationData) {
    source.json.controller.applicationData = void 0;
  }
  if (!preserveNeighbors) {
    for (const node of Object.values(source.json.nodes)) {
      if (!node.isVirtual) {
        node.neighbors = [];
      }
    }
  }
  if (!preserveRoutes) {
    for (const node of Object.values(source.json.nodes)) {
      if (!node.isVirtual) {
        node.appRouteLock = false;
        node.lwr = void 0;
        node.nlwr = void 0;
      }
    }
  }
  if (!preserveSUCUpdateEntries) {
    source.json.controller.sucUpdateEntries = [];
    source.json.controller.sucLastIndex = 255;
    for (const node of Object.values(source.json.nodes)) {
      if (!node.isVirtual) {
        node.sucUpdateIndex = 254;
        node.sucPendingUpdate = false;
      }
    }
  }
  if (source.type === 500 && target.type === 500) {
    const json = {
      ...source.json,
      meta: target.json.meta
    };
    json.controller.rfConfig = target.json.controller.rfConfig;
    return jsonToNVM500(json, target.json.controller.protocolVersion);
  } else if (source.type === 500 && target.type === 700) {
    const json = {
      lrNodes: {},
      ...json500To700(source.json, true),
      meta: target.json.meta
    };
    json.controller.rfConfig = target.json.controller.rfConfig;
    return jsonToNVM(json, target.json.controller.applicationVersion);
  } else if (source.type === 700 && target.type === 500) {
    const json = {
      ...json700To500(source.json),
      meta: target.json.meta
    };
    json.controller.rfConfig = target.json.controller.rfConfig;
    return jsonToNVM500(json, target.json.controller.protocolVersion);
  } else {
    const json = {
      ...source.json,
      meta: target.json.meta
    };
    return jsonToNVM(json, target.json.controller.applicationVersion);
  }
}
__name(migrateNVM, "migrateNVM");
function hasShiftedAppVersion800File(json) {
  if (!json.meta.sharedFileSystem)
    return false;
  const protocolVersion = (0, import_parse.default)(json.controller.protocolVersion);
  if (!protocolVersion)
    return false;
  const applicationVersion = (0, import_parse.default)(json.controller.applicationVersion);
  if (!applicationVersion)
    return false;
  if (json.applicationFileFormat !== protocolVersion.major)
    return false;
  if (Math.abs(applicationVersion.major - protocolVersion.minor) > 3) {
    return false;
  }
  return true;
}
__name(hasShiftedAppVersion800File, "hasShiftedAppVersion800File");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  json500To700,
  json700To500,
  jsonToNVM,
  jsonToNVM500,
  migrateNVM,
  nodeHasInfo,
  nvm500ToJSON,
  nvmObjectsToJSON,
  nvmToJSON
});
//# sourceMappingURL=convert.js.map
