import { type BytesView } from "@zwave-js/shared";
import type { NVMAccess, NVMIO } from "../common/definitions.js";
export declare class BufferedNVMReader implements NVMIO {
    constructor(inner: NVMIO);
    private _inner;
    private _buffer;
    open(access: NVMAccess.Read | NVMAccess.Write): Promise<NVMAccess>;
    get size(): number;
    get accessMode(): NVMAccess;
    determineChunkSize(): Promise<number>;
    private readBuffered;
    read(offset: number, length: number): Promise<{
        buffer: BytesView;
        endOfFile: boolean;
    }>;
    write(offset: number, data: BytesView): Promise<{
        bytesWritten: number;
        endOfFile: boolean;
    }>;
    close(): Promise<void>;
}
//# sourceMappingURL=BufferedNVMReader.d.ts.map