"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var NVMFileIO_exports = {};
__export(NVMFileIO_exports, {
  NVMFileIO: () => NVMFileIO
});
module.exports = __toCommonJS(NVMFileIO_exports);
var import_core = require("@zwave-js/core");
var import_promises = __toESM(require("node:fs/promises"), 1);
var import_definitions = require("../common/definitions.js");
class NVMFileIO {
  static {
    __name(this, "NVMFileIO");
  }
  constructor(path) {
    this._path = path;
    this._accessMode = import_definitions.NVMAccess.None;
  }
  _path;
  _handle;
  _chunkSize = 16 * 1024;
  // We could read more, but 16 KB chunks are more than enough for reading NVM contents
  async open(access) {
    let flags;
    switch (access) {
      case import_definitions.NVMAccess.Read:
        flags = "r";
        break;
      case import_definitions.NVMAccess.Write:
      case import_definitions.NVMAccess.ReadWrite:
        flags = "r+";
        access = import_definitions.NVMAccess.ReadWrite;
        break;
      default:
        throw new Error("Invalid access mode");
    }
    this._handle = await import_promises.default.open(this._path, flags);
    this._size = (await this._handle.stat()).size;
    this._accessMode = access;
    return access;
  }
  _size;
  get size() {
    if (this._size == void 0) {
      throw new import_core.ZWaveError("The NVM file is not open", import_core.ZWaveErrorCodes.NVM_NotOpen);
    }
    return this._size;
  }
  _accessMode;
  get accessMode() {
    return this._accessMode;
  }
  determineChunkSize() {
    return Promise.resolve(this._chunkSize);
  }
  async read(offset, length) {
    if (this._handle == void 0) {
      throw new import_core.ZWaveError("The NVM file is not open", import_core.ZWaveErrorCodes.NVM_NotOpen);
    }
    const readResult = await this._handle.read({
      buffer: new Uint8Array(length),
      position: offset
    });
    const endOfFile = offset + readResult.bytesRead >= this.size;
    return {
      buffer: readResult.buffer.subarray(0, readResult.bytesRead),
      endOfFile
    };
  }
  async write(offset, data) {
    if (this._handle == void 0) {
      throw new import_core.ZWaveError("The NVM file is not open", import_core.ZWaveErrorCodes.NVM_NotOpen);
    }
    if (offset + data.length > this.size) {
      throw new import_core.ZWaveError("Write would exceed the NVM size", import_core.ZWaveErrorCodes.NVM_NoSpace);
    }
    const writeResult = await this._handle.write(data, 0, data.length, offset);
    const endOfFile = offset + writeResult.bytesWritten >= this.size;
    return { bytesWritten: writeResult.bytesWritten, endOfFile };
  }
  async close() {
    await this._handle?.close();
    this._handle = void 0;
    this._accessMode = import_definitions.NVMAccess.None;
    this._size = void 0;
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  NVMFileIO
});
//# sourceMappingURL=NVMFileIO.js.map
