import { CommandClasses } from "@zwave-js/core";
import { Bytes } from "@zwave-js/shared";
import type { NVM3Object } from "../object.js";
import { NVMFile, type NVMFileCreationOptions, type NVMFileDeserializationOptions } from "./NVMFile.js";
export interface ApplicationCCsFileOptions extends NVMFileCreationOptions {
    includedInsecurely: CommandClasses[];
    includedSecurelyInsecureCCs: CommandClasses[];
    includedSecurelySecureCCs: CommandClasses[];
}
export declare const ApplicationCCsFileID = 103;
export declare class ApplicationCCsFile extends NVMFile {
    constructor(options: NVMFileDeserializationOptions | ApplicationCCsFileOptions);
    includedInsecurely: CommandClasses[];
    includedSecurelyInsecureCCs: CommandClasses[];
    includedSecurelySecureCCs: CommandClasses[];
    serialize(): NVM3Object & {
        data: Bytes;
    };
    toJSON(): {
        "included insecurely": string;
        "included securely (insecure)": string;
        "included securely (secure)": string;
    };
}
//# sourceMappingURL=ApplicationCCsFile.d.ts.map