import { NodeIDType, RFRegion } from "@zwave-js/core";
import { type AllOrNone, Bytes } from "@zwave-js/shared";
import type { NVM3Object } from "../object.js";
import { NVMFile, type NVMFileCreationOptions, type NVMFileDeserializationOptions } from "./NVMFile.js";
export type ApplicationRFConfigFileOptions = NVMFileCreationOptions & {
    rfRegion: RFRegion;
    txPower: number;
    measured0dBm: number;
} & AllOrNone<{
    enablePTI?: number;
    maxTXPower?: number;
}> & {
    nodeIdType?: number;
};
export declare const ApplicationRFConfigFileID = 104;
export declare class ApplicationRFConfigFile extends NVMFile {
    constructor(options: NVMFileDeserializationOptions | ApplicationRFConfigFileOptions);
    rfRegion: RFRegion;
    txPower: number;
    measured0dBm: number;
    enablePTI?: number;
    maxTXPower?: number;
    nodeIdType?: NodeIDType;
    serialize(): NVM3Object & {
        data: Bytes;
    };
    toJSON(): Record<string, any>;
}
//# sourceMappingURL=ApplicationRFConfigFile.d.ts.map