"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var RouteCacheFiles_exports = {};
__export(RouteCacheFiles_exports, {
  ROUTECACHES_PER_FILE_V1: () => ROUTECACHES_PER_FILE_V1,
  RouteCacheFileV0: () => RouteCacheFileV0,
  RouteCacheFileV0IDBase: () => RouteCacheFileV0IDBase,
  RouteCacheFileV1: () => RouteCacheFileV1,
  RouteCacheFileV1IDBase: () => RouteCacheFileV1IDBase,
  nodeIdToRouteCacheFileIDV0: () => nodeIdToRouteCacheFileIDV0,
  nodeIdToRouteCacheFileIDV1: () => nodeIdToRouteCacheFileIDV1
});
module.exports = __toCommonJS(RouteCacheFiles_exports);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_routeCache = require("../../common/routeCache.js");
var import_NVMFile = require("./NVMFile.js");
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
const ROUTECACHES_PER_FILE_V1 = 8;
const RouteCacheFileV0IDBase = 328704;
function nodeIdToRouteCacheFileIDV0(nodeId) {
  return RouteCacheFileV0IDBase + nodeId - 1;
}
__name(nodeIdToRouteCacheFileIDV0, "nodeIdToRouteCacheFileIDV0");
let RouteCacheFileV0 = (() => {
  let _classDecorators = [(0, import_NVMFile.nvmFileID)((id) => id >= RouteCacheFileV0IDBase && id < RouteCacheFileV0IDBase + import_core.MAX_NODES), (0, import_NVMFile.nvmSection)("protocol")];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_NVMFile.NVMFile;
  var RouteCacheFileV02 = class extends _classSuper {
    static {
      __name(this, "RouteCacheFileV0");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      RouteCacheFileV02 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      if ((0, import_NVMFile.gotDeserializationOptions)(options)) {
        const nodeId = this.fileId - RouteCacheFileV0IDBase + 1;
        const lwr = (0, import_routeCache.parseRoute)(this.payload, 0);
        const nlwr = (0, import_routeCache.parseRoute)(this.payload, import_core.MAX_REPEATERS + 1);
        this.routeCache = { nodeId, lwr, nlwr };
      } else {
        this.routeCache = options.routeCache;
      }
    }
    routeCache;
    serialize() {
      this.fileId = nodeIdToRouteCacheFileIDV0(this.routeCache.nodeId);
      this.payload = import_shared.Bytes.concat([
        (0, import_routeCache.encodeRoute)(this.routeCache.lwr),
        (0, import_routeCache.encodeRoute)(this.routeCache.nlwr)
      ]);
      return super.serialize();
    }
    // oxlint-disable-next-line typescript/explicit-module-boundary-types
    toJSON() {
      return {
        ...super.toJSON(),
        routeCache: this.routeCache
      };
    }
  };
  return RouteCacheFileV02 = _classThis;
})();
const RouteCacheFileV1IDBase = 332800;
function nodeIdToRouteCacheFileIDV1(nodeId) {
  return RouteCacheFileV1IDBase + Math.floor((nodeId - 1) / ROUTECACHES_PER_FILE_V1);
}
__name(nodeIdToRouteCacheFileIDV1, "nodeIdToRouteCacheFileIDV1");
let RouteCacheFileV1 = (() => {
  let _classDecorators = [(0, import_NVMFile.nvmFileID)((id) => id >= RouteCacheFileV1IDBase && id < RouteCacheFileV1IDBase + import_core.MAX_NODES / ROUTECACHES_PER_FILE_V1), (0, import_NVMFile.nvmSection)("protocol")];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_NVMFile.NVMFile;
  var RouteCacheFileV12 = class extends _classSuper {
    static {
      __name(this, "RouteCacheFileV1");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      RouteCacheFileV12 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      if ((0, import_NVMFile.gotDeserializationOptions)(options)) {
        this.routeCaches = [];
        for (let i = 0; i < ROUTECACHES_PER_FILE_V1; i++) {
          const offset = i * 2 * (import_core.MAX_REPEATERS + 1);
          const entry = this.payload.subarray(offset, offset + 2 * (import_core.MAX_REPEATERS + 1));
          if (entry.equals(import_routeCache.emptyRouteCache))
            continue;
          const nodeId = (this.fileId - RouteCacheFileV1IDBase) * ROUTECACHES_PER_FILE_V1 + 1 + i;
          const lwr = (0, import_routeCache.parseRoute)(this.payload, offset);
          const nlwr = (0, import_routeCache.parseRoute)(this.payload, offset + import_core.MAX_REPEATERS + 1);
          this.routeCaches.push({ nodeId, lwr, nlwr });
        }
      } else {
        this.routeCaches = options.routeCaches;
      }
    }
    routeCaches;
    serialize() {
      this.routeCaches.sort((a, b) => a.nodeId - b.nodeId);
      const minNodeId = this.routeCaches[0].nodeId;
      this.fileId = nodeIdToRouteCacheFileIDV1(minNodeId);
      this.payload = new import_shared.Bytes(ROUTECACHES_PER_FILE_V1 * import_routeCache.ROUTECACHE_SIZE).fill(import_routeCache.EMPTY_ROUTECACHE_FILL);
      const minFileNodeId = Math.floor((minNodeId - 1) / ROUTECACHES_PER_FILE_V1) * ROUTECACHES_PER_FILE_V1 + 1;
      for (const routeCache of this.routeCaches) {
        const offset = (routeCache.nodeId - minFileNodeId) * import_routeCache.ROUTECACHE_SIZE;
        const routes = import_shared.Bytes.concat([
          (0, import_routeCache.encodeRoute)(routeCache.lwr),
          (0, import_routeCache.encodeRoute)(routeCache.nlwr)
        ]);
        this.payload.set(routes, offset);
      }
      return super.serialize();
    }
    // oxlint-disable-next-line typescript/explicit-module-boundary-types
    toJSON() {
      return {
        ...super.toJSON(),
        "route caches": this.routeCaches
      };
    }
  };
  return RouteCacheFileV12 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ROUTECACHES_PER_FILE_V1,
  RouteCacheFileV0,
  RouteCacheFileV0IDBase,
  RouteCacheFileV1,
  RouteCacheFileV1IDBase,
  nodeIdToRouteCacheFileIDV0,
  nodeIdToRouteCacheFileIDV1
});
//# sourceMappingURL=RouteCacheFiles.js.map
