import { type BytesView } from "@zwave-js/shared";
import { FragmentType, ObjectType } from "./consts.js";
export interface NVM3ObjectHeader {
    offset: number;
    type: ObjectType;
    key: number;
    fragmentType: FragmentType;
    /** The length of the header */
    headerSize: number;
    /** The length of the object data */
    fragmentSize: number;
    /** The total length of the object in the NVM */
    alignedSize: number;
}
export interface NVM3Object {
    type: ObjectType;
    fragmentType: FragmentType;
    key: number;
    data?: BytesView;
}
export declare function serializeObject(obj: NVM3Object): BytesView;
export declare function fragmentLargeObject(obj: NVM3Object & {
    type: ObjectType.DataLarge | ObjectType.CounterLarge;
}, maxFirstFragmentSizeWithHeader: number, maxFragmentSizeWithHeader: number): NVM3Object[];
export declare function getAlignedSize(size: number): number;
export declare function getHeaderSize(obj: NVM3Object): number;
export declare function getFragmentSize(obj: NVM3Object): number;
export declare function getRequiredSpace(obj: NVM3Object): number;
export declare function getObjectHeader(obj: NVM3Object, offset: number): NVM3ObjectHeader;
//# sourceMappingURL=object.d.ts.map