"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var object_exports = {};
__export(object_exports, {
  fragmentLargeObject: () => fragmentLargeObject,
  getAlignedSize: () => getAlignedSize,
  getFragmentSize: () => getFragmentSize,
  getHeaderSize: () => getHeaderSize,
  getObjectHeader: () => getObjectHeader,
  getRequiredSpace: () => getRequiredSpace,
  serializeObject: () => serializeObject
});
module.exports = __toCommonJS(object_exports);
var import_shared = require("@zwave-js/shared");
var import_consts = require("./consts.js");
var import_utils = require("./utils.js");
function serializeObject(obj) {
  const isLarge = obj.type === import_consts.ObjectType.DataLarge || obj.type === import_consts.ObjectType.CounterLarge;
  const headerSize = isLarge ? import_consts.NVM3_OBJ_HEADER_SIZE_LARGE : import_consts.NVM3_OBJ_HEADER_SIZE_SMALL;
  const dataLength = obj.data?.length ?? 0;
  const ret = new import_shared.Bytes(dataLength + headerSize);
  if (isLarge) {
    let hdr2 = dataLength & import_consts.NVM3_OBJ_LARGE_LEN_MASK;
    const hdr1 = obj.type & import_consts.NVM3_OBJ_TYPE_MASK | (obj.key & import_consts.NVM3_OBJ_KEY_MASK) << import_consts.NVM3_OBJ_KEY_SHIFT | (obj.fragmentType & import_consts.NVM3_OBJ_FRAGTYPE_MASK) << import_consts.NVM3_OBJ_FRAGTYPE_SHIFT;
    const bergerCode = (0, import_utils.computeBergerCodeMulti)([hdr1, hdr2], 32 + import_consts.NVM3_CODE_LARGE_SHIFT);
    hdr2 |= bergerCode << import_consts.NVM3_CODE_LARGE_SHIFT;
    ret.writeInt32LE(hdr1, 0);
    ret.writeInt32LE(hdr2, 4);
  } else {
    let typeAndLen = obj.type;
    if (typeAndLen === import_consts.ObjectType.DataSmall && dataLength > 0) {
      typeAndLen += dataLength;
    }
    let hdr1 = typeAndLen & import_consts.NVM3_OBJ_TYPE_MASK | (obj.key & import_consts.NVM3_OBJ_KEY_MASK) << import_consts.NVM3_OBJ_KEY_SHIFT;
    const bergerCode = (0, import_utils.computeBergerCode)(hdr1, import_consts.NVM3_CODE_SMALL_SHIFT);
    hdr1 |= bergerCode << import_consts.NVM3_CODE_SMALL_SHIFT;
    ret.writeInt32LE(hdr1, 0);
  }
  if (obj.data) {
    ret.set(obj.data, headerSize);
  }
  return ret;
}
__name(serializeObject, "serializeObject");
function fragmentLargeObject(obj, maxFirstFragmentSizeWithHeader, maxFragmentSizeWithHeader) {
  const ret = [];
  if (obj.data.length + import_consts.NVM3_OBJ_HEADER_SIZE_LARGE <= maxFirstFragmentSizeWithHeader) {
    return [obj];
  }
  let offset = 0;
  while (offset < obj.data.length) {
    const fragmentSize = offset === 0 ? maxFirstFragmentSizeWithHeader - import_consts.NVM3_OBJ_HEADER_SIZE_LARGE : maxFragmentSizeWithHeader - import_consts.NVM3_OBJ_HEADER_SIZE_LARGE;
    const data = obj.data.subarray(offset, offset + fragmentSize);
    ret.push({
      type: obj.type,
      key: obj.key,
      fragmentType: offset === 0 ? import_consts.FragmentType.First : data.length + import_consts.NVM3_OBJ_HEADER_SIZE_LARGE < maxFragmentSizeWithHeader ? import_consts.FragmentType.Last : import_consts.FragmentType.Next,
      data
    });
    offset += fragmentSize;
  }
  return ret;
}
__name(fragmentLargeObject, "fragmentLargeObject");
function getAlignedSize(size) {
  return size + import_consts.NVM3_WORD_SIZE - 1 & ~(import_consts.NVM3_WORD_SIZE - 1);
}
__name(getAlignedSize, "getAlignedSize");
function getHeaderSize(obj) {
  switch (obj.type) {
    case import_consts.ObjectType.Deleted:
    case import_consts.ObjectType.CounterSmall:
    case import_consts.ObjectType.DataSmall:
      return import_consts.NVM3_OBJ_HEADER_SIZE_SMALL;
    case import_consts.ObjectType.CounterLarge:
    case import_consts.ObjectType.DataLarge:
      return import_consts.NVM3_OBJ_HEADER_SIZE_LARGE;
  }
}
__name(getHeaderSize, "getHeaderSize");
function getFragmentSize(obj) {
  switch (obj.type) {
    case import_consts.ObjectType.Deleted:
      return 0;
    case import_consts.ObjectType.CounterSmall:
      return import_consts.NVM3_COUNTER_SIZE;
    case import_consts.ObjectType.DataSmall:
    case import_consts.ObjectType.DataLarge:
    case import_consts.ObjectType.CounterLarge:
      return obj.data?.length ?? 0;
  }
}
__name(getFragmentSize, "getFragmentSize");
function getRequiredSpace(obj) {
  return getHeaderSize(obj) + getAlignedSize(getFragmentSize(obj));
}
__name(getRequiredSpace, "getRequiredSpace");
function getObjectHeader(obj, offset) {
  const headerSize = getHeaderSize(obj);
  const fragmentSize = getFragmentSize(obj);
  return {
    offset,
    key: obj.key,
    type: obj.type,
    fragmentType: obj.fragmentType,
    headerSize,
    fragmentSize,
    alignedSize: headerSize + getAlignedSize(fragmentSize)
  };
}
__name(getObjectHeader, "getObjectHeader");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  fragmentLargeObject,
  getAlignedSize,
  getFragmentSize,
  getHeaderSize,
  getObjectHeader,
  getRequiredSpace,
  serializeObject
});
//# sourceMappingURL=object.js.map
