"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var page_exports = {};
__export(page_exports, {
  pageSizeFromBits: () => pageSizeFromBits,
  pageSizeToBits: () => pageSizeToBits,
  serializePageHeader: () => serializePageHeader
});
module.exports = __toCommonJS(page_exports);
var import_shared = require("@zwave-js/shared");
var import_consts = require("./consts.js");
var import_utils = require("./utils.js");
function pageSizeToBits(pageSize) {
  return Math.ceil(Math.log2(pageSize) - Math.log2(import_consts.NVM3_MIN_PAGE_SIZE));
}
__name(pageSizeToBits, "pageSizeToBits");
function pageSizeFromBits(bits) {
  return import_consts.NVM3_MIN_PAGE_SIZE * Math.pow(2, bits);
}
__name(pageSizeFromBits, "pageSizeFromBits");
function serializePageHeader(header) {
  const ret = new import_shared.Bytes(import_consts.NVM3_PAGE_HEADER_SIZE);
  ret.writeUInt16LE(header.version, 0);
  ret.writeUInt16LE(import_consts.NVM3_PAGE_MAGIC, 2);
  let eraseCount = header.eraseCount & import_consts.NVM3_PAGE_COUNTER_MASK;
  const eraseCountCode = (0, import_utils.computeBergerCode)(eraseCount, import_consts.NVM3_PAGE_COUNTER_SIZE);
  eraseCount |= eraseCountCode << import_consts.NVM3_PAGE_COUNTER_SIZE;
  ret.writeInt32LE(eraseCount, 4);
  let eraseCountInv = ~header.eraseCount & import_consts.NVM3_PAGE_COUNTER_MASK;
  const eraseCountInvCode = (0, import_utils.computeBergerCode)(eraseCountInv, import_consts.NVM3_PAGE_COUNTER_SIZE);
  eraseCountInv |= eraseCountInvCode << import_consts.NVM3_PAGE_COUNTER_SIZE;
  ret.writeInt32LE(eraseCountInv, 8);
  ret.writeUInt32LE(header.status, 12);
  const devInfo = header.deviceFamily & 2047 | (header.writeSize & 1) << 11 | (header.memoryMapped ? 1 : 0) << 12 | pageSizeToBits(header.pageSize) << 13;
  ret.writeUInt16LE(devInfo, 16);
  const formatInfo = header.encrypted ? 65534 : 65535;
  ret.writeUInt16LE(formatInfo, 18);
  return ret;
}
__name(serializePageHeader, "serializePageHeader");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  pageSizeFromBits,
  pageSizeToBits,
  serializePageHeader
});
//# sourceMappingURL=page.js.map
