"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var adapter_exports = {};
__export(adapter_exports, {
  NVM500Adapter: () => NVM500Adapter
});
module.exports = __toCommonJS(adapter_exports);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_helpers = require("alcalzone-shared/helpers");
var import_consts = require("../../consts.js");
var import_shared2 = require("./shared.js");
class NVM500Adapter {
  static {
    __name(this, "NVM500Adapter");
  }
  constructor(nvm) {
    this._nvm = nvm;
  }
  _nvm;
  async get(property, required) {
    const info = this._nvm.info ?? await this._nvm.init();
    let ret;
    if (property.domain === "controller") {
      ret = await this.getControllerNVMProperty(info, property);
    } else if (property.domain === "lrnode") {
      throw new import_core.ZWaveError(`500 series NVM has no support for Long Range node information`, import_core.ZWaveErrorCodes.NVM_ObjectNotFound);
    } else {
      ret = await this.getNodeNVMProperty(property);
    }
    if (required && ret === void 0) {
      throw new import_core.ZWaveError(`NVM data for property ${JSON.stringify(property)} not found`, import_core.ZWaveErrorCodes.NVM_ObjectNotFound);
    }
    return ret;
  }
  async getOnly(property) {
    const data = await this._nvm.get(property);
    return data?.[0];
  }
  async getSingle(property, index) {
    const data = await this._nvm.getSingle(property, index);
    return data;
  }
  getAll(property) {
    return this._nvm.get(property);
  }
  async getControllerNVMProperty(info, property) {
    switch (property.type) {
      case "protocolVersion":
        return info.nvmDescriptor.protocolVersion;
      case "applicationVersion":
        return info.nvmDescriptor.firmwareVersion;
      case "protocolFileFormat":
      case "applicationFileFormat":
        return 500;
      case "applicationData":
        return this.getOnly("EEOFFSET_HOST_OFFSET_START_far");
      case "applicationName":
        return;
      case "homeId": {
        const homeId = await this.getOnly("EX_NVM_HOME_ID_far");
        if (homeId == void 0)
          return;
        const ret = new import_shared.Bytes(4).fill(0);
        ret.writeUInt32BE(homeId, 0);
        return ret;
      }
      case "learnedHomeId": {
        const homeId = await this.getOnly("NVM_HOMEID_far");
        if (homeId == void 0)
          return;
        const ret = new import_shared.Bytes(4).fill(0);
        ret.writeUInt32BE(homeId, 0);
        return ret;
      }
      case "nodeId":
        return this.getOnly("NVM_NODEID_far");
      case "lastNodeId":
        return this.getOnly("EX_NVM_LAST_USED_NODE_ID_START_far");
      case "staticControllerNodeId":
        return this.getOnly("EX_NVM_STATIC_CONTROLLER_NODE_ID_START_far");
      case "sucLastIndex":
        return this.getOnly("EX_NVM_SUC_LAST_INDEX_START_far");
      case "controllerConfiguration":
        return this.getOnly("EX_NVM_CONTROLLER_CONFIGURATION_far");
      case "maxNodeId":
        return this.getOnly("EX_NVM_MAX_NODE_ID_far");
      case "reservedId":
        return this.getOnly("EX_NVM_RESERVED_ID_far");
      case "systemState":
        return this.getOnly("NVM_SYSTEM_STATE");
      case "commandClasses": {
        const numCCs = await this.getOnly("EEOFFSET_CMDCLASS_LEN_far");
        const ret = await this.getAll("EEOFFSET_CMDCLASS_far");
        return ret?.slice(0, numCCs);
      }
      case "preferredRepeaters":
        return this.getOnly("NVM_PREFERRED_REPEATERS_far");
      case "appRouteLock": {
        return this.getOnly("EX_NVM_ROUTECACHE_APP_LOCK_far");
      }
      case "routeSlaveSUC": {
        return this.getOnly("EX_NVM_SUC_ROUTING_SLAVE_LIST_START_far");
      }
      case "sucPendingUpdate": {
        return this.getOnly("EX_NVM_PENDING_UPDATE_far");
      }
      case "pendingDiscovery": {
        return this.getOnly("NVM_PENDING_DISCOVERY_far");
      }
      case "nodeIds": {
        const nodeInfos = await this.getAll("EX_NVM_NODE_TABLE_START_far");
        return nodeInfos?.map((info2, index) => info2 ? index + 1 : void 0).filter((id) => id != void 0);
      }
      case "virtualNodeIds": {
        const ret = await this.getOnly("EX_NVM_BRIDGE_NODEPOOL_START_far");
        return ret ?? [];
      }
      case "sucUpdateEntries": {
        const ret = await this.getAll("EX_NVM_SUC_NODE_LIST_START_far");
        return ret?.filter(Boolean);
      }
      case "watchdogStarted":
        return this.getOnly("EEOFFSET_WATCHDOG_STARTED_far");
      case "powerLevelNormal":
        return this.getAll("EEOFFSET_POWERLEVEL_NORMAL_far");
      case "powerLevelLow":
        return this.getAll("EEOFFSET_POWERLEVEL_LOW_far");
      case "powerMode":
        return this.getOnly("EEOFFSET_MODULE_POWER_MODE_far");
      case "powerModeExtintEnable":
        return this.getOnly("EEOFFSET_MODULE_POWER_MODE_EXTINT_ENABLE_far");
      case "powerModeWutTimeout":
        return this.getOnly("EEOFFSET_MODULE_POWER_MODE_WUT_TIMEOUT_far");
      case "sucAwarenessPushNeeded":
      case "lastNodeIdLR":
      case "maxNodeIdLR":
      case "reservedIdLR":
      case "primaryLongRangeChannelId":
      case "dcdcConfig":
      case "lrNodeIds":
      case "includedInsecurely":
      case "includedSecurelyInsecureCCs":
      case "includedSecurelySecureCCs":
      case "rfRegion":
      case "txPower":
      case "measured0dBm":
      case "enablePTI":
      case "maxTXPower":
      case "nodeIdType":
      case "isListening":
      case "optionalFunctionality":
      case "genericDeviceClass":
      case "specificDeviceClass":
        return;
      default:
        (0, import_helpers.assertNever)(property.type);
    }
  }
  async getNodeNVMProperty(property) {
    switch (property.type) {
      case "info": {
        const nodeId = property.nodeId;
        const nodeInfo = await this.getSingle("EX_NVM_NODE_TABLE_START_far", nodeId - 1);
        const sucUpdateIndex = await this.getSingle("EX_NVM_SUC_CONTROLLER_LIST_START_far", nodeId - 1) ?? 255;
        const neighbors = await this.getSingle("EX_NVM_ROUTING_TABLE_START_far", nodeId - 1) ?? [];
        if (!nodeInfo)
          return;
        return {
          nodeId,
          ...nodeInfo,
          neighbors,
          sucUpdateIndex
        };
      }
      case "routes": {
        const lwr = await this.getSingle("EX_NVM_ROUTECACHE_START_far", property.nodeId - 1);
        const nlwr = await this.getSingle("EX_NVM_ROUTECACHE_NLWR_SR_START_far", property.nodeId - 1);
        return { lwr, nlwr };
      }
    }
  }
  setOnly(property, value) {
    return this._nvm.set(property, [value]);
  }
  setSingle(property, index, value) {
    return this._nvm.setSingle(property, index, value);
  }
  setAll(property, value) {
    return this._nvm.set(property, value);
  }
  set(property, value) {
    if (property.domain === "controller") {
      return this.setControllerNVMProperty(property, value);
    } else if (property.domain === "lrnode") {
      throw new import_core.ZWaveError(`500 series NVM has no support for Long Range node information`, import_core.ZWaveErrorCodes.NVM_ObjectNotFound);
    } else {
      return this.setNodeNVMProperty(property, value);
    }
  }
  async setControllerNVMProperty(property, value) {
    switch (property.type) {
      case "protocolVersion":
      case "applicationVersion":
        return;
      case "protocolFileFormat":
      case "applicationFileFormat":
        return;
      case "applicationData":
        return this.setOnly("EEOFFSET_HOST_OFFSET_START_far", value ?? new import_shared.Bytes(import_shared2.NVM_SERIALAPI_HOST_SIZE).fill(255));
      case "applicationName":
        return;
      case "homeId": {
        const homeId = value.readUInt32BE(0);
        return this.setOnly("EX_NVM_HOME_ID_far", homeId);
      }
      case "learnedHomeId": {
        const learnedHomeId = value?.readUInt32BE(0) ?? 0;
        return this.setOnly("NVM_HOMEID_far", learnedHomeId);
      }
      case "nodeId":
        return this.setOnly("NVM_NODEID_far", value);
      case "lastNodeId":
        return this.setOnly("EX_NVM_LAST_USED_NODE_ID_START_far", value);
      case "staticControllerNodeId":
        return this.setOnly("EX_NVM_STATIC_CONTROLLER_NODE_ID_START_far", value);
      case "sucLastIndex":
        return this.setOnly("EX_NVM_SUC_LAST_INDEX_START_far", value);
      case "controllerConfiguration":
        return this.setOnly("EX_NVM_CONTROLLER_CONFIGURATION_far", value);
      case "maxNodeId":
        return this.setOnly("EX_NVM_MAX_NODE_ID_far", value);
      case "reservedId":
        return this.setOnly("EX_NVM_RESERVED_ID_far", value);
      case "systemState":
        return this.setOnly("NVM_SYSTEM_STATE", value);
      case "commandClasses": {
        await this.setOnly("EEOFFSET_CMDCLASS_LEN_far", value.length);
        const CCs = Array.from({ length: import_shared2.APPL_NODEPARM_MAX }).fill(255);
        for (let i = 0; i < value.length; i++) {
          if (i < import_shared2.APPL_NODEPARM_MAX) {
            CCs[i] = value[i];
          }
        }
        await this.setAll("EEOFFSET_CMDCLASS_far", CCs);
        return;
      }
      case "preferredRepeaters":
        return this.setOnly("NVM_PREFERRED_REPEATERS_far", value);
      case "appRouteLock": {
        return this.setOnly("EX_NVM_ROUTECACHE_APP_LOCK_far", value);
      }
      case "routeSlaveSUC": {
        return this.setOnly("EX_NVM_SUC_ROUTING_SLAVE_LIST_START_far", value);
      }
      case "sucPendingUpdate": {
        return this.setOnly("EX_NVM_PENDING_UPDATE_far", value);
      }
      case "pendingDiscovery": {
        return this.setOnly("NVM_PENDING_DISCOVERY_far", value);
      }
      case "nodeIds":
        return;
      case "virtualNodeIds": {
        return this.setOnly("EX_NVM_BRIDGE_NODEPOOL_START_far", value);
      }
      case "sucUpdateEntries": {
        const entries = value;
        const sucUpdateEntries = Array.from({
          length: import_consts.SUC_MAX_UPDATES
        }).fill(void 0);
        for (let i = 0; i < entries.length; i++) {
          if (i < import_consts.SUC_MAX_UPDATES) {
            sucUpdateEntries[i] = entries[i];
          }
        }
        return this.setAll("EX_NVM_SUC_NODE_LIST_START_far", sucUpdateEntries);
      }
      case "watchdogStarted":
        return this.setOnly("EEOFFSET_WATCHDOG_STARTED_far", value);
      case "powerLevelNormal":
        return this.setAll("EEOFFSET_POWERLEVEL_NORMAL_far", value);
      case "powerLevelLow":
        return this.setAll("EEOFFSET_POWERLEVEL_LOW_far", value);
      case "powerMode":
        return this.setOnly("EEOFFSET_MODULE_POWER_MODE_far", value);
      case "powerModeExtintEnable":
        return this.setOnly("EEOFFSET_MODULE_POWER_MODE_EXTINT_ENABLE_far", value);
      case "powerModeWutTimeout":
        return this.setOnly("EEOFFSET_MODULE_POWER_MODE_WUT_TIMEOUT_far", value);
      case "sucAwarenessPushNeeded":
      case "lastNodeIdLR":
      case "maxNodeIdLR":
      case "reservedIdLR":
      case "primaryLongRangeChannelId":
      case "dcdcConfig":
      case "lrNodeIds":
      case "includedInsecurely":
      case "includedSecurelyInsecureCCs":
      case "includedSecurelySecureCCs":
      case "rfRegion":
      case "txPower":
      case "measured0dBm":
      case "enablePTI":
      case "maxTXPower":
      case "nodeIdType":
      case "isListening":
      case "optionalFunctionality":
      case "genericDeviceClass":
      case "specificDeviceClass":
        return;
      default:
        (0, import_helpers.assertNever)(property.type);
    }
  }
  async setNodeNVMProperty(property, value) {
    switch (property.type) {
      case "info": {
        const nodeId = property.nodeId;
        const node = value;
        await this.setSingle("EX_NVM_NODE_TABLE_START_far", nodeId - 1, node ? {
          isListening: node.isListening,
          isFrequentListening: node.isFrequentListening,
          isRouting: node.isRouting,
          supportedDataRates: node.supportedDataRates,
          protocolVersion: node.protocolVersion,
          optionalFunctionality: node.optionalFunctionality,
          nodeType: node.nodeType,
          supportsSecurity: node.supportsSecurity,
          supportsBeaming: node.supportsBeaming,
          genericDeviceClass: node.genericDeviceClass,
          specificDeviceClass: node.specificDeviceClass ?? null
        } : void 0);
        await this.setSingle("EX_NVM_SUC_CONTROLLER_LIST_START_far", nodeId - 1, node?.sucUpdateIndex ?? 254);
        await this.setSingle("EX_NVM_ROUTING_TABLE_START_far", nodeId - 1, node?.neighbors);
      }
      case "routes": {
        const nodeId = property.nodeId;
        const routes = value;
        await this.setSingle("EX_NVM_ROUTECACHE_START_far", nodeId - 1, routes.lwr);
        await this.setSingle("EX_NVM_ROUTECACHE_NLWR_SR_START_far", property.nodeId - 1, routes.nlwr);
      }
    }
  }
  // eslint-disable-next-line @typescript-eslint/require-await
  async delete(_property) {
    throw new Error("Method not implemented.");
  }
  hasPendingChanges() {
    return false;
  }
  async commit() {
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  NVM500Adapter
});
//# sourceMappingURL=adapter.js.map
