import { type FLiRS, RouteProtocolDataRate } from "@zwave-js/core";
import { Bytes, type BytesView } from "@zwave-js/shared";
export declare const ROUTECACHE_SIZE: number;
export declare const EMPTY_ROUTECACHE_FILL = 255;
export declare const emptyRouteCache: Uint8Array<ArrayBuffer>;
export interface Route {
    beaming: FLiRS;
    protocolRate: RouteProtocolDataRate;
    repeaterNodeIDs?: number[];
}
export interface RouteCache {
    nodeId: number;
    lwr: Route;
    nlwr: Route;
}
export declare function parseRoute(buffer: BytesView, offset: number): Route;
export declare function encodeRoute(route: Route | undefined): Bytes;
export declare function getEmptyRoute(): Route;
//# sourceMappingURL=routeCache.d.ts.map