// NVM area sizes
export const ZWAVE_APPLICATION_NVM_SIZE = 0x3000;
export const ZWAVE_PROTOCOL_NVM_SIZE = 0xc000 - ZWAVE_APPLICATION_NVM_SIZE;
// The 800 series has a shared application/protocol NVM, which is 8 KB smaller
// than the 700 series
export const ZWAVE_SHARED_NVM_SIZE = 0xA000;
// Everything must be word-aligned
export const NVM3_WORD_SIZE = 4;
// Definitions for NVM3 pages
export const NVM3_MIN_PAGE_SIZE = 512;
export const NVM3_PAGE_HEADER_SIZE = 20;
export const NVM3_PAGE_COUNTER_SIZE = 27;
export const NVM3_PAGE_COUNTER_MASK = (1 << NVM3_PAGE_COUNTER_SIZE) - 1;
export const NVM3_PAGE_MAGIC = 0xb29a;
export const FLASH_MAX_PAGE_SIZE_700 = 2048; // not sure if this is true for all 700 series chips
export const FLASH_MAX_PAGE_SIZE_800 = 8192;
export var PageStatus;
(function (PageStatus) {
    PageStatus[PageStatus["OK"] = 4294967295] = "OK";
    PageStatus[PageStatus["OK_ErasePending"] = 4294944165] = "OK_ErasePending";
    PageStatus[PageStatus["Bad"] = 65535] = "Bad";
    PageStatus[PageStatus["Bad_ErasePending"] = 42405] = "Bad_ErasePending";
})(PageStatus || (PageStatus = {}));
export var PageWriteSize;
(function (PageWriteSize) {
    PageWriteSize[PageWriteSize["WRITE_SIZE_32"] = 0] = "WRITE_SIZE_32";
    PageWriteSize[PageWriteSize["WRITE_SIZE_16"] = 1] = "WRITE_SIZE_16";
})(PageWriteSize || (PageWriteSize = {}));
// Definitions for NVM3 objects
export const NVM3_OBJ_KEY_SHIFT = 7;
export const NVM3_OBJ_KEY_SIZE = 20;
export const NVM3_OBJ_KEY_MASK = (1 << NVM3_OBJ_KEY_SIZE) - 1;
export const NVM3_OBJ_TYPE_MASK = 0b111_1111;
export const NVM3_OBJ_LARGE_LEN_SIZE = 26;
export const NVM3_OBJ_LARGE_LEN_MASK = (1 << NVM3_OBJ_LARGE_LEN_SIZE) - 1;
export const NVM3_OBJ_FRAGTYPE_SHIFT = 27;
export const NVM3_OBJ_FRAGTYPE_MASK = 0b11;
export const NVM3_CODE_SMALL_SHIFT = 27;
export const NVM3_CODE_LARGE_SHIFT = 26;
export const NVM3_OBJ_HEADER_SIZE_SMALL = 4;
export const NVM3_OBJ_HEADER_SIZE_LARGE = 8;
export const NVM3_MAX_OBJ_SIZE_SMALL = 120;
export const NVM3_MAX_OBJ_SIZE_LARGE = 1900; // 204..4096, see nvm3.h in zw_nvm_converter
export const NVM3_COUNTER_SIZE = 204;
export var ObjectType;
(function (ObjectType) {
    ObjectType[ObjectType["DataLarge"] = 0] = "DataLarge";
    ObjectType[ObjectType["CounterLarge"] = 1] = "CounterLarge";
    ObjectType[ObjectType["CounterSmall"] = 2] = "CounterSmall";
    ObjectType[ObjectType["Deleted"] = 3] = "Deleted";
    ObjectType[ObjectType["DataSmall"] = 7] = "DataSmall";
})(ObjectType || (ObjectType = {}));
export var FragmentType;
(function (FragmentType) {
    FragmentType[FragmentType["None"] = 0] = "None";
    FragmentType[FragmentType["First"] = 1] = "First";
    FragmentType[FragmentType["Next"] = 2] = "Next";
    FragmentType[FragmentType["Last"] = 3] = "Last";
})(FragmentType || (FragmentType = {}));
//# sourceMappingURL=consts.js.map