var __esDecorate = (this && this.__esDecorate) || function (ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};
var __runInitializers = (this && this.__runInitializers) || function (thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};
import { Bytes } from "@zwave-js/shared";
import { SUC_MAX_UPDATES, SUC_UPDATE_ENTRY_SIZE } from "../../../consts.js";
import { encodeSUCUpdateEntry, parseSUCUpdateEntry, } from "../../common/sucUpdateEntry.js";
import { NVMFile, gotDeserializationOptions, nvmFileID, nvmSection, } from "./NVMFile.js";
export const SUC_UPDATES_PER_FILE_V5 = 8;
export const SUCUpdateEntriesFileIDV0 = 0x50003;
let SUCUpdateEntriesFileV0 = (() => {
    let _classDecorators = [nvmFileID(SUCUpdateEntriesFileIDV0), nvmSection("protocol")];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = NVMFile;
    var SUCUpdateEntriesFileV0 = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            SUCUpdateEntriesFileV0 = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            if (gotDeserializationOptions(options)) {
                this.updateEntries = [];
                for (let entry = 0; entry < SUC_MAX_UPDATES; entry++) {
                    const offset = entry * SUC_UPDATE_ENTRY_SIZE;
                    const updateEntry = parseSUCUpdateEntry(this.payload, offset);
                    if (updateEntry)
                        this.updateEntries.push(updateEntry);
                }
            }
            else {
                this.updateEntries = options.updateEntries;
            }
        }
        updateEntries;
        serialize() {
            this.payload = new Bytes(SUC_MAX_UPDATES * SUC_UPDATE_ENTRY_SIZE).fill(0);
            for (let i = 0; i < this.updateEntries.length; i++) {
                const offset = i * SUC_UPDATE_ENTRY_SIZE;
                const entry = this.updateEntries[i];
                this.payload.set(encodeSUCUpdateEntry(entry), offset);
            }
            return super.serialize();
        }
        // oxlint-disable-next-line typescript/explicit-module-boundary-types
        toJSON() {
            return {
                ...super.toJSON(),
                "SUC update entries": this.updateEntries,
            };
        }
    };
    return SUCUpdateEntriesFileV0 = _classThis;
})();
export { SUCUpdateEntriesFileV0 };
export const SUCUpdateEntriesFileV5IDBase = 0x54000;
export const SUCUpdateEntriesFileV5IDMax = SUCUpdateEntriesFileV5IDBase
    + SUC_MAX_UPDATES / SUC_UPDATES_PER_FILE_V5
    - 1;
export function sucUpdateIndexToSUCUpdateEntriesFileIDV5(index) {
    return (SUCUpdateEntriesFileV5IDBase
        + Math.floor(index / SUC_UPDATES_PER_FILE_V5));
}
let SUCUpdateEntriesFileV5 = (() => {
    let _classDecorators = [nvmFileID((id) => id >= SUCUpdateEntriesFileV5IDBase
            && id <= SUCUpdateEntriesFileV5IDMax), nvmSection("protocol")];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = NVMFile;
    var SUCUpdateEntriesFileV5 = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            SUCUpdateEntriesFileV5 = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            if (gotDeserializationOptions(options)) {
                this.updateEntries = [];
                for (let entry = 0; entry < SUC_UPDATES_PER_FILE_V5; entry++) {
                    const offset = entry * SUC_UPDATE_ENTRY_SIZE;
                    const updateEntry = parseSUCUpdateEntry(this.payload, offset);
                    if (updateEntry)
                        this.updateEntries.push(updateEntry);
                }
            }
            else {
                this.updateEntries = options.updateEntries;
            }
        }
        updateEntries;
        serialize() {
            this.payload = new Bytes(SUC_UPDATES_PER_FILE_V5 * SUC_UPDATE_ENTRY_SIZE).fill(0xff);
            for (let i = 0; i < this.updateEntries.length; i++) {
                const offset = i * SUC_UPDATE_ENTRY_SIZE;
                const entry = this.updateEntries[i];
                this.payload.set(encodeSUCUpdateEntry(entry), offset);
            }
            return super.serialize();
        }
        // oxlint-disable-next-line typescript/explicit-module-boundary-types
        toJSON() {
            return {
                ...super.toJSON(),
                "SUC update entries": this.updateEntries,
            };
        }
    };
    return SUCUpdateEntriesFileV5 = _classThis;
})();
export { SUCUpdateEntriesFileV5 };
//# sourceMappingURL=SUCUpdateEntriesFile.js.map