var __esDecorate = (this && this.__esDecorate) || function (ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};
var __runInitializers = (this && this.__runInitializers) || function (thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};
import { Bytes } from "@zwave-js/shared";
import { NVMFile, gotDeserializationOptions, nvmFileID, nvmSection, } from "./NVMFile.js";
export class VersionFile extends NVMFile {
    constructor(options) {
        super(options);
        if (gotDeserializationOptions(options)) {
            this.format = this.payload[3];
            this.major = this.payload[2];
            this.minor = this.payload[1];
            this.patch = this.payload[0];
        }
        else {
            this.format = options.format;
            this.major = options.major;
            this.minor = options.minor;
            this.patch = options.patch;
        }
    }
    format;
    major;
    minor;
    patch;
    serialize() {
        this.payload = Bytes.from([
            this.patch,
            this.minor,
            this.major,
            this.format,
        ]);
        return super.serialize();
    }
    // oxlint-disable-next-line typescript/explicit-module-boundary-types
    toJSON() {
        return {
            ...super.toJSON(),
            format: this.format,
            version: `${this.major}.${this.minor}.${this.patch}`,
        };
    }
}
export const ApplicationVersionFileID = 0x51000;
let ApplicationVersionFile = (() => {
    let _classDecorators = [nvmFileID(ApplicationVersionFileID), nvmSection("application")];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = VersionFile;
    var ApplicationVersionFile = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            ApplicationVersionFile = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
    };
    return ApplicationVersionFile = _classThis;
})();
export { ApplicationVersionFile };
// The 800 series has a shared application/protocol file system
// and uses a different ID for the application version file
export const ApplicationVersionFile800ID = 0x41000;
let ApplicationVersionFile800 = (() => {
    let _classDecorators = [nvmFileID(ApplicationVersionFile800ID), nvmSection("application")];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = VersionFile;
    var ApplicationVersionFile800 = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            ApplicationVersionFile800 = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
    };
    return ApplicationVersionFile800 = _classThis;
})();
export { ApplicationVersionFile800 };
export const ProtocolVersionFileID = 0x50000;
let ProtocolVersionFile = (() => {
    let _classDecorators = [nvmFileID(ProtocolVersionFileID), nvmSection("protocol")];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = VersionFile;
    var ProtocolVersionFile = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            ProtocolVersionFile = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
    };
    return ProtocolVersionFile = _classThis;
})();
export { ProtocolVersionFile };
//# sourceMappingURL=VersionFiles.js.map