import { NUM_NODEMASK_BYTES } from "@zwave-js/core";
import { SUC_UPDATE_ENTRY_SIZE } from "../../consts.js";
export var NVMEntryType;
(function (NVMEntryType) {
    NVMEntryType[NVMEntryType["NVMModuleSize"] = 0] = "NVMModuleSize";
    NVMEntryType[NVMEntryType["Byte"] = 1] = "Byte";
    NVMEntryType[NVMEntryType["Word"] = 2] = "Word";
    NVMEntryType[NVMEntryType["DWord"] = 3] = "DWord";
    NVMEntryType[NVMEntryType["Buffer"] = 4] = "Buffer";
    NVMEntryType[NVMEntryType["NodeInfo"] = 5] = "NodeInfo";
    NVMEntryType[NVMEntryType["NodeMask"] = 6] = "NodeMask";
    NVMEntryType[NVMEntryType["SUCUpdateEntry"] = 7] = "SUCUpdateEntry";
    NVMEntryType[NVMEntryType["Route"] = 8] = "Route";
    NVMEntryType[NVMEntryType["NVMModuleDescriptor"] = 9] = "NVMModuleDescriptor";
    NVMEntryType[NVMEntryType["NVMDescriptor"] = 10] = "NVMDescriptor";
})(NVMEntryType || (NVMEntryType = {}));
export const NVMEntrySizes = {
    [NVMEntryType.NVMModuleSize]: 2, // Marks the start of an NVM module
    [NVMEntryType.Byte]: 1,
    [NVMEntryType.Word]: 2,
    [NVMEntryType.DWord]: 4,
    [NVMEntryType.Buffer]: 1, // The size must be specified
    [NVMEntryType.NodeInfo]: 5, // 3 bytes NodeProtocolInfo + generic + specific device class
    [NVMEntryType.NodeMask]: NUM_NODEMASK_BYTES, // Nodes bitmask
    [NVMEntryType.SUCUpdateEntry]: SUC_UPDATE_ENTRY_SIZE,
    [NVMEntryType.Route]: 5, // a Route
    [NVMEntryType.NVMModuleDescriptor]: 5, // 2 bytes module size, 1 byte module type, 2 bytes module version
    [NVMEntryType.NVMDescriptor]: 12,
};
export var NVMModuleType;
(function (NVMModuleType) {
    NVMModuleType[NVMModuleType["UNDEFINED"] = 0] = "UNDEFINED";
    NVMModuleType[NVMModuleType["ZW_PHY_LIBRARY"] = 1] = "ZW_PHY_LIBRARY";
    NVMModuleType[NVMModuleType["ZW_LIBRARY"] = 2] = "ZW_LIBRARY";
    NVMModuleType[NVMModuleType["ZW_FRAMEWORK"] = 3] = "ZW_FRAMEWORK";
    NVMModuleType[NVMModuleType["APPLICATION"] = 4] = "APPLICATION";
    NVMModuleType[NVMModuleType["HOST_APPLICATION"] = 5] = "HOST_APPLICATION";
    NVMModuleType[NVMModuleType["SECURITY_2"] = 6] = "SECURITY_2";
    NVMModuleType[NVMModuleType["NVM_DESCRIPTOR"] = 255] = "NVM_DESCRIPTOR";
})(NVMModuleType || (NVMModuleType = {}));
export const SUC_CONTROLLER_LIST_SIZE = 232;
export const MAX_REPEATERS = 4;
/* NVM is 16KB, 32KB or even more (you decide the size of your SPI EEPROM or FLASH chip) */
/* Use only a reasonable amount of it for host application */
export const NVM_SERIALAPI_HOST_SIZE = 2048;
export const POWERLEVEL_CHANNELS = 3;
export const APPL_NODEPARM_MAX = 35;
export const RTC_TIMER_SIZE = 16;
export const TOTAL_RTC_TIMER_MAX = 8 + 2; /* max number of active RTC timers */
export const CONFIGURATION_VALID_0 = 0x54;
export const CONFIGURATION_VALID_1 = 0xa5;
export const ROUTECACHE_VALID = 0x4a;
export const MAGIC_VALUE = 0x42;
export function resolveLayout(layout) {
    const ret = new Map();
    let offset = 0;
    for (const entry of layout) {
        const size = entry.size ?? NVMEntrySizes[entry.type];
        const resolvedEntry = {
            ...entry,
            size,
            offset: entry.offset ?? offset,
        };
        ret.set(resolvedEntry.name, resolvedEntry);
        offset += size * entry.count;
    }
    const endMarker = ret.get("nvmModuleSizeEndMarker");
    const nvmSize = endMarker.offset + endMarker.size;
    return { layout: ret, nvmSize };
}
//# sourceMappingURL=shared.js.map