"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var ProtobufHelpers_exports = {};
__export(ProtobufHelpers_exports, {
  decodeFixed32Field: () => decodeFixed32Field,
  decodeLengthDelimitedField: () => decodeLengthDelimitedField,
  decodeSignedVarint: () => decodeSignedVarint,
  decodeStringField: () => decodeStringField,
  decodeTag: () => decodeTag,
  decodeVarInt: () => decodeVarInt,
  encodeBoolField: () => encodeBoolField,
  encodeFixed32Field: () => encodeFixed32Field,
  encodeLengthDelimitedField: () => encodeLengthDelimitedField,
  encodeSignedVarint: () => encodeSignedVarint,
  encodeSignedVarintField: () => encodeSignedVarintField,
  encodeStringField: () => encodeStringField,
  encodeTag: () => encodeTag,
  encodeVarInt: () => encodeVarInt,
  encodeVarintField: () => encodeVarintField,
  parseProtobufMessage: () => parseProtobufMessage,
  skipField: () => skipField
});
module.exports = __toCommonJS(ProtobufHelpers_exports);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
function encodeTag(fieldNumber, wireType) {
  return encodeVarInt(fieldNumber << 3 | wireType);
}
__name(encodeTag, "encodeTag");
function decodeTag(data, offset = 0) {
  const tag = decodeVarInt(data, offset);
  const fieldNumber = tag.value >>> 3;
  const wireType = tag.value & 7;
  return {
    fieldNumber,
    wireType,
    bytesRead: tag.bytesRead
  };
}
__name(decodeTag, "decodeTag");
function encodeVarInt(value) {
  const bytes = [];
  while (value >= 128) {
    bytes.push(value & 127 | 128);
    value >>>= 7;
  }
  bytes.push(value & 127);
  return new Uint8Array(bytes);
}
__name(encodeVarInt, "encodeVarInt");
function decodeVarInt(data, offset = 0) {
  let value = 0;
  let shift = 0;
  let bytesRead = 0;
  while (offset + bytesRead < data.length) {
    const byte = data[offset + bytesRead];
    bytesRead++;
    value |= (byte & 127) << shift;
    if ((byte & 128) === 0) {
      return { value, bytesRead };
    }
    shift += 7;
    if (shift >= 35) {
      throw new import_core.ZWaveError("VarInt too long", import_core.ZWaveErrorCodes.Argument_Invalid);
    }
  }
  throw new import_core.ZWaveError("Incomplete VarInt", import_core.ZWaveErrorCodes.Argument_Invalid);
}
__name(decodeVarInt, "decodeVarInt");
function encodeStringField(fieldNumber, value) {
  const stringBytes = typeof value === "string" ? new TextEncoder().encode(value) : value;
  const tag = encodeTag(
    fieldNumber,
    2
    /* WireType.LengthDelimited */
  );
  const length = encodeVarInt(stringBytes.length);
  return import_shared.Bytes.concat([tag, length, stringBytes]);
}
__name(encodeStringField, "encodeStringField");
function decodeStringField(data, offset) {
  const length = decodeVarInt(data, offset);
  const stringBytes = data.slice(offset + length.bytesRead, offset + length.bytesRead + length.value);
  return {
    value: new TextDecoder().decode(stringBytes),
    bytesRead: length.bytesRead + length.value
  };
}
__name(decodeStringField, "decodeStringField");
function encodeVarintField(fieldNumber, value) {
  const tag = encodeTag(
    fieldNumber,
    0
    /* WireType.Varint */
  );
  const varint = encodeVarInt(value);
  return import_shared.Bytes.concat([tag, varint]);
}
__name(encodeVarintField, "encodeVarintField");
function encodeBoolField(fieldNumber, value) {
  return encodeVarintField(fieldNumber, value ? 1 : 0);
}
__name(encodeBoolField, "encodeBoolField");
function encodeFixed32Field(fieldNumber, value) {
  const tag = encodeTag(
    fieldNumber,
    5
    /* WireType.Fixed32 */
  );
  const valueBytes = new Uint8Array(4);
  valueBytes[0] = value & 255;
  valueBytes[1] = value >>> 8 & 255;
  valueBytes[2] = value >>> 16 & 255;
  valueBytes[3] = value >>> 24 & 255;
  return import_shared.Bytes.concat([tag, valueBytes]);
}
__name(encodeFixed32Field, "encodeFixed32Field");
function decodeFixed32Field(data, offset) {
  const value = import_shared.Bytes.view(data).readUInt32LE(offset);
  return { value, bytesRead: 4 };
}
__name(decodeFixed32Field, "decodeFixed32Field");
function encodeLengthDelimitedField(fieldNumber, value) {
  const tag = encodeTag(
    fieldNumber,
    2
    /* WireType.LengthDelimited */
  );
  const length = encodeVarInt(value.length);
  return import_shared.Bytes.concat([tag, length, value]);
}
__name(encodeLengthDelimitedField, "encodeLengthDelimitedField");
function decodeLengthDelimitedField(data, offset) {
  const length = decodeVarInt(data, offset);
  const valueBytes = data.slice(offset + length.bytesRead, offset + length.bytesRead + length.value);
  return {
    value: valueBytes,
    bytesRead: length.bytesRead + length.value
  };
}
__name(decodeLengthDelimitedField, "decodeLengthDelimitedField");
function encodeSignedVarint(value) {
  const zigzag = value << 1 ^ value >> 31;
  return encodeVarInt(zigzag);
}
__name(encodeSignedVarint, "encodeSignedVarint");
function decodeSignedVarint(data, offset = 0) {
  const decoded = decodeVarInt(data, offset);
  const value = decoded.value >>> 1 ^ -(decoded.value & 1);
  return { value, bytesRead: decoded.bytesRead };
}
__name(decodeSignedVarint, "decodeSignedVarint");
function encodeSignedVarintField(fieldNumber, value) {
  const tag = encodeTag(
    fieldNumber,
    0
    /* WireType.Varint */
  );
  const varint = encodeSignedVarint(value);
  return import_shared.Bytes.concat([tag, varint]);
}
__name(encodeSignedVarintField, "encodeSignedVarintField");
function skipField(data, offset, wireType) {
  switch (wireType) {
    case 0:
      const varint = decodeVarInt(data, offset);
      return offset + varint.bytesRead;
    case 1:
      return offset + 8;
    case 2:
      const length = decodeVarInt(data, offset);
      return offset + length.bytesRead + length.value;
    case 5:
      return offset + 4;
    default:
      throw new import_core.ZWaveError(`Unsupported wire type: ${wireType}`, import_core.ZWaveErrorCodes.Argument_Invalid);
  }
}
__name(skipField, "skipField");
function parseProtobufMessage(data, fieldHandler) {
  let pos = 0;
  while (pos < data.length) {
    const tag = decodeTag(data, pos);
    pos += tag.bytesRead;
    pos = fieldHandler(tag.fieldNumber, tag.wireType, data, pos);
  }
}
__name(parseProtobufMessage, "parseProtobufMessage");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  decodeFixed32Field,
  decodeLengthDelimitedField,
  decodeSignedVarint,
  decodeStringField,
  decodeTag,
  decodeVarInt,
  encodeBoolField,
  encodeFixed32Field,
  encodeLengthDelimitedField,
  encodeSignedVarint,
  encodeSignedVarintField,
  encodeStringField,
  encodeTag,
  encodeVarInt,
  encodeVarintField,
  parseProtobufMessage,
  skipField
});
//# sourceMappingURL=ProtobufHelpers.js.map
