"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var MockPort_exports = {};
__export(MockPort_exports, {
  MockPort: () => MockPort,
  createAndOpenMockedZWaveSerialPort: () => createAndOpenMockedZWaveSerialPort
});
module.exports = __toCommonJS(MockPort_exports);
var import_async = require("alcalzone-shared/async");
var import_ZWaveSerialStream = require("../serialport/ZWaveSerialStream.js");
class MockPort {
  static {
    __name(this, "MockPort");
  }
  constructor() {
    const { readable, writable: sink } = new TransformStream();
    this.#sink = sink;
    this.readable = readable;
  }
  /** How long each write operation should take */
  writeDelay = 0;
  // Remembers the last written data
  lastWrite;
  // Internal stream to allow emitting data from the port
  #sourceController;
  // Public readable stream to allow handling the written data
  #sink;
  /** Exposes the data written by the host as a readable stream */
  readable;
  factory() {
    return () => {
      let writer;
      const sink = {
        write: /* @__PURE__ */ __name(async (chunk, _controller) => {
          this.lastWrite = chunk;
          if (this.readable.locked) {
            writer ??= this.#sink.getWriter();
            if (this.writeDelay > 0) {
              await (0, import_async.wait)(this.writeDelay);
            }
            await writer.write(chunk);
          }
        }, "write"),
        close: /* @__PURE__ */ __name(() => {
          writer?.releaseLock();
        }, "close")
      };
      const source = {
        start: /* @__PURE__ */ __name((controller) => {
          this.#sourceController = controller;
        }, "start")
      };
      return Promise.resolve({ sink, source });
    };
  }
  emitData(data) {
    this.#sourceController?.enqueue(data);
  }
  destroy() {
    try {
      this.#sourceController?.close();
      this.#sourceController = void 0;
    } catch {
    }
  }
}
async function createAndOpenMockedZWaveSerialPort() {
  const port = new MockPort();
  const factory = new import_ZWaveSerialStream.ZWaveSerialStreamFactory(port.factory(), (await import("#default_bindings/log")).log({
    enabled: false
  }));
  const serial = await factory.createStream();
  return { port, serial };
}
__name(createAndOpenMockedZWaveSerialPort, "createAndOpenMockedZWaveSerialPort");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  MockPort,
  createAndOpenMockedZWaveSerialPort
});
//# sourceMappingURL=MockPort.js.map
