import type { Bytes, BytesView } from "@zwave-js/shared";
import type { MessageHeaders, XModemMessageHeaders } from "../message/MessageHeaders.js";
export declare enum ZWaveSerialFrameType {
    SerialAPI = 0,
    Bootloader = 1,
    CLI = 2,
    Discarded = 255
}
export type ZWaveSerialFrame = {
    type: ZWaveSerialFrameType.SerialAPI;
    data: SerialAPIChunk;
} | {
    type: ZWaveSerialFrameType.Bootloader;
    data: BootloaderChunk;
} | {
    type: ZWaveSerialFrameType.CLI;
    data: CLIChunk;
} | {
    type: ZWaveSerialFrameType.Discarded;
    data: BytesView;
};
export type SerialAPIChunk = Bytes | MessageHeaders.ACK | MessageHeaders.NAK | MessageHeaders.CAN;
export declare enum BootloaderChunkType {
    Error = 0,
    Menu = 1,
    Message = 2,
    FlowControl = 3
}
export type BootloaderChunk = {
    type: BootloaderChunkType.Error;
    error: string;
    _raw: string;
} | {
    type: BootloaderChunkType.Menu;
    version: string;
    options: {
        num: number;
        option: string;
    }[];
    _raw: string;
} | {
    type: BootloaderChunkType.Message;
    message: string;
    _raw: string;
} | {
    type: BootloaderChunkType.FlowControl;
    command: XModemMessageHeaders.ACK | XModemMessageHeaders.NAK | XModemMessageHeaders.CAN | XModemMessageHeaders.C;
};
export declare enum CLIChunkType {
    Prompt = 0,// >
    Message = 1,
    FlowControl = 2
}
export type CLIChunk = {
    type: CLIChunkType.Prompt;
} | {
    type: CLIChunkType.Message;
    message: string;
} | {
    type: CLIChunkType.FlowControl;
    command: XModemMessageHeaders.ACK | XModemMessageHeaders.NAK | XModemMessageHeaders.CAN | XModemMessageHeaders.C;
};
//# sourceMappingURL=ZWaveSerialFrame.d.ts.map