"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var ZWaveSerialParser_exports = {};
__export(ZWaveSerialParser_exports, {
  ZWaveSerialParser: () => ZWaveSerialParser
});
module.exports = __toCommonJS(ZWaveSerialParser_exports);
var import_shared = require("@zwave-js/shared");
var import_BootloaderParsers = require("../parsers/BootloaderParsers.js");
var import_CLIParser = require("../parsers/CLIParser.js");
var import_SerialAPIParser = require("../parsers/SerialAPIParser.js");
var import_Merge = require("./Merge.js");
var import_SerialModeSwitch = require("./SerialModeSwitch.js");
class ZWaveSerialParser {
  static {
    __name(this, "ZWaveSerialParser");
  }
  constructor(logger, signal) {
    this.parser = new import_SerialAPIParser.SerialAPIParser(logger);
    const cliParser = new import_CLIParser.CLIParser(logger);
    const bootloaderScreenParser = new import_BootloaderParsers.BootloaderScreenParser(logger);
    const bootloaderParser = new import_BootloaderParsers.BootloaderParser();
    this.modeSwitch = new import_SerialModeSwitch.SerialModeSwitch();
    this.modeSwitch.toSerialAPI.pipeTo(this.parser.writable, { signal }).catch(import_shared.noop);
    this.modeSwitch.toCLI.pipeTo(cliParser.writable, { signal }).catch(import_shared.noop);
    this.modeSwitch.toBootloader.pipeThrough(bootloaderScreenParser, { signal }).pipeTo(bootloaderParser.writable, { signal }).catch(import_shared.noop);
    this.readable = (0, import_Merge.mergeReadableStreams)(this.parser.readable, cliParser.readable, bootloaderParser.readable);
  }
  // Public interface to let consumers read from and write to this stream
  readable;
  get writable() {
    return this.modeSwitch;
  }
  parser;
  // Allow switching between modes
  modeSwitch;
  get mode() {
    return this.modeSwitch.mode;
  }
  set mode(mode) {
    this.modeSwitch.mode = mode;
  }
  // Allow ignoring the high nibble of an ACK once to work around an issue in the 700 series firmware
  ignoreAckHighNibbleOnce() {
    this.parser.ignoreAckHighNibble = true;
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ZWaveSerialParser
});
//# sourceMappingURL=ZWaveSerialParser.js.map
