"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var ApplicationCommandRequest_exports = {};
__export(ApplicationCommandRequest_exports, {
  ApplicationCommandRequest: () => ApplicationCommandRequest,
  ApplicationCommandStatusFlags: () => ApplicationCommandStatusFlags
});
module.exports = __toCommonJS(ApplicationCommandRequest_exports);
var import_core = require("@zwave-js/core");
var import_serial = require("@zwave-js/serial");
var import_shared = require("@zwave-js/shared");
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
var ApplicationCommandStatusFlags;
(function(ApplicationCommandStatusFlags2) {
  ApplicationCommandStatusFlags2[ApplicationCommandStatusFlags2["RoutedBusy"] = 1] = "RoutedBusy";
  ApplicationCommandStatusFlags2[ApplicationCommandStatusFlags2["LowPower"] = 2] = "LowPower";
  ApplicationCommandStatusFlags2[ApplicationCommandStatusFlags2["TypeSingle"] = 0] = "TypeSingle";
  ApplicationCommandStatusFlags2[ApplicationCommandStatusFlags2["TypeBroad"] = 4] = "TypeBroad";
  ApplicationCommandStatusFlags2[ApplicationCommandStatusFlags2["TypeMulti"] = 8] = "TypeMulti";
  ApplicationCommandStatusFlags2[ApplicationCommandStatusFlags2["TypeMask"] = 12] = "TypeMask";
  ApplicationCommandStatusFlags2[ApplicationCommandStatusFlags2["Explore"] = 16] = "Explore";
  ApplicationCommandStatusFlags2[ApplicationCommandStatusFlags2["ForeignFrame"] = 64] = "ForeignFrame";
  ApplicationCommandStatusFlags2[ApplicationCommandStatusFlags2["ForeignHomeId"] = 128] = "ForeignHomeId";
})(ApplicationCommandStatusFlags || (ApplicationCommandStatusFlags = {}));
let ApplicationCommandRequest = (() => {
  let _classDecorators = [(0, import_serial.messageTypes)(import_serial.MessageType.Request, import_serial.FunctionType.ApplicationCommand), (0, import_serial.priority)(import_core.MessagePriority.Normal)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_serial.Message;
  var ApplicationCommandRequest2 = class extends _classSuper {
    static {
      __name(this, "ApplicationCommandRequest");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ApplicationCommandRequest2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      if ("command" in options) {
        this.command = options.command;
      } else {
        this._nodeId = options.nodeId;
        this.serializedCC = options.serializedCC;
      }
      this.frameType = options.frameType ?? "singlecast";
      this.routedBusy = options.routedBusy ?? false;
      this.isExploreFrame = options.isExploreFrame ?? false;
      this.isForeignFrame = options.isForeignFrame ?? false;
      this.fromForeignHomeId = options.fromForeignHomeId ?? false;
    }
    static from(raw, ctx) {
      const status = raw.payload[0];
      const routedBusy = !!(status & ApplicationCommandStatusFlags.RoutedBusy);
      let frameType;
      switch (status & ApplicationCommandStatusFlags.TypeMask) {
        case ApplicationCommandStatusFlags.TypeMulti:
          frameType = "multicast";
          break;
        case ApplicationCommandStatusFlags.TypeBroad:
          frameType = "broadcast";
          break;
        default:
          frameType = "singlecast";
      }
      const isExploreFrame = frameType === "broadcast" && !!(status & ApplicationCommandStatusFlags.Explore);
      const isForeignFrame = !!(status & ApplicationCommandStatusFlags.ForeignFrame);
      const fromForeignHomeId = !!(status & ApplicationCommandStatusFlags.ForeignHomeId);
      let offset = 1;
      const { nodeId, bytesRead: nodeIdBytes } = (0, import_core.parseNodeID)(raw.payload, ctx.nodeIdType, offset);
      offset += nodeIdBytes;
      const commandLength = raw.payload[offset++];
      const serializedCC = raw.payload.subarray(offset, offset + commandLength);
      return new this({
        routedBusy,
        frameType,
        isExploreFrame,
        isForeignFrame,
        fromForeignHomeId,
        serializedCC,
        nodeId
      });
    }
    routedBusy;
    frameType;
    isExploreFrame;
    isForeignFrame;
    fromForeignHomeId;
    // This needs to be writable or unwrapping MultiChannelCCs crashes
    command;
    _nodeId;
    getNodeId() {
      if (this.command?.isSinglecast()) {
        return this.command.nodeId;
      }
      return this._nodeId ?? super.getNodeId();
    }
    serializedCC;
    async serializeCC(ctx) {
      if (!this.serializedCC) {
        if (!this.command) {
          throw new import_core.ZWaveError(`Cannot serialize a ${this.constructor.name} without a command`, import_core.ZWaveErrorCodes.Argument_Invalid);
        }
        this.serializedCC = await this.command.serialize(ctx);
      }
      return this.serializedCC;
    }
    async serialize(ctx) {
      const statusByte = (this.frameType === "broadcast" ? ApplicationCommandStatusFlags.TypeBroad : this.frameType === "multicast" ? ApplicationCommandStatusFlags.TypeMulti : 0) | (this.routedBusy ? ApplicationCommandStatusFlags.RoutedBusy : 0);
      const serializedCC = await this.serializeCC(ctx);
      const nodeId = (0, import_core.encodeNodeID)(this.getNodeId() ?? ctx.ownNodeId, ctx.nodeIdType);
      this.payload = import_shared.Bytes.concat([
        [statusByte],
        nodeId,
        [serializedCC.length],
        serializedCC
      ]);
      return super.serialize(ctx);
    }
    toLogEntry() {
      const message = {};
      if (this.frameType !== "singlecast") {
        message.type = this.frameType;
      }
      return {
        ...super.toLogEntry(),
        message
      };
    }
  };
  return ApplicationCommandRequest2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ApplicationCommandRequest,
  ApplicationCommandStatusFlags
});
//# sourceMappingURL=ApplicationCommandRequest.js.map
