"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var AssignPrioritySUCReturnRouteMessages_exports = {};
__export(AssignPrioritySUCReturnRouteMessages_exports, {
  AssignPrioritySUCReturnRouteRequest: () => AssignPrioritySUCReturnRouteRequest,
  AssignPrioritySUCReturnRouteRequestBase: () => AssignPrioritySUCReturnRouteRequestBase,
  AssignPrioritySUCReturnRouteRequestTransmitReport: () => AssignPrioritySUCReturnRouteRequestTransmitReport,
  AssignPrioritySUCReturnRouteResponse: () => AssignPrioritySUCReturnRouteResponse
});
module.exports = __toCommonJS(AssignPrioritySUCReturnRouteMessages_exports);
var import_core = require("@zwave-js/core");
var import_serial = require("@zwave-js/serial");
var import_shared = require("@zwave-js/shared");
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
let AssignPrioritySUCReturnRouteRequestBase = (() => {
  let _classDecorators = [(0, import_serial.messageTypes)(import_serial.MessageType.Request, import_serial.FunctionType.AssignPrioritySUCReturnRoute), (0, import_serial.priority)(import_core.MessagePriority.Normal)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_serial.Message;
  var AssignPrioritySUCReturnRouteRequestBase2 = class extends _classSuper {
    static {
      __name(this, "AssignPrioritySUCReturnRouteRequestBase");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      AssignPrioritySUCReturnRouteRequestBase2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    static from(raw, ctx) {
      if (ctx.origin === import_serial.MessageOrigin.Host) {
        return AssignPrioritySUCReturnRouteRequest.from(raw, ctx);
      } else {
        return AssignPrioritySUCReturnRouteRequestTransmitReport.from(raw, ctx);
      }
    }
  };
  return AssignPrioritySUCReturnRouteRequestBase2 = _classThis;
})();
let AssignPrioritySUCReturnRouteRequest = (() => {
  let _classDecorators = [(0, import_serial.expectedResponse)(import_serial.FunctionType.AssignPrioritySUCReturnRoute), (0, import_serial.expectedCallback)(import_serial.FunctionType.AssignPrioritySUCReturnRoute)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = AssignPrioritySUCReturnRouteRequestBase;
  var AssignPrioritySUCReturnRouteRequest2 = class extends _classSuper {
    static {
      __name(this, "AssignPrioritySUCReturnRouteRequest");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      AssignPrioritySUCReturnRouteRequest2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      if (options.repeaters.length > import_core.MAX_REPEATERS || options.repeaters.some((id) => id < 1 || id > import_core.MAX_NODES)) {
        throw new import_core.ZWaveError(`The repeaters array must contain at most ${import_core.MAX_REPEATERS} node IDs between 1 and ${import_core.MAX_NODES}`, import_core.ZWaveErrorCodes.Argument_Invalid);
      }
      this.nodeId = options.nodeId;
      this.repeaters = options.repeaters;
      this.routeSpeed = options.routeSpeed;
    }
    static from(_raw, _ctx) {
      throw new import_core.ZWaveError(`${this.name}: deserialization not implemented`, import_core.ZWaveErrorCodes.Deserialization_NotImplemented);
    }
    nodeId;
    repeaters;
    routeSpeed;
    serialize(ctx) {
      this.assertCallbackId();
      const nodeId = (0, import_core.encodeNodeID)(this.nodeId, ctx.nodeIdType);
      this.payload = import_shared.Bytes.concat([
        nodeId,
        import_shared.Bytes.from([
          this.repeaters[0] ?? 0,
          this.repeaters[1] ?? 0,
          this.repeaters[2] ?? 0,
          this.repeaters[3] ?? 0,
          this.routeSpeed,
          this.callbackId
        ])
      ]);
      return super.serialize(ctx);
    }
    toLogEntry() {
      return {
        ...super.toLogEntry(),
        message: {
          "node ID": this.nodeId,
          repeaters: this.repeaters.length > 0 ? this.repeaters.join(" -> ") : "none",
          "route speed": (0, import_shared.getEnumMemberName)(import_core.ZWaveDataRate, this.routeSpeed),
          "callback id": this.callbackId ?? "(not set)"
        }
      };
    }
  };
  return AssignPrioritySUCReturnRouteRequest2 = _classThis;
})();
let AssignPrioritySUCReturnRouteResponse = (() => {
  let _classDecorators = [(0, import_serial.messageTypes)(import_serial.MessageType.Response, import_serial.FunctionType.AssignPrioritySUCReturnRoute)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_serial.Message;
  var AssignPrioritySUCReturnRouteResponse2 = class extends _classSuper {
    static {
      __name(this, "AssignPrioritySUCReturnRouteResponse");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      AssignPrioritySUCReturnRouteResponse2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.hasStarted = options.hasStarted;
    }
    static from(raw, _ctx) {
      const hasStarted = raw.payload[0] !== 0;
      return new this({
        hasStarted
      });
    }
    isOK() {
      return this.hasStarted;
    }
    hasStarted;
    toLogEntry() {
      return {
        ...super.toLogEntry(),
        message: { "has started": this.hasStarted }
      };
    }
  };
  return AssignPrioritySUCReturnRouteResponse2 = _classThis;
})();
class AssignPrioritySUCReturnRouteRequestTransmitReport extends AssignPrioritySUCReturnRouteRequestBase {
  static {
    __name(this, "AssignPrioritySUCReturnRouteRequestTransmitReport");
  }
  constructor(options) {
    super(options);
    this.callbackId = options.callbackId;
    this.transmitStatus = options.transmitStatus;
  }
  static from(raw, _ctx) {
    const callbackId = raw.payload[0];
    const transmitStatus = raw.payload[1];
    return new this({
      callbackId,
      transmitStatus
    });
  }
  isOK() {
    return this.transmitStatus !== import_core.TransmitStatus.NoAck;
  }
  transmitStatus;
  toLogEntry() {
    return {
      ...super.toLogEntry(),
      message: {
        "callback id": this.callbackId ?? "(not set)",
        "transmit status": (0, import_shared.getEnumMemberName)(import_core.TransmitStatus, this.transmitStatus)
      }
    };
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  AssignPrioritySUCReturnRouteRequest,
  AssignPrioritySUCReturnRouteRequestBase,
  AssignPrioritySUCReturnRouteRequestTransmitReport,
  AssignPrioritySUCReturnRouteResponse
});
//# sourceMappingURL=AssignPrioritySUCReturnRouteMessages.js.map
