import { type MessageOrCCLogEntry, TransmitOptions } from "@zwave-js/core";
import { Message, type MessageBaseOptions, type MessageEncodingContext, type MessageParsingContext, type MessageRaw, type SuccessIndicator } from "@zwave-js/serial";
import { Bytes } from "@zwave-js/shared";
export declare enum SetSUCNodeIdStatus {
    Succeeded = 5,
    Failed = 6
}
export interface SetSUCNodeIdRequestOptions {
    ownNodeId: number;
    sucNodeId: number;
    enableSUC: boolean;
    enableSIS: boolean;
    transmitOptions?: TransmitOptions;
}
export declare class SetSUCNodeIdRequestBase extends Message {
    static from(raw: MessageRaw, ctx: MessageParsingContext): SetSUCNodeIdRequestBase;
}
export declare class SetSUCNodeIdRequest extends SetSUCNodeIdRequestBase {
    constructor(options: SetSUCNodeIdRequestOptions & MessageBaseOptions);
    static from(_raw: MessageRaw, _ctx: MessageParsingContext): SetSUCNodeIdRequest;
    sucNodeId: number;
    enableSUC: boolean;
    enableSIS: boolean;
    transmitOptions: TransmitOptions;
    private _ownNodeId;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
    expectsCallback(): boolean;
}
export interface SetSUCNodeIdResponseOptions {
    wasExecuted: boolean;
}
export declare class SetSUCNodeIdResponse extends Message implements SuccessIndicator {
    constructor(options: SetSUCNodeIdResponseOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): SetSUCNodeIdResponse;
    isOK(): boolean;
    wasExecuted: boolean;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface SetSUCNodeIdRequestStatusReportOptions {
    status: SetSUCNodeIdStatus;
}
export declare class SetSUCNodeIdRequestStatusReport extends SetSUCNodeIdRequestBase implements SuccessIndicator {
    constructor(options: SetSUCNodeIdRequestStatusReportOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): SetSUCNodeIdRequestStatusReport;
    status: SetSUCNodeIdStatus;
    isOK(): boolean;
}
//# sourceMappingURL=SetSUCNodeIDMessages.d.ts.map