"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var ESPHomeSocket_exports = {};
__export(ESPHomeSocket_exports, {
  createESPHomeFactory: () => createESPHomeFactory
});
module.exports = __toCommonJS(ESPHomeSocket_exports);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_node_net = __toESM(require("node:net"), 1);
var import_ConnectionMessages = require("../esphome/ConnectionMessages.js");
var import_DeviceInfoMessages = require("../esphome/DeviceInfoMessages.js");
var import_ESPHomeMessage = require("../esphome/ESPHomeMessage.js");
var import_HelloMessages = require("../esphome/HelloMessages.js");
var import_ZWaveProxyMessages = require("../esphome/ZWaveProxyMessages.js");
var ConnectionState;
(function(ConnectionState2) {
  ConnectionState2["Disconnected"] = "disconnected";
  ConnectionState2["Connecting"] = "connecting";
  ConnectionState2["HelloSent"] = "hello_sent";
  ConnectionState2["HelloReceived"] = "hello_received";
  ConnectionState2["DeviceInfoSent"] = "device_info_sent";
  ConnectionState2["DeviceInfoReceived"] = "device_info_received";
  ConnectionState2["Ready"] = "ready";
})(ConnectionState || (ConnectionState = {}));
function createESPHomeFactory(options) {
  return async function() {
    const socket = new import_node_net.default.Socket();
    const host = options.host;
    const port = options.port ?? 6053;
    const timeout = 5e3;
    let connectionState = ConnectionState.Disconnected;
    let deviceInfo;
    let sourceController;
    let frameBuffer = new import_shared.Bytes();
    function removeListeners() {
      socket.removeAllListeners("close");
      socket.removeAllListeners("error");
      socket.removeAllListeners("connect");
      socket.removeAllListeners("timeout");
      socket.removeAllListeners("data");
    }
    __name(removeListeners, "removeListeners");
    function sendMessage(message) {
      const frame = message.serialize();
      return new Promise((resolve, reject) => {
        socket.write(frame, (err) => {
          if (err)
            reject(err);
          else
            resolve();
        });
      });
    }
    __name(sendMessage, "sendMessage");
    async function performHandshake() {
      connectionState = ConnectionState.HelloSent;
      const helloRequest = new import_HelloMessages.HelloRequest({
        clientInfo: "zwave-js",
        apiVersionMajor: 1,
        apiVersionMinor: 0
      });
      await sendMessage(helloRequest);
      await waitForState(ConnectionState.HelloReceived, timeout);
      connectionState = ConnectionState.DeviceInfoSent;
      const deviceInfoRequest = new import_DeviceInfoMessages.DeviceInfoRequest();
      await sendMessage(deviceInfoRequest);
      await waitForState(ConnectionState.DeviceInfoReceived, timeout);
      if (!deviceInfo?.hasZWaveProxySupport) {
        throw new import_core.ZWaveError("ESPHome device does not support Z-Wave proxy functionality", import_core.ZWaveErrorCodes.Driver_SerialPortClosed);
      }
      const subscribeRequest = new import_ZWaveProxyMessages.ZWaveProxyRequest({
        type: import_ZWaveProxyMessages.ESPHomeZWaveProxyRequestType.Subscribe
      });
      await sendMessage(subscribeRequest);
      connectionState = ConnectionState.Ready;
    }
    __name(performHandshake, "performHandshake");
    function waitForState(targetState, timeoutMs) {
      return new Promise((resolve, reject) => {
        if (connectionState === targetState) {
          resolve();
          return;
        }
        const startTime = Date.now();
        const checkInterval = setInterval(() => {
          if (connectionState === targetState) {
            clearInterval(checkInterval);
            resolve();
          } else if (Date.now() - startTime > timeoutMs) {
            clearInterval(checkInterval);
            reject(new import_core.ZWaveError(`Timeout waiting for connection state ${targetState}`, import_core.ZWaveErrorCodes.Driver_SerialPortClosed));
          }
        }, 10);
      });
    }
    __name(waitForState, "waitForState");
    function processIncomingData(data) {
      try {
        frameBuffer = import_shared.Bytes.concat([frameBuffer, data]);
        while (frameBuffer.length > 0) {
          try {
            if (frameBuffer.length < 3) {
              break;
            }
            const rawMessage = import_ESPHomeMessage.ESPHomeMessageRaw.parse(frameBuffer);
            const frameLength = 1 + getVarIntLength(rawMessage.payload.length) + getVarIntLength(rawMessage.messageType) + rawMessage.payload.length;
            const message = import_ESPHomeMessage.ESPHomeMessage.parse(frameBuffer);
            processIncomingMessage(message);
            frameBuffer = frameBuffer.subarray(frameLength);
          } catch (error) {
            if (error instanceof import_core.ZWaveError && error.code === import_core.ZWaveErrorCodes.PacketFormat_Truncated) {
              break;
            }
            frameBuffer = new import_shared.Bytes();
            break;
          }
        }
      } catch {
        frameBuffer = new import_shared.Bytes();
      }
    }
    __name(processIncomingData, "processIncomingData");
    function processIncomingMessage(message) {
      if (message instanceof import_HelloMessages.HelloResponse) {
        if (connectionState === ConnectionState.HelloSent) {
          connectionState = ConnectionState.HelloReceived;
        }
      } else if (message instanceof import_DeviceInfoMessages.DeviceInfoResponse) {
        if (connectionState === ConnectionState.DeviceInfoSent) {
          deviceInfo = message;
          connectionState = ConnectionState.DeviceInfoReceived;
        }
      } else if (message instanceof import_ZWaveProxyMessages.ZWaveProxyFrame) {
        if (sourceController && connectionState === ConnectionState.Ready) {
          sourceController.enqueue(message.data);
        }
      }
    }
    __name(processIncomingMessage, "processIncomingMessage");
    function open() {
      return new Promise((resolve, reject) => {
        const onClose = /* @__PURE__ */ __name(() => {
          removeListeners();
          socket.destroy();
          reject(new import_core.ZWaveError(`ESPHome connection closed unexpectedly!`, import_core.ZWaveErrorCodes.Driver_SerialPortClosed));
        }, "onClose");
        const onError = /* @__PURE__ */ __name((err) => {
          removeListeners();
          socket.destroy();
          reject(err);
        }, "onError");
        const onTimeout = /* @__PURE__ */ __name(() => {
          removeListeners();
          socket.destroy();
          reject(new import_core.ZWaveError(`Connection timed out after ${timeout}ms`, import_core.ZWaveErrorCodes.Driver_SerialPortClosed));
        }, "onTimeout");
        const onConnect = /* @__PURE__ */ __name(async () => {
          removeListeners();
          connectionState = ConnectionState.Connecting;
          socket.setKeepAlive(true, 1e3);
          socket.setNoDelay();
          socket.on("data", processIncomingData);
          try {
            await performHandshake();
            resolve();
          } catch (error) {
            socket.destroy();
            reject(error instanceof Error ? error : new Error(String(error)));
          }
        }, "onConnect");
        socket.setTimeout(timeout);
        socket.once("close", onClose);
        socket.once("error", onError);
        socket.once("timeout", onTimeout);
        socket.once("connect", onConnect);
        socket.connect(port, host);
      });
    }
    __name(open, "open");
    async function close() {
      try {
        if (connectionState !== ConnectionState.Disconnected) {
          const disconnectRequest = new import_ConnectionMessages.DisconnectRequest();
          await sendMessage(disconnectRequest);
        }
      } catch {
      }
      return new Promise((resolve) => {
        removeListeners();
        connectionState = ConnectionState.Disconnected;
        if (socket.destroyed) {
          resolve();
        } else {
          socket.once("close", () => resolve()).destroy();
        }
      });
    }
    __name(close, "close");
    await open();
    let isOpen = true;
    const sink = {
      async write(data, controller) {
        if (!isOpen || connectionState !== ConnectionState.Ready) {
          controller.error(new Error("ESPHome connection is not ready!"));
          return;
        }
        if (!deviceInfo?.hasZWaveProxySupport) {
          controller.error(new Error("Z-Wave proxy support not available!"));
          return;
        }
        try {
          const writeRequest = new import_ZWaveProxyMessages.ZWaveProxyFrame({
            data: new import_shared.Bytes(data)
          });
          await sendMessage(writeRequest);
        } catch (error) {
          controller.error(error);
        }
      },
      close() {
        return close();
      },
      abort(_reason) {
        return close();
      }
    };
    const source = {
      start(controller) {
        sourceController = controller;
        socket.on("close", () => {
          isOpen = false;
          connectionState = ConnectionState.Disconnected;
          controller.error(new import_core.ZWaveError(`ESPHome connection closed unexpectedly!`, import_core.ZWaveErrorCodes.Driver_SerialPortClosed));
        });
        socket.on("error", (_e) => {
          isOpen = false;
          connectionState = ConnectionState.Disconnected;
          controller.error(new import_core.ZWaveError(`ESPHome connection error!`, import_core.ZWaveErrorCodes.Driver_SerialPortClosed));
        });
      },
      cancel() {
        sourceController = void 0;
        socket.removeAllListeners();
      }
    };
    return { source, sink };
  };
}
__name(createESPHomeFactory, "createESPHomeFactory");
function getVarIntLength(value) {
  let length = 1;
  while (value >= 128) {
    value >>>= 7;
    length++;
  }
  return length;
}
__name(getVarIntLength, "getVarIntLength");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  createESPHomeFactory
});
//# sourceMappingURL=ESPHomeSocket.js.map
