import { type BytesView } from "@zwave-js/shared";
import type { SerialLogger } from "../log/Logger.js";
import { type ZWaveSerialFrame, ZWaveSerialFrameType } from "./ZWaveSerialFrame.js";
/** Parses the screen output from the bootloader, either waiting for a NUL char or a timeout */
export declare class BootloaderScreenParser extends TransformStream<BytesView, number | string> {
    constructor(logger?: SerialLogger);
}
export declare const bootloaderMenuPreamble = "Gecko Boo";
/** Transforms the bootloader screen output into meaningful chunks */
export declare class BootloaderParser extends TransformStream<number | string, ZWaveSerialFrame & {
    type: ZWaveSerialFrameType.Bootloader;
}> {
    constructor();
}
//# sourceMappingURL=BootloaderParsers.d.ts.map