var __esDecorate = (this && this.__esDecorate) || function (ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};
var __runInitializers = (this && this.__runInitializers) || function (thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};
import { MAX_NODES, MessagePriority, NUM_NODEMASK_BYTES, NodeType, encodeBitMask, getChipTypeAndVersion, getZWaveChipType, parseNodeBitMask, } from "@zwave-js/core";
import { FunctionType, Message, MessageType, expectedResponse, messageTypes, priority, } from "@zwave-js/serial";
import { Bytes } from "@zwave-js/shared";
let GetSerialApiInitDataRequest = (() => {
    let _classDecorators = [messageTypes(MessageType.Request, FunctionType.GetSerialApiInitData), expectedResponse(FunctionType.GetSerialApiInitData), priority(MessagePriority.Controller)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = Message;
    var GetSerialApiInitDataRequest = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            GetSerialApiInitDataRequest = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
    };
    return GetSerialApiInitDataRequest = _classThis;
})();
export { GetSerialApiInitDataRequest };
let GetSerialApiInitDataResponse = (() => {
    let _classDecorators = [messageTypes(MessageType.Response, FunctionType.GetSerialApiInitData)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = Message;
    var GetSerialApiInitDataResponse = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            GetSerialApiInitDataResponse = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.zwaveApiVersion = options.zwaveApiVersion;
            this.isPrimary = options.isPrimary;
            this.nodeType = options.nodeType;
            this.supportsTimers = options.supportsTimers;
            this.isSIS = options.isSIS;
            this.nodeIds = options.nodeIds;
            this.zwaveChipType = options.zwaveChipType;
        }
        static from(raw, _ctx) {
            const apiVersion = raw.payload[0];
            let zwaveApiVersion;
            if (apiVersion < 10) {
                zwaveApiVersion = {
                    kind: "legacy",
                    version: apiVersion,
                };
            }
            else {
                // this module uses the officially specified Host API
                zwaveApiVersion = {
                    kind: "official",
                    version: apiVersion - 9,
                };
            }
            const capabilities = raw.payload[1];
            // The new "official" Host API specs incorrectly switched the meaning of some flags
            // Apparently this was never intended, and the firmware correctly uses the "old" encoding.
            // https://community.silabs.com/s/question/0D58Y00009qjEghSAE/bug-in-firmware-7191-get-init-data-response-does-not-match-host-api-specification?language=en_US
            const nodeType = capabilities & 0b0001
                ? NodeType["End Node"]
                : NodeType.Controller;
            const supportsTimers = !!(capabilities & 0b0010);
            const isPrimary = !(capabilities & 0b0100);
            const isSIS = !!(capabilities & 0b1000);
            let offset = 2;
            let nodeIds = [];
            if (raw.payload.length > offset) {
                const nodeListLength = raw.payload[offset];
                // Controller Nodes MUST set this field to 29
                if (nodeListLength === NUM_NODEMASK_BYTES
                    && raw.payload.length >= offset + 1 + nodeListLength) {
                    const nodeBitMask = raw.payload.subarray(offset + 1, offset + 1 + nodeListLength);
                    nodeIds = parseNodeBitMask(nodeBitMask);
                }
                offset += 1 + nodeListLength;
            }
            // these might not be present:
            const chipType = raw.payload[offset];
            const chipVersion = raw.payload[offset + 1];
            let zwaveChipType;
            if (chipType != undefined && chipVersion != undefined) {
                zwaveChipType = getZWaveChipType(chipType, chipVersion);
            }
            return new this({
                zwaveApiVersion,
                nodeType,
                supportsTimers,
                isPrimary,
                isSIS,
                nodeIds,
                zwaveChipType,
            });
        }
        zwaveApiVersion;
        isPrimary;
        nodeType;
        supportsTimers;
        isSIS;
        nodeIds;
        zwaveChipType;
        serialize(ctx) {
            let chipType;
            if (typeof this.zwaveChipType === "string") {
                chipType = getChipTypeAndVersion(this.zwaveChipType);
            }
            else {
                chipType = this.zwaveChipType;
            }
            this.payload = new Bytes(3 + NUM_NODEMASK_BYTES + (chipType ? 2 : 0));
            let capabilities = 0;
            if (this.supportsTimers)
                capabilities |= 0b0010;
            if (this.isSIS)
                capabilities |= 0b1000;
            if (this.zwaveApiVersion.kind === "legacy") {
                this.payload[0] = this.zwaveApiVersion.version;
                if (this.nodeType === NodeType["End Node"])
                    capabilities |= 0b0001;
                if (!this.isPrimary)
                    capabilities |= 0b0100;
            }
            else {
                this.payload[0] = this.zwaveApiVersion.version + 9;
                if (this.nodeType === NodeType.Controller)
                    capabilities |= 0b0001;
                if (this.isPrimary)
                    capabilities |= 0b0100;
            }
            this.payload[1] = capabilities;
            this.payload[2] = NUM_NODEMASK_BYTES;
            const nodeBitMask = encodeBitMask(this.nodeIds, MAX_NODES);
            this.payload.set(nodeBitMask, 3);
            if (chipType) {
                this.payload[3 + NUM_NODEMASK_BYTES] = chipType.type;
                this.payload[3 + NUM_NODEMASK_BYTES + 1] = chipType.version;
            }
            return super.serialize(ctx);
        }
    };
    return GetSerialApiInitDataResponse = _classThis;
})();
export { GetSerialApiInitDataResponse };
// Z-Stick 7, 7.15
// 12:15:28.505 DRIVER « [RES] [GetSerialApiInitData]
//                         Z-Wave API Version: 9 (proprietary)
//                         node type:          controller
//                         supports timers:    false
//                         is secondary:       false
//                         is SUC:             true
//                         chip type:          7
//                         chip version:       0
// ACC-UZB3
// 12:21:11.141 DRIVER « [RES] [GetSerialApiInitData]
//                         Z-Wave API Version: 8 (proprietary)
//                         node type:          controller
//                         supports timers:    false
//                         is secondary:       false
//                         is SUC:             true
//                         chip type:          5
//                         chip version:       0
// UZB7, 7.11
// 12:33:14.211 DRIVER « [RES] [GetSerialApiInitData]
//                         Z-Wave API Version: 8 (proprietary)
//                         node type:          controller
//                         supports timers:    false
//                         is secondary:       false
//                         is SUC:             true
//                         chip type:          7
//                         chip version:       0
//# sourceMappingURL=GetSerialApiInitDataMessages.js.map