var __esDecorate = (this && this.__esDecorate) || function (ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};
var __runInitializers = (this && this.__runInitializers) || function (thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};
import { MessagePriority, NodeIDType, RFRegion, ZWaveError, ZWaveErrorCodes, parseBitMask, sdkVersionLt, validatePayload, } from "@zwave-js/core";
import { createSimpleReflectionDecorator } from "@zwave-js/core/reflection";
import { FunctionType, Message, MessageType, expectedResponse, messageTypes, priority, } from "@zwave-js/serial";
import { Bytes, getEnumMemberName } from "@zwave-js/shared";
export var SerialAPISetupCommand;
(function (SerialAPISetupCommand) {
    SerialAPISetupCommand[SerialAPISetupCommand["Unsupported"] = 0] = "Unsupported";
    SerialAPISetupCommand[SerialAPISetupCommand["GetSupportedCommands"] = 1] = "GetSupportedCommands";
    SerialAPISetupCommand[SerialAPISetupCommand["SetTxStatusReport"] = 2] = "SetTxStatusReport";
    SerialAPISetupCommand[SerialAPISetupCommand["SetLongRangeMaximumTxPower"] = 3] = "SetLongRangeMaximumTxPower";
    SerialAPISetupCommand[SerialAPISetupCommand["SetPowerlevel"] = 4] = "SetPowerlevel";
    SerialAPISetupCommand[SerialAPISetupCommand["GetLongRangeMaximumTxPower"] = 5] = "GetLongRangeMaximumTxPower";
    SerialAPISetupCommand[SerialAPISetupCommand["GetPowerlevel"] = 8] = "GetPowerlevel";
    SerialAPISetupCommand[SerialAPISetupCommand["GetMaximumPayloadSize"] = 16] = "GetMaximumPayloadSize";
    SerialAPISetupCommand[SerialAPISetupCommand["GetRFRegion"] = 32] = "GetRFRegion";
    SerialAPISetupCommand[SerialAPISetupCommand["SetRFRegion"] = 64] = "SetRFRegion";
    SerialAPISetupCommand[SerialAPISetupCommand["SetNodeIDType"] = 128] = "SetNodeIDType";
    SerialAPISetupCommand[SerialAPISetupCommand["GetLongRangeMaximumPayloadSize"] = 17] = "GetLongRangeMaximumPayloadSize";
    SerialAPISetupCommand[SerialAPISetupCommand["SetPowerlevel16Bit"] = 18] = "SetPowerlevel16Bit";
    SerialAPISetupCommand[SerialAPISetupCommand["GetPowerlevel16Bit"] = 19] = "GetPowerlevel16Bit";
    SerialAPISetupCommand[SerialAPISetupCommand["GetSupportedRegions"] = 21] = "GetSupportedRegions";
    SerialAPISetupCommand[SerialAPISetupCommand["GetRegionInfo"] = 22] = "GetRegionInfo";
})(SerialAPISetupCommand || (SerialAPISetupCommand = {}));
// We need to define the decorators for Requests and Responses separately
const { decorator: subCommandRequest, lookupConstructor: getSubCommandRequestConstructor, lookupValue: getSubCommandForRequest, } = createSimpleReflectionDecorator({
    name: "subCommandRequest",
});
const { decorator: subCommandResponse, lookupConstructor: getSubCommandResponseConstructor, lookupValue: getSubCommandForResponse, } = createSimpleReflectionDecorator({
    name: "subCommandResponse",
});
function testResponseForSerialAPISetupRequest(sent, received) {
    if (!(received instanceof SerialAPISetupResponse))
        return false;
    return sent.command === received.command;
}
let SerialAPISetupRequest = (() => {
    let _classDecorators = [messageTypes(MessageType.Request, FunctionType.SerialAPISetup), priority(MessagePriority.Controller), expectedResponse(testResponseForSerialAPISetupRequest)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = Message;
    var SerialAPISetupRequest = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            SerialAPISetupRequest = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options = {}) {
            super(options);
            this.command = options.command ?? getSubCommandForRequest(this);
        }
        static from(raw, ctx) {
            const command = raw.payload[0];
            const payload = raw.payload.subarray(1);
            const CommandConstructor = getSubCommandRequestConstructor(command);
            if (CommandConstructor) {
                return CommandConstructor.from(raw.withPayload(payload), ctx);
            }
            const ret = new SerialAPISetupRequest({
                command,
            });
            ret.payload = payload;
            return ret;
        }
        command;
        serialize(ctx) {
            this.payload = Bytes.concat([
                Bytes.from([this.command]),
                this.payload,
            ]);
            return super.serialize(ctx);
        }
        toLogEntry() {
            const message = {
                command: getEnumMemberName(SerialAPISetupCommand, this.command),
            };
            if (this.payload.length > 0) {
                message.payload = `0x${this.payload.toString("hex")}`;
            }
            return {
                ...super.toLogEntry(),
                message,
            };
        }
    };
    return SerialAPISetupRequest = _classThis;
})();
export { SerialAPISetupRequest };
let SerialAPISetupResponse = (() => {
    let _classDecorators = [messageTypes(MessageType.Response, FunctionType.SerialAPISetup)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = Message;
    var SerialAPISetupResponse = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            SerialAPISetupResponse = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.command = options.command ?? getSubCommandForResponse(this);
        }
        static from(raw, ctx) {
            const command = raw.payload[0];
            const payload = raw.payload.subarray(1);
            const CommandConstructor = getSubCommandResponseConstructor(command);
            if (CommandConstructor) {
                return CommandConstructor.from(raw.withPayload(payload), ctx);
            }
            const ret = new SerialAPISetupResponse({
                command,
            });
            ret.payload = payload;
            return ret;
        }
        command;
        toLogEntry() {
            const message = {
                command: getEnumMemberName(SerialAPISetupCommand, this.command),
            };
            if (this.payload.length > 0) {
                message.payload = `0x${this.payload.toString("hex")}`;
            }
            return {
                ...super.toLogEntry(),
                message,
            };
        }
    };
    return SerialAPISetupResponse = _classThis;
})();
export { SerialAPISetupResponse };
let SerialAPISetup_CommandUnsupportedResponse = (() => {
    let _classDecorators = [subCommandResponse(0x00)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = SerialAPISetupResponse;
    var SerialAPISetup_CommandUnsupportedResponse = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            SerialAPISetup_CommandUnsupportedResponse = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.command = options.command;
        }
        static from(raw, _ctx) {
            // The payload contains which command is unsupported
            const command = raw.payload[0];
            return new this({
                command,
            });
        }
        toLogEntry() {
            const ret = { ...super.toLogEntry() };
            const message = ret.message;
            message.error = "unsupported command";
            message.command = getEnumMemberName(SerialAPISetupCommand, this.command);
            delete message.payload;
            return ret;
        }
    };
    return SerialAPISetup_CommandUnsupportedResponse = _classThis;
})();
export { SerialAPISetup_CommandUnsupportedResponse };
// =============================================================================
let SerialAPISetup_GetSupportedCommandsRequest = (() => {
    let _classDecorators = [subCommandRequest(SerialAPISetupCommand.GetSupportedCommands)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = SerialAPISetupRequest;
    var SerialAPISetup_GetSupportedCommandsRequest = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            SerialAPISetup_GetSupportedCommandsRequest = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
    };
    return SerialAPISetup_GetSupportedCommandsRequest = _classThis;
})();
export { SerialAPISetup_GetSupportedCommandsRequest };
let SerialAPISetup_GetSupportedCommandsResponse = (() => {
    let _classDecorators = [subCommandResponse(SerialAPISetupCommand.GetSupportedCommands)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = SerialAPISetupResponse;
    var SerialAPISetup_GetSupportedCommandsResponse = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            SerialAPISetup_GetSupportedCommandsResponse = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.supportedCommands = options.supportedCommands;
        }
        static from(raw, ctx) {
            validatePayload(raw.payload.length >= 1);
            let supportedCommands;
            if (raw.payload.length > 1) {
                // This module supports the extended bitmask to report the supported serial API setup commands
                // Parse it as a bitmask
                supportedCommands = parseBitMask(raw.payload.subarray(1), 
                // According to the Host API specification, the first bit (bit 0) should be GetSupportedCommands
                // However, in Z-Wave SDK < 7.19.1, the entire bitmask is shifted by 1 bit and
                // GetSupportedCommands is encoded in the second bit (bit 1)
                sdkVersionLt(ctx.sdkVersion, "7.19.1")
                    ? SerialAPISetupCommand.Unsupported
                    : SerialAPISetupCommand.GetSupportedCommands);
            }
            else {
                // This module only uses the single byte power-of-2 bitmask. Decode it manually
                supportedCommands = [];
                for (const cmd of [
                    SerialAPISetupCommand.GetSupportedCommands,
                    SerialAPISetupCommand.SetTxStatusReport,
                    SerialAPISetupCommand.SetPowerlevel,
                    SerialAPISetupCommand.GetPowerlevel,
                    SerialAPISetupCommand.GetMaximumPayloadSize,
                    SerialAPISetupCommand.GetRFRegion,
                    SerialAPISetupCommand.SetRFRegion,
                    SerialAPISetupCommand.SetNodeIDType,
                ]) {
                    if (!!(raw.payload[0] & cmd))
                        supportedCommands.push(cmd);
                }
            }
            // Apparently GetSupportedCommands is not always included in the bitmask, although we
            // just received a response to the command
            if (!supportedCommands.includes(SerialAPISetupCommand.GetSupportedCommands)) {
                supportedCommands.unshift(SerialAPISetupCommand.GetSupportedCommands);
            }
            return new this({
                supportedCommands,
            });
        }
        supportedCommands;
    };
    return SerialAPISetup_GetSupportedCommandsResponse = _classThis;
})();
export { SerialAPISetup_GetSupportedCommandsResponse };
let SerialAPISetup_SetTXStatusReportRequest = (() => {
    let _classDecorators = [subCommandRequest(SerialAPISetupCommand.SetTxStatusReport)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = SerialAPISetupRequest;
    var SerialAPISetup_SetTXStatusReportRequest = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            SerialAPISetup_SetTXStatusReportRequest = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.enabled = options.enabled;
        }
        static from(raw, _ctx) {
            const enabled = raw.payload[0] === 0xff;
            return new this({
                enabled,
            });
        }
        enabled;
        serialize(ctx) {
            this.payload = Bytes.from([this.enabled ? 0xff : 0x00]);
            return super.serialize(ctx);
        }
        toLogEntry() {
            const ret = { ...super.toLogEntry() };
            const message = ret.message;
            message.enabled = this.enabled;
            delete message.payload;
            return ret;
        }
    };
    return SerialAPISetup_SetTXStatusReportRequest = _classThis;
})();
export { SerialAPISetup_SetTXStatusReportRequest };
let SerialAPISetup_SetTXStatusReportResponse = (() => {
    let _classDecorators = [subCommandResponse(SerialAPISetupCommand.SetTxStatusReport)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = SerialAPISetupResponse;
    var SerialAPISetup_SetTXStatusReportResponse = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            SerialAPISetup_SetTXStatusReportResponse = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.success = options.success;
        }
        static from(raw, _ctx) {
            const success = raw.payload[0] !== 0;
            return new this({
                success,
            });
        }
        isOK() {
            return this.success;
        }
        success;
        toLogEntry() {
            const ret = { ...super.toLogEntry() };
            const message = ret.message;
            message.success = this.success;
            delete message.payload;
            return ret;
        }
    };
    return SerialAPISetup_SetTXStatusReportResponse = _classThis;
})();
export { SerialAPISetup_SetTXStatusReportResponse };
let SerialAPISetup_SetNodeIDTypeRequest = (() => {
    let _classDecorators = [subCommandRequest(SerialAPISetupCommand.SetNodeIDType)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = SerialAPISetupRequest;
    var SerialAPISetup_SetNodeIDTypeRequest = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            SerialAPISetup_SetNodeIDTypeRequest = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.nodeIdType = options.nodeIdType;
        }
        static from(_raw, _ctx) {
            throw new ZWaveError(`${this.name}: deserialization not implemented`, ZWaveErrorCodes.Deserialization_NotImplemented);
            // return new SerialAPISetup_SetNodeIDTypeRequest({});
        }
        nodeIdType;
        serialize(ctx) {
            this.payload = Bytes.from([this.nodeIdType]);
            return super.serialize(ctx);
        }
        toLogEntry() {
            const ret = { ...super.toLogEntry() };
            const message = ret.message;
            message["node ID type"] = this.nodeIdType === NodeIDType.Short
                ? "8 bit"
                : "16 bit";
            delete message.payload;
            return ret;
        }
    };
    return SerialAPISetup_SetNodeIDTypeRequest = _classThis;
})();
export { SerialAPISetup_SetNodeIDTypeRequest };
let SerialAPISetup_SetNodeIDTypeResponse = (() => {
    let _classDecorators = [subCommandResponse(SerialAPISetupCommand.SetNodeIDType)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = SerialAPISetupResponse;
    var SerialAPISetup_SetNodeIDTypeResponse = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            SerialAPISetup_SetNodeIDTypeResponse = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.success = options.success;
        }
        static from(raw, _ctx) {
            const success = raw.payload[0] !== 0;
            return new this({
                success,
            });
        }
        isOK() {
            return this.success;
        }
        success;
        toLogEntry() {
            const ret = { ...super.toLogEntry() };
            const message = ret.message;
            message.success = this.success;
            delete message.payload;
            return ret;
        }
    };
    return SerialAPISetup_SetNodeIDTypeResponse = _classThis;
})();
export { SerialAPISetup_SetNodeIDTypeResponse };
// =============================================================================
let SerialAPISetup_GetRFRegionRequest = (() => {
    let _classDecorators = [subCommandRequest(SerialAPISetupCommand.GetRFRegion)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = SerialAPISetupRequest;
    var SerialAPISetup_GetRFRegionRequest = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            SerialAPISetup_GetRFRegionRequest = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
    };
    return SerialAPISetup_GetRFRegionRequest = _classThis;
})();
export { SerialAPISetup_GetRFRegionRequest };
let SerialAPISetup_GetRFRegionResponse = (() => {
    let _classDecorators = [subCommandResponse(SerialAPISetupCommand.GetRFRegion)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = SerialAPISetupResponse;
    var SerialAPISetup_GetRFRegionResponse = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            SerialAPISetup_GetRFRegionResponse = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.region = options.region;
        }
        static from(raw, _ctx) {
            const region = raw.payload[0];
            return new this({
                region,
            });
        }
        region;
        toLogEntry() {
            const ret = { ...super.toLogEntry() };
            const message = ret.message;
            message.region = getEnumMemberName(RFRegion, this.region);
            delete message.payload;
            return ret;
        }
    };
    return SerialAPISetup_GetRFRegionResponse = _classThis;
})();
export { SerialAPISetup_GetRFRegionResponse };
let SerialAPISetup_SetRFRegionRequest = (() => {
    let _classDecorators = [subCommandRequest(SerialAPISetupCommand.SetRFRegion)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = SerialAPISetupRequest;
    var SerialAPISetup_SetRFRegionRequest = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            SerialAPISetup_SetRFRegionRequest = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.region = options.region;
        }
        static from(raw, _ctx) {
            const region = raw.payload[0];
            return new this({
                region,
            });
        }
        region;
        serialize(ctx) {
            this.payload = Bytes.from([this.region]);
            return super.serialize(ctx);
        }
        toLogEntry() {
            const ret = { ...super.toLogEntry() };
            const message = ret.message;
            message.region = getEnumMemberName(RFRegion, this.region);
            delete message.payload;
            return ret;
        }
    };
    return SerialAPISetup_SetRFRegionRequest = _classThis;
})();
export { SerialAPISetup_SetRFRegionRequest };
let SerialAPISetup_SetRFRegionResponse = (() => {
    let _classDecorators = [subCommandResponse(SerialAPISetupCommand.SetRFRegion)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = SerialAPISetupResponse;
    var SerialAPISetup_SetRFRegionResponse = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            SerialAPISetup_SetRFRegionResponse = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.success = options.success;
        }
        static from(raw, _ctx) {
            const success = raw.payload[0] !== 0;
            return new this({
                success,
            });
        }
        isOK() {
            return this.success;
        }
        success;
        toLogEntry() {
            const ret = { ...super.toLogEntry() };
            const message = ret.message;
            message.success = this.success;
            delete message.payload;
            return ret;
        }
    };
    return SerialAPISetup_SetRFRegionResponse = _classThis;
})();
export { SerialAPISetup_SetRFRegionResponse };
// =============================================================================
let SerialAPISetup_GetPowerlevelRequest = (() => {
    let _classDecorators = [subCommandRequest(SerialAPISetupCommand.GetPowerlevel)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = SerialAPISetupRequest;
    var SerialAPISetup_GetPowerlevelRequest = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            SerialAPISetup_GetPowerlevelRequest = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
    };
    return SerialAPISetup_GetPowerlevelRequest = _classThis;
})();
export { SerialAPISetup_GetPowerlevelRequest };
let SerialAPISetup_GetPowerlevelResponse = (() => {
    let _classDecorators = [subCommandResponse(SerialAPISetupCommand.GetPowerlevel)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = SerialAPISetupResponse;
    var SerialAPISetup_GetPowerlevelResponse = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            SerialAPISetup_GetPowerlevelResponse = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.powerlevel = options.powerlevel;
            this.measured0dBm = options.measured0dBm;
        }
        static from(raw, _ctx) {
            validatePayload(raw.payload.length >= 2);
            // The values are in 0.1 dBm, signed
            const powerlevel = raw.payload.readInt8(0) / 10;
            const measured0dBm = raw.payload.readInt8(1) / 10;
            return new this({
                powerlevel,
                measured0dBm,
            });
        }
        /** The configured normal powerlevel in dBm */
        powerlevel;
        /** The measured output power in dBm for a normal output powerlevel of 0 */
        measured0dBm;
        toLogEntry() {
            const ret = { ...super.toLogEntry() };
            const message = {
                ...ret.message,
                "normal powerlevel": `${this.powerlevel.toFixed(1)} dBm`,
                "output power at 0 dBm": `${this.measured0dBm.toFixed(1)} dBm`,
            };
            delete message.payload;
            ret.message = message;
            return ret;
        }
    };
    return SerialAPISetup_GetPowerlevelResponse = _classThis;
})();
export { SerialAPISetup_GetPowerlevelResponse };
let SerialAPISetup_SetPowerlevelRequest = (() => {
    let _classDecorators = [subCommandRequest(SerialAPISetupCommand.SetPowerlevel)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = SerialAPISetupRequest;
    var SerialAPISetup_SetPowerlevelRequest = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            SerialAPISetup_SetPowerlevelRequest = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            if (options.powerlevel < -12.8 || options.powerlevel > 12.7) {
                throw new ZWaveError(`The normal powerlevel must be between -12.8 and +12.7 dBm`, ZWaveErrorCodes.Argument_Invalid);
            }
            if (options.measured0dBm < -12.8 || options.measured0dBm > 12.7) {
                throw new ZWaveError(`The measured output power at 0 dBm must be between -12.8 and +12.7 dBm`, ZWaveErrorCodes.Argument_Invalid);
            }
            this.powerlevel = options.powerlevel;
            this.measured0dBm = options.measured0dBm;
        }
        static from(_raw, _ctx) {
            throw new ZWaveError(`${this.name}: deserialization not implemented`, ZWaveErrorCodes.Deserialization_NotImplemented);
            // return new SerialAPISetup_SetPowerlevelRequest({});
        }
        powerlevel;
        measured0dBm;
        serialize(ctx) {
            this.payload = new Bytes(2);
            // The values are in 0.1 dBm
            this.payload.writeInt8(Math.round(this.powerlevel * 10), 0);
            this.payload.writeInt8(Math.round(this.measured0dBm * 10), 1);
            return super.serialize(ctx);
        }
        toLogEntry() {
            const ret = { ...super.toLogEntry() };
            const message = {
                ...ret.message,
                "normal powerlevel": `${this.powerlevel.toFixed(1)} dBm`,
                "output power at 0 dBm": `${this.measured0dBm.toFixed(1)} dBm`,
            };
            delete message.payload;
            ret.message = message;
            return ret;
        }
    };
    return SerialAPISetup_SetPowerlevelRequest = _classThis;
})();
export { SerialAPISetup_SetPowerlevelRequest };
let SerialAPISetup_SetPowerlevelResponse = (() => {
    let _classDecorators = [subCommandResponse(SerialAPISetupCommand.SetPowerlevel)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = SerialAPISetupResponse;
    var SerialAPISetup_SetPowerlevelResponse = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            SerialAPISetup_SetPowerlevelResponse = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.success = options.success;
        }
        static from(raw, _ctx) {
            const success = raw.payload[0] !== 0;
            return new this({
                success,
            });
        }
        isOK() {
            return this.success;
        }
        success;
        toLogEntry() {
            const ret = { ...super.toLogEntry() };
            const message = ret.message;
            message.success = this.success;
            delete message.payload;
            return ret;
        }
    };
    return SerialAPISetup_SetPowerlevelResponse = _classThis;
})();
export { SerialAPISetup_SetPowerlevelResponse };
// =============================================================================
let SerialAPISetup_GetPowerlevel16BitRequest = (() => {
    let _classDecorators = [subCommandRequest(SerialAPISetupCommand.GetPowerlevel16Bit)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = SerialAPISetupRequest;
    var SerialAPISetup_GetPowerlevel16BitRequest = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            SerialAPISetup_GetPowerlevel16BitRequest = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
    };
    return SerialAPISetup_GetPowerlevel16BitRequest = _classThis;
})();
export { SerialAPISetup_GetPowerlevel16BitRequest };
let SerialAPISetup_GetPowerlevel16BitResponse = (() => {
    let _classDecorators = [subCommandResponse(SerialAPISetupCommand.GetPowerlevel16Bit)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = SerialAPISetupResponse;
    var SerialAPISetup_GetPowerlevel16BitResponse = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            SerialAPISetup_GetPowerlevel16BitResponse = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.powerlevel = options.powerlevel;
            this.measured0dBm = options.measured0dBm;
        }
        static from(raw, _ctx) {
            validatePayload(raw.payload.length >= 4);
            // The values are in 0.1 dBm, signed
            const powerlevel = raw.payload.readInt16BE(0) / 10;
            const measured0dBm = raw.payload.readInt16BE(2) / 10;
            return new this({
                powerlevel,
                measured0dBm,
            });
        }
        /** The configured normal powerlevel in dBm */
        powerlevel;
        /** The measured output power in dBm for a normal output powerlevel of 0 */
        measured0dBm;
        toLogEntry() {
            const ret = { ...super.toLogEntry() };
            const message = {
                ...ret.message,
                "normal powerlevel": `${this.powerlevel.toFixed(1)} dBm`,
                "output power at 0 dBm": `${this.measured0dBm.toFixed(1)} dBm`,
            };
            delete message.payload;
            ret.message = message;
            return ret;
        }
    };
    return SerialAPISetup_GetPowerlevel16BitResponse = _classThis;
})();
export { SerialAPISetup_GetPowerlevel16BitResponse };
let SerialAPISetup_SetPowerlevel16BitRequest = (() => {
    let _classDecorators = [subCommandRequest(SerialAPISetupCommand.SetPowerlevel16Bit)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = SerialAPISetupRequest;
    var SerialAPISetup_SetPowerlevel16BitRequest = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            SerialAPISetup_SetPowerlevel16BitRequest = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            if (options.powerlevel < -10 || options.powerlevel > 20) {
                throw new ZWaveError(`The normal powerlevel must be between -10.0 and +20.0 dBm`, ZWaveErrorCodes.Argument_Invalid);
            }
            if (options.measured0dBm < -10 || options.measured0dBm > 10) {
                throw new ZWaveError(`The measured output power at 0 dBm must be between -10.0 and +10.0 dBm`, ZWaveErrorCodes.Argument_Invalid);
            }
            this.powerlevel = options.powerlevel;
            this.measured0dBm = options.measured0dBm;
        }
        static from(_raw, _ctx) {
            throw new ZWaveError(`${this.name}: deserialization not implemented`, ZWaveErrorCodes.Deserialization_NotImplemented);
            // return new SerialAPISetup_SetPowerlevel16BitRequest({});
        }
        powerlevel;
        measured0dBm;
        serialize(ctx) {
            this.payload = new Bytes(4);
            // The values are in 0.1 dBm
            this.payload.writeInt16BE(Math.round(this.powerlevel * 10), 0);
            this.payload.writeInt16BE(Math.round(this.measured0dBm * 10), 2);
            return super.serialize(ctx);
        }
        toLogEntry() {
            const ret = { ...super.toLogEntry() };
            const message = {
                ...ret.message,
                "normal powerlevel": `${this.powerlevel.toFixed(1)} dBm`,
                "output power at 0 dBm": `${this.measured0dBm.toFixed(1)} dBm`,
            };
            delete message.payload;
            ret.message = message;
            return ret;
        }
    };
    return SerialAPISetup_SetPowerlevel16BitRequest = _classThis;
})();
export { SerialAPISetup_SetPowerlevel16BitRequest };
let SerialAPISetup_SetPowerlevel16BitResponse = (() => {
    let _classDecorators = [subCommandResponse(SerialAPISetupCommand.SetPowerlevel16Bit)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = SerialAPISetupResponse;
    var SerialAPISetup_SetPowerlevel16BitResponse = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            SerialAPISetup_SetPowerlevel16BitResponse = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.success = options.success;
        }
        static from(raw, _ctx) {
            const success = raw.payload[0] !== 0;
            return new this({
                success,
            });
        }
        isOK() {
            return this.success;
        }
        success;
        toLogEntry() {
            const ret = { ...super.toLogEntry() };
            const message = ret.message;
            message.success = this.success;
            delete message.payload;
            return ret;
        }
    };
    return SerialAPISetup_SetPowerlevel16BitResponse = _classThis;
})();
export { SerialAPISetup_SetPowerlevel16BitResponse };
// =============================================================================
let SerialAPISetup_GetLongRangeMaximumTxPowerRequest = (() => {
    let _classDecorators = [subCommandRequest(SerialAPISetupCommand.GetLongRangeMaximumTxPower)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = SerialAPISetupRequest;
    var SerialAPISetup_GetLongRangeMaximumTxPowerRequest = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            SerialAPISetup_GetLongRangeMaximumTxPowerRequest = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
    };
    return SerialAPISetup_GetLongRangeMaximumTxPowerRequest = _classThis;
})();
export { SerialAPISetup_GetLongRangeMaximumTxPowerRequest };
let SerialAPISetup_GetLongRangeMaximumTxPowerResponse = (() => {
    let _classDecorators = [subCommandResponse(SerialAPISetupCommand.GetLongRangeMaximumTxPower)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = SerialAPISetupResponse;
    var SerialAPISetup_GetLongRangeMaximumTxPowerResponse = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            SerialAPISetup_GetLongRangeMaximumTxPowerResponse = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.limit = options.limit;
        }
        static from(raw, _ctx) {
            validatePayload(raw.payload.length >= 2);
            // The values are in 0.1 dBm, signed
            const limit = raw.payload.readInt16BE(0) / 10;
            return new this({
                limit,
            });
        }
        /** The maximum LR TX power in dBm */
        limit;
        toLogEntry() {
            const ret = { ...super.toLogEntry() };
            const message = {
                ...ret.message,
                "max. TX power (LR)": `${this.limit.toFixed(1)} dBm`,
            };
            delete message.payload;
            ret.message = message;
            return ret;
        }
    };
    return SerialAPISetup_GetLongRangeMaximumTxPowerResponse = _classThis;
})();
export { SerialAPISetup_GetLongRangeMaximumTxPowerResponse };
let SerialAPISetup_SetLongRangeMaximumTxPowerRequest = (() => {
    let _classDecorators = [subCommandRequest(SerialAPISetupCommand.SetLongRangeMaximumTxPower)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = SerialAPISetupRequest;
    var SerialAPISetup_SetLongRangeMaximumTxPowerRequest = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            SerialAPISetup_SetLongRangeMaximumTxPowerRequest = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            if (options.limit < -10 || options.limit > 20) {
                throw new ZWaveError(`The maximum LR TX power must be between -10.0 and +20.0 dBm`, ZWaveErrorCodes.Argument_Invalid);
            }
            this.limit = options.limit;
        }
        static from(_raw, _ctx) {
            throw new ZWaveError(`${this.name}: deserialization not implemented`, ZWaveErrorCodes.Deserialization_NotImplemented);
            // return new SerialAPISetup_SetLongRangeMaximumTxPowerRequest({});
        }
        /** The maximum LR TX power in dBm */
        limit;
        serialize(ctx) {
            this.payload = new Bytes(2);
            // The values are in 0.1 dBm, signed
            this.payload.writeInt16BE(Math.round(this.limit * 10), 0);
            return super.serialize(ctx);
        }
        toLogEntry() {
            const ret = { ...super.toLogEntry() };
            const message = {
                ...ret.message,
                "max. TX power (LR)": `${this.limit.toFixed(1)} dBm`,
            };
            delete message.payload;
            ret.message = message;
            return ret;
        }
    };
    return SerialAPISetup_SetLongRangeMaximumTxPowerRequest = _classThis;
})();
export { SerialAPISetup_SetLongRangeMaximumTxPowerRequest };
let SerialAPISetup_SetLongRangeMaximumTxPowerResponse = (() => {
    let _classDecorators = [subCommandResponse(SerialAPISetupCommand.SetLongRangeMaximumTxPower)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = SerialAPISetupResponse;
    var SerialAPISetup_SetLongRangeMaximumTxPowerResponse = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            SerialAPISetup_SetLongRangeMaximumTxPowerResponse = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.success = options.success;
        }
        static from(raw, _ctx) {
            const success = raw.payload[0] !== 0;
            return new this({
                success,
            });
        }
        isOK() {
            return this.success;
        }
        success;
        toLogEntry() {
            const ret = { ...super.toLogEntry() };
            const message = ret.message;
            message.success = this.success;
            delete message.payload;
            return ret;
        }
    };
    return SerialAPISetup_SetLongRangeMaximumTxPowerResponse = _classThis;
})();
export { SerialAPISetup_SetLongRangeMaximumTxPowerResponse };
// =============================================================================
let SerialAPISetup_GetMaximumPayloadSizeRequest = (() => {
    let _classDecorators = [subCommandRequest(SerialAPISetupCommand.GetMaximumPayloadSize)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = SerialAPISetupRequest;
    var SerialAPISetup_GetMaximumPayloadSizeRequest = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            SerialAPISetup_GetMaximumPayloadSizeRequest = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
    };
    return SerialAPISetup_GetMaximumPayloadSizeRequest = _classThis;
})();
export { SerialAPISetup_GetMaximumPayloadSizeRequest };
let SerialAPISetup_GetMaximumPayloadSizeResponse = (() => {
    let _classDecorators = [subCommandResponse(SerialAPISetupCommand.GetMaximumPayloadSize)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = SerialAPISetupResponse;
    var SerialAPISetup_GetMaximumPayloadSizeResponse = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            SerialAPISetup_GetMaximumPayloadSizeResponse = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.maxPayloadSize = options.maxPayloadSize;
        }
        static from(raw, _ctx) {
            const maxPayloadSize = raw.payload[0];
            return new this({
                maxPayloadSize,
            });
        }
        maxPayloadSize;
        toLogEntry() {
            const ret = { ...super.toLogEntry() };
            const message = ret.message;
            message["maximum payload size"] = `${this.maxPayloadSize} bytes`;
            delete message.payload;
            return ret;
        }
    };
    return SerialAPISetup_GetMaximumPayloadSizeResponse = _classThis;
})();
export { SerialAPISetup_GetMaximumPayloadSizeResponse };
// =============================================================================
let SerialAPISetup_GetLongRangeMaximumPayloadSizeRequest = (() => {
    let _classDecorators = [subCommandRequest(SerialAPISetupCommand.GetLongRangeMaximumPayloadSize)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = SerialAPISetupRequest;
    var SerialAPISetup_GetLongRangeMaximumPayloadSizeRequest = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            SerialAPISetup_GetLongRangeMaximumPayloadSizeRequest = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
    };
    return SerialAPISetup_GetLongRangeMaximumPayloadSizeRequest = _classThis;
})();
export { SerialAPISetup_GetLongRangeMaximumPayloadSizeRequest };
let SerialAPISetup_GetLongRangeMaximumPayloadSizeResponse = (() => {
    let _classDecorators = [subCommandResponse(SerialAPISetupCommand.GetLongRangeMaximumPayloadSize)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = SerialAPISetupResponse;
    var SerialAPISetup_GetLongRangeMaximumPayloadSizeResponse = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            SerialAPISetup_GetLongRangeMaximumPayloadSizeResponse = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.maxPayloadSize = options.maxPayloadSize;
        }
        static from(raw, _ctx) {
            const maxPayloadSize = raw.payload[0];
            return new this({
                maxPayloadSize,
            });
        }
        maxPayloadSize;
        toLogEntry() {
            const ret = { ...super.toLogEntry() };
            const message = ret.message;
            message["maximum payload size"] = `${this.maxPayloadSize} bytes`;
            delete message.payload;
            return ret;
        }
    };
    return SerialAPISetup_GetLongRangeMaximumPayloadSizeResponse = _classThis;
})();
export { SerialAPISetup_GetLongRangeMaximumPayloadSizeResponse };
// =============================================================================
let SerialAPISetup_GetSupportedRegionsRequest = (() => {
    let _classDecorators = [subCommandRequest(SerialAPISetupCommand.GetSupportedRegions)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = SerialAPISetupRequest;
    var SerialAPISetup_GetSupportedRegionsRequest = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            SerialAPISetup_GetSupportedRegionsRequest = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
    };
    return SerialAPISetup_GetSupportedRegionsRequest = _classThis;
})();
export { SerialAPISetup_GetSupportedRegionsRequest };
let SerialAPISetup_GetSupportedRegionsResponse = (() => {
    let _classDecorators = [subCommandResponse(SerialAPISetupCommand.GetSupportedRegions)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = SerialAPISetupResponse;
    var SerialAPISetup_GetSupportedRegionsResponse = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            SerialAPISetup_GetSupportedRegionsResponse = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.supportedRegions = options.supportedRegions;
        }
        static from(raw, _ctx) {
            validatePayload(raw.payload.length >= 1);
            const numRegions = raw.payload[0];
            validatePayload(numRegions > 0, raw.payload.length >= 1 + numRegions);
            const supportedRegions = [
                ...raw.payload.subarray(1, 1 + numRegions),
            ];
            return new this({
                supportedRegions,
            });
        }
        supportedRegions;
    };
    return SerialAPISetup_GetSupportedRegionsResponse = _classThis;
})();
export { SerialAPISetup_GetSupportedRegionsResponse };
let SerialAPISetup_GetRegionInfoRequest = (() => {
    let _classDecorators = [subCommandRequest(SerialAPISetupCommand.GetRegionInfo)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = SerialAPISetupRequest;
    var SerialAPISetup_GetRegionInfoRequest = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            SerialAPISetup_GetRegionInfoRequest = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.region = options.region;
        }
        static from(raw, _ctx) {
            const region = raw.payload[0];
            return new this({
                region,
            });
        }
        region;
        serialize(ctx) {
            this.payload = Bytes.from([this.region]);
            return super.serialize(ctx);
        }
        toLogEntry() {
            const ret = { ...super.toLogEntry() };
            const message = {
                ...ret.message,
                region: getEnumMemberName(RFRegion, this.region),
            };
            delete message.payload;
            ret.message = message;
            return ret;
        }
    };
    return SerialAPISetup_GetRegionInfoRequest = _classThis;
})();
export { SerialAPISetup_GetRegionInfoRequest };
let SerialAPISetup_GetRegionInfoResponse = (() => {
    let _classDecorators = [subCommandResponse(SerialAPISetupCommand.GetRegionInfo)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = SerialAPISetupResponse;
    var SerialAPISetup_GetRegionInfoResponse = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            SerialAPISetup_GetRegionInfoResponse = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.region = options.region;
            this.supportsZWave = options.supportsZWave;
            this.supportsLongRange = options.supportsLongRange;
            this.includesRegion = options.includesRegion;
        }
        static from(raw, _ctx) {
            const region = raw.payload[0];
            const supportsZWave = !!(raw.payload[1] & 0b1);
            const supportsLongRange = !!(raw.payload[1] & 0b10);
            let includesRegion;
            if (raw.payload.length > 2) {
                includesRegion = raw.payload[2];
                if (includesRegion === RFRegion.Unknown) {
                    includesRegion = undefined;
                }
            }
            return new this({
                region,
                supportsZWave,
                supportsLongRange,
                includesRegion,
            });
        }
        region;
        supportsZWave;
        supportsLongRange;
        includesRegion;
        toLogEntry() {
            const ret = { ...super.toLogEntry() };
            const message = {
                ...ret.message,
                region: getEnumMemberName(RFRegion, this.region),
                "supports Z-Wave": this.supportsZWave,
                "supports Long Range": this.supportsLongRange,
            };
            if (this.includesRegion != undefined) {
                message["includes region"] = getEnumMemberName(RFRegion, this.includesRegion);
            }
            delete message.payload;
            ret.message = message;
            return ret;
        }
    };
    return SerialAPISetup_GetRegionInfoResponse = _classThis;
})();
export { SerialAPISetup_GetRegionInfoResponse };
//# sourceMappingURL=SerialAPISetupMessages.js.map