var __esDecorate = (this && this.__esDecorate) || function (ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};
var __runInitializers = (this && this.__runInitializers) || function (thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};
import { MessagePriority, rssiToString, } from "@zwave-js/core";
import { FunctionType, Message, MessageType, expectedResponse, messageTypes, priority, } from "@zwave-js/serial";
import { parseRSSI, tryParseRSSI } from "../transport/SendDataShared.js";
let GetBackgroundRSSIRequest = (() => {
    let _classDecorators = [messageTypes(MessageType.Request, FunctionType.GetBackgroundRSSI), priority(MessagePriority.Normal), expectedResponse(FunctionType.GetBackgroundRSSI)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = Message;
    var GetBackgroundRSSIRequest = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            GetBackgroundRSSIRequest = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
    };
    return GetBackgroundRSSIRequest = _classThis;
})();
export { GetBackgroundRSSIRequest };
let GetBackgroundRSSIResponse = (() => {
    let _classDecorators = [messageTypes(MessageType.Response, FunctionType.GetBackgroundRSSI)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = Message;
    var GetBackgroundRSSIResponse = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            GetBackgroundRSSIResponse = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            // TODO: Check implementation:
            this.rssiChannel0 = options.rssiChannel0;
            this.rssiChannel1 = options.rssiChannel1;
            this.rssiChannel2 = options.rssiChannel2;
            this.rssiChannel3 = options.rssiChannel3;
        }
        static from(raw, _ctx) {
            const rssiChannel0 = parseRSSI(raw.payload, 0);
            const rssiChannel1 = parseRSSI(raw.payload, 1);
            const rssiChannel2 = tryParseRSSI(raw.payload, 2);
            const rssiChannel3 = tryParseRSSI(raw.payload, 3);
            return new this({
                rssiChannel0,
                rssiChannel1,
                rssiChannel2,
                rssiChannel3,
            });
        }
        rssiChannel0;
        rssiChannel1;
        rssiChannel2;
        rssiChannel3;
        toLogEntry() {
            const message = {
                "channel 0": rssiToString(this.rssiChannel0),
                "channel 1": rssiToString(this.rssiChannel1),
            };
            if (this.rssiChannel2 != undefined) {
                message["channel 2"] = rssiToString(this.rssiChannel2);
            }
            if (this.rssiChannel3 != undefined) {
                message["channel 3"] = rssiToString(this.rssiChannel3);
            }
            return {
                ...super.toLogEntry(),
                message,
            };
        }
    };
    return GetBackgroundRSSIResponse = _classThis;
})();
export { GetBackgroundRSSIResponse };
//# sourceMappingURL=GetBackgroundRSSIMessages.js.map