import { type MessageOrCCLogEntry, TransmitStatus, ZWaveDataRate } from "@zwave-js/core";
import { Message, type MessageBaseOptions, type MessageEncodingContext, type MessageParsingContext, type MessageRaw, type SuccessIndicator } from "@zwave-js/serial";
import { Bytes } from "@zwave-js/shared";
export declare class AssignPriorityReturnRouteRequestBase extends Message {
    static from(raw: MessageRaw, ctx: MessageParsingContext): AssignPriorityReturnRouteRequestBase;
}
export interface AssignPriorityReturnRouteRequestOptions {
    nodeId: number;
    destinationNodeId: number;
    repeaters: number[];
    routeSpeed: ZWaveDataRate;
}
export declare class AssignPriorityReturnRouteRequest extends AssignPriorityReturnRouteRequestBase {
    constructor(options: AssignPriorityReturnRouteRequestOptions & MessageBaseOptions);
    static from(_raw: MessageRaw, _ctx: MessageParsingContext): AssignPriorityReturnRouteRequest;
    nodeId: number;
    destinationNodeId: number;
    repeaters: number[];
    routeSpeed: ZWaveDataRate;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface AssignPriorityReturnRouteResponseOptions {
    hasStarted: boolean;
}
export declare class AssignPriorityReturnRouteResponse extends Message implements SuccessIndicator {
    constructor(options: AssignPriorityReturnRouteResponseOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): AssignPriorityReturnRouteResponse;
    isOK(): boolean;
    readonly hasStarted: boolean;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface AssignPriorityReturnRouteRequestTransmitReportOptions {
    transmitStatus: TransmitStatus;
}
export declare class AssignPriorityReturnRouteRequestTransmitReport extends AssignPriorityReturnRouteRequestBase implements SuccessIndicator {
    constructor(options: AssignPriorityReturnRouteRequestTransmitReportOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): AssignPriorityReturnRouteRequestTransmitReport;
    isOK(): boolean;
    readonly transmitStatus: TransmitStatus;
    toLogEntry(): MessageOrCCLogEntry;
}
//# sourceMappingURL=AssignPriorityReturnRouteMessages.d.ts.map