var __esDecorate = (this && this.__esDecorate) || function (ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};
var __runInitializers = (this && this.__runInitializers) || function (thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};
import { MAX_NODES, MAX_REPEATERS, MessagePriority, TransmitStatus, ZWaveDataRate, ZWaveError, ZWaveErrorCodes, encodeNodeID, } from "@zwave-js/core";
import { FunctionType, Message, MessageOrigin, MessageType, expectedCallback, expectedResponse, messageTypes, priority, } from "@zwave-js/serial";
import { Bytes, getEnumMemberName } from "@zwave-js/shared";
let AssignPrioritySUCReturnRouteRequestBase = (() => {
    let _classDecorators = [messageTypes(MessageType.Request, FunctionType.AssignPrioritySUCReturnRoute), priority(MessagePriority.Normal)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = Message;
    var AssignPrioritySUCReturnRouteRequestBase = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            AssignPrioritySUCReturnRouteRequestBase = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        static from(raw, ctx) {
            if (ctx.origin === MessageOrigin.Host) {
                return AssignPrioritySUCReturnRouteRequest.from(raw, ctx);
            }
            else {
                return AssignPrioritySUCReturnRouteRequestTransmitReport.from(raw, ctx);
            }
        }
    };
    return AssignPrioritySUCReturnRouteRequestBase = _classThis;
})();
export { AssignPrioritySUCReturnRouteRequestBase };
let AssignPrioritySUCReturnRouteRequest = (() => {
    let _classDecorators = [expectedResponse(FunctionType.AssignPrioritySUCReturnRoute), expectedCallback(FunctionType.AssignPrioritySUCReturnRoute)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = AssignPrioritySUCReturnRouteRequestBase;
    var AssignPrioritySUCReturnRouteRequest = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            AssignPrioritySUCReturnRouteRequest = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            if (options.repeaters.length > MAX_REPEATERS
                || options.repeaters.some((id) => id < 1 || id > MAX_NODES)) {
                throw new ZWaveError(`The repeaters array must contain at most ${MAX_REPEATERS} node IDs between 1 and ${MAX_NODES}`, ZWaveErrorCodes.Argument_Invalid);
            }
            this.nodeId = options.nodeId;
            this.repeaters = options.repeaters;
            this.routeSpeed = options.routeSpeed;
        }
        static from(_raw, _ctx) {
            throw new ZWaveError(`${this.name}: deserialization not implemented`, ZWaveErrorCodes.Deserialization_NotImplemented);
            // return new AssignPrioritySUCReturnRouteRequest({});
        }
        nodeId;
        repeaters;
        routeSpeed;
        serialize(ctx) {
            this.assertCallbackId();
            const nodeId = encodeNodeID(this.nodeId, ctx.nodeIdType);
            this.payload = Bytes.concat([
                nodeId,
                Bytes.from([
                    this.repeaters[0] ?? 0,
                    this.repeaters[1] ?? 0,
                    this.repeaters[2] ?? 0,
                    this.repeaters[3] ?? 0,
                    this.routeSpeed,
                    this.callbackId,
                ]),
            ]);
            return super.serialize(ctx);
        }
        toLogEntry() {
            return {
                ...super.toLogEntry(),
                message: {
                    "node ID": this.nodeId,
                    repeaters: this.repeaters.length > 0
                        ? this.repeaters.join(" -> ")
                        : "none",
                    "route speed": getEnumMemberName(ZWaveDataRate, this.routeSpeed),
                    "callback id": this.callbackId ?? "(not set)",
                },
            };
        }
    };
    return AssignPrioritySUCReturnRouteRequest = _classThis;
})();
export { AssignPrioritySUCReturnRouteRequest };
let AssignPrioritySUCReturnRouteResponse = (() => {
    let _classDecorators = [messageTypes(MessageType.Response, FunctionType.AssignPrioritySUCReturnRoute)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = Message;
    var AssignPrioritySUCReturnRouteResponse = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            AssignPrioritySUCReturnRouteResponse = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            // TODO: Check implementation:
            this.hasStarted = options.hasStarted;
        }
        static from(raw, _ctx) {
            const hasStarted = raw.payload[0] !== 0;
            return new this({
                hasStarted,
            });
        }
        isOK() {
            return this.hasStarted;
        }
        hasStarted;
        toLogEntry() {
            return {
                ...super.toLogEntry(),
                message: { "has started": this.hasStarted },
            };
        }
    };
    return AssignPrioritySUCReturnRouteResponse = _classThis;
})();
export { AssignPrioritySUCReturnRouteResponse };
export class AssignPrioritySUCReturnRouteRequestTransmitReport extends AssignPrioritySUCReturnRouteRequestBase {
    constructor(options) {
        super(options);
        // TODO: Check implementation:
        this.callbackId = options.callbackId;
        this.transmitStatus = options.transmitStatus;
    }
    static from(raw, _ctx) {
        const callbackId = raw.payload[0];
        const transmitStatus = raw.payload[1];
        return new this({
            callbackId,
            transmitStatus,
        });
    }
    isOK() {
        // The other statuses are technically "not OK", but they are caused by
        // not being able to contact the node. We don't want the node to be marked
        // as dead because of that
        return this.transmitStatus !== TransmitStatus.NoAck;
    }
    transmitStatus;
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "callback id": this.callbackId ?? "(not set)",
                "transmit status": getEnumMemberName(TransmitStatus, this.transmitStatus),
            },
        };
    }
}
//# sourceMappingURL=AssignPrioritySUCReturnRouteMessages.js.map