import { type MessageOrCCLogEntry, TransmitStatus } from "@zwave-js/core";
import { Message, type MessageBaseOptions, type MessageEncodingContext, type MessageParsingContext, type MessageRaw, type SuccessIndicator } from "@zwave-js/serial";
import { Bytes } from "@zwave-js/shared";
export declare class AssignReturnRouteRequestBase extends Message {
    static from(raw: MessageRaw, ctx: MessageParsingContext): AssignReturnRouteRequestBase;
}
export interface AssignReturnRouteRequestOptions {
    nodeId: number;
    destinationNodeId: number;
}
export declare class AssignReturnRouteRequest extends AssignReturnRouteRequestBase {
    constructor(options: AssignReturnRouteRequestOptions & MessageBaseOptions);
    static from(_raw: MessageRaw, _ctx: MessageParsingContext): AssignReturnRouteRequest;
    nodeId: number;
    destinationNodeId: number;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
}
export interface AssignReturnRouteResponseOptions {
    hasStarted: boolean;
}
export declare class AssignReturnRouteResponse extends Message implements SuccessIndicator {
    constructor(options: AssignReturnRouteResponseOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): AssignReturnRouteResponse;
    isOK(): boolean;
    readonly hasStarted: boolean;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface AssignReturnRouteRequestTransmitReportOptions {
    transmitStatus: TransmitStatus;
}
export declare class AssignReturnRouteRequestTransmitReport extends AssignReturnRouteRequestBase implements SuccessIndicator {
    constructor(options: AssignReturnRouteRequestTransmitReportOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): AssignReturnRouteRequestTransmitReport;
    isOK(): boolean;
    readonly transmitStatus: TransmitStatus;
    toLogEntry(): MessageOrCCLogEntry;
}
//# sourceMappingURL=AssignReturnRouteMessages.d.ts.map