import { type MessageOrCCLogEntry, TransmitStatus } from "@zwave-js/core";
import { Message, type MessageBaseOptions, type MessageEncodingContext, type MessageParsingContext, type MessageRaw, type SuccessIndicator } from "@zwave-js/serial";
import { Bytes } from "@zwave-js/shared";
export declare class DeleteReturnRouteRequestBase extends Message {
    static from(raw: MessageRaw, ctx: MessageParsingContext): DeleteReturnRouteRequestBase;
}
export interface DeleteReturnRouteRequestOptions {
    nodeId: number;
}
export declare class DeleteReturnRouteRequest extends DeleteReturnRouteRequestBase {
    constructor(options: DeleteReturnRouteRequestOptions & MessageBaseOptions);
    static from(_raw: MessageRaw, _ctx: MessageParsingContext): DeleteReturnRouteRequest;
    nodeId: number;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
}
export interface DeleteReturnRouteResponseOptions {
    hasStarted: boolean;
}
export declare class DeleteReturnRouteResponse extends Message implements SuccessIndicator {
    constructor(options: DeleteReturnRouteResponseOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): DeleteReturnRouteResponse;
    isOK(): boolean;
    readonly hasStarted: boolean;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface DeleteReturnRouteRequestTransmitReportOptions {
    transmitStatus: TransmitStatus;
}
export declare class DeleteReturnRouteRequestTransmitReport extends DeleteReturnRouteRequestBase implements SuccessIndicator {
    constructor(options: DeleteReturnRouteRequestTransmitReportOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): DeleteReturnRouteRequestTransmitReport;
    isOK(): boolean;
    readonly transmitStatus: TransmitStatus;
    toLogEntry(): MessageOrCCLogEntry;
}
//# sourceMappingURL=DeleteReturnRouteMessages.d.ts.map