var __esDecorate = (this && this.__esDecorate) || function (ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};
var __runInitializers = (this && this.__runInitializers) || function (thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};
import { MessagePriority, encodeNodeID, parseNodeID, } from "@zwave-js/core";
import { FunctionType, Message, MessageOrigin, MessageType, expectedCallback, messageTypes, priority, } from "@zwave-js/serial";
import { Bytes } from "@zwave-js/shared";
export var RemoveNodeType;
(function (RemoveNodeType) {
    RemoveNodeType[RemoveNodeType["Any"] = 1] = "Any";
    RemoveNodeType[RemoveNodeType["Controller"] = 2] = "Controller";
    RemoveNodeType[RemoveNodeType["Slave"] = 3] = "Slave";
    RemoveNodeType[RemoveNodeType["Stop"] = 5] = "Stop";
})(RemoveNodeType || (RemoveNodeType = {}));
export var RemoveNodeStatus;
(function (RemoveNodeStatus) {
    RemoveNodeStatus[RemoveNodeStatus["Ready"] = 1] = "Ready";
    RemoveNodeStatus[RemoveNodeStatus["NodeFound"] = 2] = "NodeFound";
    RemoveNodeStatus[RemoveNodeStatus["RemovingSlave"] = 3] = "RemovingSlave";
    RemoveNodeStatus[RemoveNodeStatus["RemovingController"] = 4] = "RemovingController";
    // Some controllers send this value when stopping a failed exclusion
    RemoveNodeStatus[RemoveNodeStatus["Reserved_0x05"] = 5] = "Reserved_0x05";
    RemoveNodeStatus[RemoveNodeStatus["Done"] = 6] = "Done";
    RemoveNodeStatus[RemoveNodeStatus["Failed"] = 7] = "Failed";
})(RemoveNodeStatus || (RemoveNodeStatus = {}));
var RemoveNodeFlags;
(function (RemoveNodeFlags) {
    RemoveNodeFlags[RemoveNodeFlags["HighPower"] = 128] = "HighPower";
    RemoveNodeFlags[RemoveNodeFlags["NetworkWide"] = 64] = "NetworkWide";
})(RemoveNodeFlags || (RemoveNodeFlags = {}));
let RemoveNodeFromNetworkRequestBase = (() => {
    let _classDecorators = [messageTypes(MessageType.Request, FunctionType.RemoveNodeFromNetwork), priority(MessagePriority.Controller)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = Message;
    var RemoveNodeFromNetworkRequestBase = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            RemoveNodeFromNetworkRequestBase = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        static from(raw, ctx) {
            if (ctx.origin === MessageOrigin.Host) {
                return RemoveNodeFromNetworkRequest.from(raw, ctx);
            }
            else {
                return RemoveNodeFromNetworkRequestStatusReport.from(raw, ctx);
            }
        }
    };
    return RemoveNodeFromNetworkRequestBase = _classThis;
})();
export { RemoveNodeFromNetworkRequestBase };
function testCallbackForRemoveNodeRequest(sent, received) {
    if (!(received instanceof RemoveNodeFromNetworkRequestStatusReport)) {
        return false;
    }
    switch (sent.removeNodeType) {
        case RemoveNodeType.Any:
        case RemoveNodeType.Controller:
        case RemoveNodeType.Slave:
            return (received.status === RemoveNodeStatus.Ready
                || received.status === RemoveNodeStatus.Failed);
        case RemoveNodeType.Stop:
            return (received.status === RemoveNodeStatus.Done
                // This status is sent by some controllers when stopping a failed exclusion
                || received.status === RemoveNodeStatus.Reserved_0x05
                || received.status === RemoveNodeStatus.Failed);
        default:
            return false;
    }
}
let RemoveNodeFromNetworkRequest = (() => {
    let _classDecorators = [expectedCallback(testCallbackForRemoveNodeRequest)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = RemoveNodeFromNetworkRequestBase;
    var RemoveNodeFromNetworkRequest = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            RemoveNodeFromNetworkRequest = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.removeNodeType = options.removeNodeType;
            this.highPower = !!options.highPower;
            this.networkWide = !!options.networkWide;
        }
        static from(raw, _ctx) {
            const highPower = !!(raw.payload[0] & RemoveNodeFlags.HighPower);
            const networkWide = !!(raw.payload[0] & RemoveNodeFlags.NetworkWide);
            const removeNodeType = raw.payload[0] & 0b11111;
            const callbackId = raw.payload[1];
            return new this({
                callbackId,
                removeNodeType,
                highPower,
                networkWide,
            });
        }
        /** The type of node to remove */
        removeNodeType;
        /** Whether to use high power */
        highPower = false;
        /** Whether to exclude network wide */
        networkWide = false;
        serialize(ctx) {
            this.assertCallbackId();
            let data = this.removeNodeType || RemoveNodeType.Any;
            if (this.highPower)
                data |= RemoveNodeFlags.HighPower;
            if (this.networkWide)
                data |= RemoveNodeFlags.NetworkWide;
            this.payload = Bytes.from([data, this.callbackId]);
            return super.serialize(ctx);
        }
    };
    return RemoveNodeFromNetworkRequest = _classThis;
})();
export { RemoveNodeFromNetworkRequest };
export class RemoveNodeFromNetworkRequestStatusReport extends RemoveNodeFromNetworkRequestBase {
    constructor(options) {
        super(options);
        this.status = options.status;
        if ("nodeId" in options) {
            this.statusContext = { nodeId: options.nodeId };
        }
    }
    static from(raw, ctx) {
        const callbackId = raw.payload[0];
        const status = raw.payload[1];
        switch (status) {
            case RemoveNodeStatus.Ready:
            case RemoveNodeStatus.NodeFound:
            case RemoveNodeStatus.Failed:
            case RemoveNodeStatus.Reserved_0x05:
            case RemoveNodeStatus.Done:
                // no context for the status to parse
                // TODO:
                // An application MUST time out waiting for the REMOVE_NODE_STATUS_REMOVING_SLAVE status
                // if it does not receive the indication within a 14 sec after receiving the
                // REMOVE_NODE_STATUS_NODE_FOUND status.
                return new this({
                    callbackId,
                    status,
                });
            case RemoveNodeStatus.RemovingController:
            case RemoveNodeStatus.RemovingSlave: {
                // the payload contains the node ID
                const { nodeId } = parseNodeID(raw.payload.subarray(2), ctx.nodeIdType);
                return new this({
                    callbackId,
                    status,
                    nodeId,
                });
            }
        }
    }
    status;
    statusContext;
    isOK() {
        // Some of the status codes are for unsolicited callbacks, but
        // Failed is the only NOK status.
        return this.status !== RemoveNodeStatus.Failed;
    }
    serialize(ctx) {
        this.assertCallbackId();
        this.payload = Bytes.from([this.callbackId, this.status]);
        if (this.statusContext?.nodeId != undefined) {
            this.payload = Bytes.concat([
                this.payload,
                encodeNodeID(this.statusContext.nodeId, ctx.nodeIdType),
            ]);
        }
        return super.serialize(ctx);
    }
}
//# sourceMappingURL=RemoveNodeFromNetworkRequest.js.map