import type { LogContainer } from "@zwave-js/core";
import { type BytesView } from "@zwave-js/shared";
import type { ReadableWritablePair, UnderlyingSink, UnderlyingSource } from "node:stream/web";
import { SerialLogger } from "../log/Logger.js";
import type { ZWaveSerialFrame } from "../parsers/ZWaveSerialFrame.js";
import { ZWaveSerialMode } from "./definitions.js";
/** The low level bindings used by ZWaveSerialStream.
 * The `sink` is guaranteed to be opened first, so possible setup should be done in
 * the `start` method there. */
export interface ZWaveSerialBinding {
    sink: UnderlyingSink<BytesView>;
    source: UnderlyingSource<BytesView>;
}
export type ZWaveSerialBindingFactory = () => Promise<ZWaveSerialBinding>;
/** Tests if `obj` is (probably) a ZWaveSerialBindingFactory */
export declare function isZWaveSerialBindingFactory(obj: unknown): obj is ZWaveSerialBindingFactory;
/** Re-usable stream factory to create new serial streams */
export declare class ZWaveSerialStreamFactory {
    constructor(binding: ZWaveSerialBindingFactory, loggers: LogContainer);
    private binding;
    protected logger: SerialLogger;
    createStream(): Promise<ZWaveSerialStream>;
}
/** Single-use serial stream. Has to be re-created after being closed. */
export declare class ZWaveSerialStream implements ReadableWritablePair<ZWaveSerialFrame, BytesView> {
    #private;
    constructor(source: UnderlyingSource<BytesView>, sink: UnderlyingSink<BytesView>, logger: SerialLogger);
    protected logger: SerialLogger;
    readonly readable: ReadableStream<ZWaveSerialFrame>;
    readonly writable: WritableStream<BytesView>;
    private parser;
    get mode(): ZWaveSerialMode | undefined;
    set mode(mode: ZWaveSerialMode | undefined);
    ignoreAckHighNibbleOnce(): void;
    close(): Promise<void>;
    private _isOpen;
    get isOpen(): boolean;
    private _writer;
    writeAsync(data: BytesView): Promise<void>;
}
//# sourceMappingURL=ZWaveSerialStream.d.ts.map