import { OTWFirmwareUpdateResult, Endpoint, FirmwareUpdateResult, ConfigValue, SetValueResult, ZWaveNode } from "zwave-js";
import { SupervisionResult, MaybeNotKnown } from "@zwave-js/core";
import { IncomingCommandNodeGetRawConfigParameterValue, IncomingCommandNodeSetRawConfigParameterValue } from "./node/incoming_message.js";
import { IncomingCommandEndpointGetRawConfigParameterValue, IncomingCommandEndpointSetRawConfigParameterValue } from "./endpoint/incoming_message.js";
export type SetValueResultType = {
    result: SetValueResult;
} | {
    success: boolean;
};
export declare function setValueOutgoingMessage(result: SetValueResult, schemaVersion: number): SetValueResultType;
export type FirmwareUpdateResultType = {
    result: OTWFirmwareUpdateResult | FirmwareUpdateResult;
} | {
    success: boolean;
};
export type OTWFirmwareUpdateResultType = {
    result: OTWFirmwareUpdateResult;
};
export declare function firmwareUpdateOutgoingMessage<T extends OTWFirmwareUpdateResult | FirmwareUpdateResult>(result: T, schemaVersion: number): {
    result: T;
} | {
    success: boolean;
};
export declare function setRawConfigParameterValue(message: IncomingCommandNodeSetRawConfigParameterValue | IncomingCommandEndpointSetRawConfigParameterValue, nodeOrEndpoint: ZWaveNode | Endpoint): Promise<{
    result?: SupervisionResult;
}>;
export declare function getRawConfigParameterValue(message: IncomingCommandNodeGetRawConfigParameterValue | IncomingCommandEndpointGetRawConfigParameterValue, nodeOrEndpoint: ZWaveNode | Endpoint): Promise<{
    value: MaybeNotKnown<ConfigValue>;
}>;
