"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var message_handler_exports = {};
__export(message_handler_exports, {
  ZnifferMessageHandler: () => ZnifferMessageHandler
});
module.exports = __toCommonJS(message_handler_exports);
var import_zwave_js = require("zwave-js");
var import_error = require("../error.js");
var import_command = require("./command.js");
class ZnifferMessageHandler {
  static {
    __name(this, "ZnifferMessageHandler");
  }
  driver;
  clientsController;
  zniffer;
  constructor(driver, clientsController) {
    this.driver = driver;
    this.clientsController = clientsController;
  }
  forwardEvent(data, minSchemaVersion = 38) {
    this.clientsController.clients.forEach((client) => this.sendEvent(client, data, minSchemaVersion));
  }
  sendEvent(client, data, minSchemaVersion) {
    if (client.receiveEvents && client.isConnected && client.schemaVersion >= (minSchemaVersion ?? 0)) {
      client.sendEvent(data);
    }
  }
  async handle(message) {
    const { command } = message;
    if (message.command != import_command.ZnifferCommand.init && !this.zniffer) {
      throw new Error("Zniffer is not running");
    }
    switch (message.command) {
      case import_command.ZnifferCommand.init: {
        if (this.zniffer) {
          throw new Error("Zniffer is already running");
        }
        if (message.options.logConfig === void 0) {
          message.options.logConfig = this.driver.options.logConfig;
        }
        if (message.options.securityKeys === void 0) {
          message.options.securityKeys = this.driver.options.securityKeys;
        }
        if (message.options.securityKeysLongRange === void 0) {
          message.options.securityKeysLongRange = this.driver.options.securityKeysLongRange;
        }
        this.zniffer = new import_zwave_js.Zniffer(message.devicePath, message.options);
        this.zniffer.on("ready", () => this.forwardEvent({
          source: "zniffer",
          event: "ready"
        })).on("corrupted frame", (corruptedFrame, rawDate) => this.forwardEvent({
          source: "zniffer",
          event: "corrupted frame",
          corruptedFrame,
          rawDate
        })).on("frame", (frame, rawData) => this.forwardEvent({
          source: "zniffer",
          event: "frame",
          frame,
          rawData
        })).on("error", (error) => this.forwardEvent({
          source: "zniffer",
          event: "error",
          error
        }));
        await this.zniffer.init();
        return {};
      }
      case import_command.ZnifferCommand.start: {
        await this.zniffer?.start();
        return {};
      }
      case import_command.ZnifferCommand.clearCapturedFrames: {
        this.zniffer?.clearCapturedFrames();
        return {};
      }
      case import_command.ZnifferCommand.getCaptureAsZLFBuffer: {
        return {
          capture: Buffer.from(this.zniffer.getCaptureAsZLFBuffer().buffer)
        };
      }
      case import_command.ZnifferCommand.stop: {
        await this.zniffer?.stop();
        return {};
      }
      case import_command.ZnifferCommand.destroy: {
        this.zniffer?.removeAllListeners();
        await this.zniffer?.destroy();
        this.zniffer = void 0;
        return {};
      }
      case import_command.ZnifferCommand.capturedFrames: {
        return { capturedFrames: this.zniffer.capturedFrames };
      }
      case import_command.ZnifferCommand.supportedFrequencies: {
        return { frequencies: this.zniffer.supportedFrequencies };
      }
      case import_command.ZnifferCommand.currentFrequency: {
        return { frequency: this.zniffer.currentFrequency };
      }
      case import_command.ZnifferCommand.setFrequency: {
        await this.zniffer?.setFrequency(message.frequency);
        return {};
      }
      default: {
        throw new import_error.UnknownCommandError(command);
      }
    }
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ZnifferMessageHandler
});
//# sourceMappingURL=message_handler.js.map
