"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var ObjectKeyMap_exports = {};
__export(ObjectKeyMap_exports, {
  ObjectKeyMap: () => ObjectKeyMap
});
module.exports = __toCommonJS(ObjectKeyMap_exports);
class ObjectKeyMap {
  static {
    __name(this, "ObjectKeyMap");
  }
  constructor(entries, defaultKeyProps) {
    if (entries?.length) {
      for (const [key, value] of entries) {
        this.set(key, value);
      }
    }
    this.defaultKeyProps = defaultKeyProps;
  }
  _map = /* @__PURE__ */ new Map();
  defaultKeyProps;
  has(key) {
    return this._map.has(this.keyToString(key));
  }
  get(key) {
    return this._map.get(this.keyToString(key));
  }
  set(key, value) {
    this._map.set(this.keyToString(key), value);
  }
  delete(key) {
    return this._map.delete(this.keyToString(key));
  }
  clear() {
    this._map.clear();
  }
  get size() {
    return this._map.size;
  }
  forEach(callbackfn) {
    this._map.forEach((value, keyAsString) => {
      callbackfn(value, JSON.parse(keyAsString), this);
    });
  }
  entries() {
    const map = this._map;
    return (function* () {
      const _entries = map.entries();
      let entry = _entries.next();
      while (!entry.done) {
        const objKey = JSON.parse(entry.value[0]);
        yield [objKey, entry.value[1]];
        entry = _entries.next();
      }
    })();
  }
  [Symbol.iterator]() {
    return this.entries();
  }
  keys() {
    const map = this._map;
    return (function* () {
      const _keys = map.entries();
      let key = _keys.next();
      while (!key.done) {
        const objKey = JSON.parse(key.value[0]);
        yield objKey;
        key = _keys.next();
      }
    })();
  }
  values() {
    return this._map.values();
  }
  keyToString(key) {
    const filledKey = { ...key };
    if (this.defaultKeyProps) {
      for (const [required, def] of Object.entries(this.defaultKeyProps)) {
        if (!(required in filledKey))
          filledKey[required] = def;
      }
    }
    const _key = Object.fromEntries(Object.entries(filledKey).filter(([, value]) => value != void 0).toSorted(([keyA], [keyB]) => keyA > keyB ? 1 : keyA < keyB ? -1 : 0));
    return JSON.stringify(_key);
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ObjectKeyMap
});
//# sourceMappingURL=ObjectKeyMap.js.map
