"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var Timers_exports = {};
__export(Timers_exports, {
  Interval: () => Interval,
  Timer: () => Timer,
  setInterval: () => setInterval,
  setTimer: () => setTimer
});
module.exports = __toCommonJS(Timers_exports);
class Timer {
  static {
    __name(this, "Timer");
  }
  #callback;
  #delay;
  #args;
  #inner;
  /** @internal */
  constructor(callback, delay, ...args) {
    this.#callback = callback;
    this.#delay = delay;
    this.#args = args;
    this.#inner = globalThis.setTimeout(callback, delay, ...args);
  }
  /** Clears the timeout. */
  clear() {
    globalThis.clearTimeout(this.#inner);
  }
  unref() {
    if (typeof this.#inner.unref === "function") {
      this.#inner.unref();
    }
    return this;
  }
  refresh() {
    if (typeof this.#inner.refresh === "function") {
      this.#inner.refresh();
    } else {
      globalThis.clearTimeout(this.#inner);
      globalThis.setTimeout(this.#callback, this.#delay, ...this.#args);
    }
    return this;
  }
}
class Interval {
  static {
    __name(this, "Interval");
  }
  #inner;
  /** @internal */
  constructor(inner) {
    this.#inner = inner;
  }
  /** Clears the timeout. */
  clear() {
    globalThis.clearInterval(this.#inner);
  }
  unref() {
    if (typeof this.#inner.unref === "function") {
      this.#inner.unref();
    }
    return this;
  }
}
function setTimer(callback, delay, ...args) {
  return new Timer(callback, delay, ...args);
}
__name(setTimer, "setTimer");
function setInterval(callback, delay, ...args) {
  return new Interval(globalThis.setInterval(callback, delay, ...args));
}
__name(setInterval, "setInterval");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  Interval,
  Timer,
  setInterval,
  setTimer
});
//# sourceMappingURL=Timers.js.map
