export type EventListener = ((arg1: any, arg2: any, arg3: any, arg4: any) => void) | ((arg1: any, arg2: any, arg3: any) => void) | ((arg1: any, arg2: any) => void) | ((arg1: any) => void) | ((...args: any[]) => void);
/**
 * A type-safe EventEmitter replacement that internally uses the portable _eventTarget API.
 *
 * **Usage:**
 *
 * 1.) Define event signatures
 * ```ts
 * interface TestEvents {
 * 	test1: (arg1: number) => void;
 * 	test2: () => void;
 * }
 * ```
 *
 * 2a.) direct inheritance:
 * ```ts
 * class Test extends TypedEventTarget<TestEvents> {
 * 	// class implementation
 * }
 * ```
 * 2b.) as a mixin
 * ```ts
 * interface Test extends TypedEventTarget<TestEvents> {}
 * Mixin([EventEmitter]) // This is a decorator - prepend it with an <at> sign
 * class Test extends OtherClass implements TypedEventTarget<TestEvents> {
 * 	// class implementation
 * }
 * ```
 */
export declare class TypedEventTarget<TEvents extends Record<keyof TEvents, EventListener>> {
    private _eventTarget;
    private get eventTarget();
    private _listeners;
    private get listeners();
    private _wrappers;
    private get wrappers();
    private getWrapper;
    private rememberListener;
    on<TEvent extends keyof TEvents>(event: TEvent, callback: TEvents[TEvent]): this;
    once<TEvent extends keyof TEvents>(event: TEvent, callback: TEvents[TEvent]): this;
    removeListener<TEvent extends keyof TEvents>(event: TEvent, callback: TEvents[TEvent]): this;
    removeAllListeners<TEvent extends keyof TEvents>(event?: TEvent): this;
    off<TEvent extends keyof TEvents>(event: TEvent, callback: TEvents[TEvent]): this;
    emit<TEvent extends keyof TEvents>(event: TEvent, ...args: Parameters<TEvents[TEvent]>): boolean;
}
//# sourceMappingURL=EventTarget.d.ts.map