export class Timer {
    #callback;
    #delay;
    #args;
    #inner;
    /** @internal */
    constructor(callback, delay, ...args) {
        this.#callback = callback;
        this.#delay = delay;
        this.#args = args;
        this.#inner = globalThis.setTimeout(callback, delay, ...args);
    }
    /** Clears the timeout. */
    clear() {
        globalThis.clearTimeout(this.#inner);
    }
    unref() {
        // Not supported in browsers
        if (typeof this.#inner.unref === "function") {
            this.#inner.unref();
        }
        return this;
    }
    refresh() {
        if (typeof this.#inner.refresh === "function") {
            this.#inner.refresh();
        }
        else {
            globalThis.clearTimeout(this.#inner);
            globalThis.setTimeout(this.#callback, this.#delay, ...this.#args);
        }
        return this;
    }
}
export class Interval {
    #inner;
    /** @internal */
    constructor(inner) {
        this.#inner = inner;
    }
    /** Clears the timeout. */
    clear() {
        globalThis.clearInterval(this.#inner);
    }
    unref() {
        // Not supported in browsers
        if (typeof this.#inner.unref === "function") {
            this.#inner.unref();
        }
        return this;
    }
}
export function setTimer(callback, delay, ...args) {
    return new Timer(callback, delay, ...args);
}
export function setInterval(callback, delay, ...args) {
    return new Interval(globalThis.setInterval(callback, delay, ...args));
}
//# sourceMappingURL=Timers.js.map