export var MockZWaveFrameType;
(function (MockZWaveFrameType) {
    MockZWaveFrameType[MockZWaveFrameType["Request"] = 0] = "Request";
    MockZWaveFrameType[MockZWaveFrameType["ACK"] = 1] = "ACK";
})(MockZWaveFrameType || (MockZWaveFrameType = {}));
export function createMockZWaveRequestFrame(payload, options = {}) {
    const { repeaters = [], ackRequested = true } = options;
    return {
        type: MockZWaveFrameType.Request,
        repeaters,
        ackRequested,
        payload,
    };
}
export function createMockZWaveAckFrame(options = {}) {
    const { repeaters = [], ack = true, failedHop } = options;
    return {
        type: MockZWaveFrameType.ACK,
        repeaters,
        ack,
        failedHop,
    };
}
export async function unlazyMockZWaveFrame(frame) {
    if (frame.type === MockZWaveFrameType.ACK)
        return frame;
    let payload = frame.payload;
    if (typeof payload === "function") {
        payload = await payload();
    }
    return {
        ...frame,
        payload,
    };
}
/** How long a Mock Node gets to ack a Z-Wave frame */
export const MOCK_FRAME_ACK_TIMEOUT = 1000;
//# sourceMappingURL=MockZWaveFrame.js.map