import { JsonlDB, JsonlDBOptions } from "@alcalzone/jsonl-db";
import type { DoneCallback, IStore, PacketCallback } from "mqtt";
import { Packet } from "mqtt-packet";
import { Readable as ReadableStream } from "readable-stream";
export interface MqttJsonlStoreOptions extends JsonlDBOptions<Packet> {
    maxSize: number;
    clean: boolean;
}
export declare class MqttJsonlStore implements IStore {
    db: JsonlDB<Packet>;
    constructor(path: string, options?: MqttJsonlStoreOptions);
    private getId;
    open(): Promise<void>;
    /**
     * Adds a packet to the store, a packet is anything that has a messageId property.
     * The callback is called when the packet has been stored.
     */
    put(packet: Packet, cb?: DoneCallback): this;
    /** Creates a new stream with all the packets in the store. */
    createStream(): ReadableStream;
    /**
     * Removes a packet from the store, a packet is anything that has a messageId property.
     * The callback is called when the packet has been removed.
     */
    del(packet: Pick<Packet, "messageId">, cb: PacketCallback): this;
    close(cb: DoneCallback): void;
    closeAsync(): Promise<void>;
    get(packet: Pick<Packet, "messageId">, cb: PacketCallback): this;
}
