// Utilities
import { computed } from 'vue';
import { propsFactory } from "../util/index.js";
// Composables
export const makeFileFilterProps = propsFactory({
  filterByType: String
}, 'file-accept');
export function useFileFilter(props) {
  const fileFilter = computed(() => props.filterByType ? createFilter(props.filterByType) : null);
  function filterAccepted(files) {
    if (fileFilter.value) {
      const accepted = files.filter(fileFilter.value);
      return {
        accepted,
        rejected: files.filter(f => !accepted.includes(f))
      };
    }
    return {
      accepted: files,
      rejected: []
    };
  }
  return {
    filterAccepted
  };
}
function createFilter(v) {
  const types = v.split(',').map(x => x.trim().toLowerCase());
  const extensionsToMatch = types.filter(x => x.startsWith('.'));
  const wildcards = types.filter(x => x.endsWith('/*'));
  const typesToMatch = types.filter(x => !extensionsToMatch.includes(x) && !wildcards.includes(x));
  return file => {
    const extension = file.name.split('.').at(-1)?.toLowerCase() ?? '';
    const typeGroup = file.type.split('/').at(0)?.toLowerCase() ?? '';
    return typesToMatch.includes(file.type) || extensionsToMatch.includes(`.${extension}`) || wildcards.includes(`${typeGroup}/*`);
  };
}
//# sourceMappingURL=fileFilter.js.map